/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HeaderElement;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.NameValuePair;

public class Cookie
extends NameValuePair
implements Serializable {
    protected String m_comment;
    protected String m_domain;
    protected Date m_expiryDate;
    protected String m_path;
    protected boolean m_secure;
    protected int m_version = 1;

    public Cookie(String domain, String name, String value) {
        super(name, value);
        if (name == null) {
            throw new NullPointerException("missing name");
        }
        if (value == null) {
            throw new NullPointerException("missing value");
        }
        if (domain == null) {
            throw new NullPointerException("missing domain");
        }
        this.setDomain(domain);
    }

    public String getComment() {
        return this.m_comment;
    }

    public void setComment(String comment) {
        this.m_comment = comment;
    }

    public Date getExpiryDate() {
        return this.m_expiryDate;
    }

    public void setExpiryDate(Date expiryDate) {
        this.m_expiryDate = expiryDate;
    }

    public boolean isToBeDiscarded() {
        return this.m_expiryDate != null;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public void setDomain(String domain) {
        int ndx = domain.indexOf(":");
        if (ndx != -1) {
            domain = domain.substring(0, ndx);
        }
        this.m_domain = domain.toLowerCase();
    }

    public String getPath() {
        return this.m_path;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public boolean getSecure() {
        return this.m_secure;
    }

    public void setSecure(boolean secure) {
        this.m_secure = secure;
    }

    public int getVersion() {
        return this.m_version;
    }

    public void setVersion(int version) {
        this.m_version = version;
    }

    public boolean isExpired() {
        return this.m_expiryDate != null && this.m_expiryDate.getTime() <= System.currentTimeMillis();
    }

    public int hashCode() {
        return super.hashCode() + this.m_path.hashCode() + this.m_domain.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof Cookie) {
            Cookie other = (Cookie)obj;
            return this.getName().equals(other.getName()) && this.m_path.equals(other.m_path) && this.m_domain.equals(other.m_domain);
        }
        return false;
    }

    public String toExternalForm() {
        String string = this.getName() + "=" + this.getValue();
        if (this.m_path != null) {
            string = string + "; $Path=" + this.m_path;
        }
        string = string + "; $Domain=" + this.m_domain;
        return string;
    }

    public static Header createCookieHeader(String domain, String path, Vector cookies) {
        int ndx = domain.indexOf(":");
        if (ndx != -1) {
            domain = domain.substring(0, ndx);
        }
        domain = domain.toLowerCase();
        StringBuffer value = new StringBuffer("$Version=1");
        Date now = new Date();
        Enumeration e = cookies.elements();
        while (e.hasMoreElements()) {
            Cookie cookie = (Cookie)e.nextElement();
            if (cookie.getExpiryDate() != null && !cookie.getExpiryDate().after(now) || !domain.endsWith(cookie.getDomain()) || cookie.getPath() != null && !path.startsWith(cookie.getPath())) continue;
            value.append(";");
            value.append(cookie.toExternalForm());
        }
        return new Header("Cookie", value.toString());
    }

    public String toString() {
        String string = this.toExternalForm();
        if (this.m_secure) {
            string = string + "; secure";
        }
        return string;
    }

    public static Cookie[] parse(String domain, Header setCookie) throws HttpException {
        HeaderElement[] headerElements = HeaderElement.parse(setCookie.getValue());
        Cookie[] cookies = new Cookie[headerElements.length];
        int index = 0;
        int i = 0;
        while (i < headerElements.length) {
            if (headerElements[i].getValue() == null) {
                throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nMissing value " + "for cookie '" + headerElements[i].getName() + "'");
            }
            Cookie cookie = new Cookie(domain, headerElements[i].getName(), headerElements[i].getValue());
            NameValuePair[] parameters = headerElements[i].getParameters();
            if (parameters == null) {
                cookies[index++] = cookie;
                cookie.setPath("/");
            } else {
                boolean discard_set = false;
                boolean secure_set = false;
                int j = 0;
                while (j < parameters.length) {
                    String name = parameters[j].getName().toLowerCase();
                    if ((name.equals("version") || name.equals("max-age") || name.equals("domain") || name.equals("path") || name.equals("comment") || name.equals("expires")) && parameters[j].getValue() == null) {
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nMissing value for " + parameters[j].getName() + " attribute in cookie '" + headerElements[i].getName() + "'");
                    }
                    if (name.equals("version")) {
                        try {
                            cookie.setVersion(Integer.parseInt(parameters[j].getValue()));
                        }
                        catch (NumberFormatException nfe) {
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nVersion '" + parameters[j].getValue() + "' not a number");
                        }
                    }
                    if (name.equals("path")) {
                        cookie.setPath(parameters[j].getValue());
                    } else if (name.equals("domain")) {
                        String d = parameters[j].getValue().toLowerCase();
                        if (d.charAt(0) != '.' && !d.equals(domain)) {
                            cookie.setDomain("." + d);
                        } else {
                            cookie.setDomain(d);
                        }
                    } else if (name.equals("max-age")) {
                        int age;
                        try {
                            age = Integer.parseInt(parameters[j].getValue());
                        }
                        catch (NumberFormatException e) {
                            throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nMax-Age '" + parameters[j].getValue() + "' not a number");
                        }
                        cookie.setExpiryDate(new Date(System.currentTimeMillis() + (long)age * 1000L));
                    } else if (name.equals("secure")) {
                        cookie.setSecure(true);
                    } else if (name.equals("comment")) {
                        cookie.setComment(parameters[j].getValue());
                    } else if (name.equals("expires")) {
                        try {
                            SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss z", Locale.US);
                            String expiryDate = parameters[j].getValue();
                            Date date = formatter.parse(expiryDate);
                            cookie.setExpiryDate(date);
                        }
                        catch (ParseException e) {
                            // empty catch block
                        }
                    }
                    ++j;
                }
                if (cookie.getVersion() != 1) {
                    throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nIllegal Version attribute");
                }
                if (!cookie.getDomain().equals("localhost")) {
                    if (!domain.endsWith(cookie.getDomain())) {
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nIllegal domain attribute" + cookie.getDomain());
                    }
                    if (domain.substring(0, domain.length() - cookie.getDomain().length()).indexOf(46) != -1) {
                        throw new HttpException("Bad Set-Cookie header: " + setCookie.getValue() + "\nIllegal domain attribute" + cookie.getDomain());
                    }
                }
                cookies[index++] = cookie;
            }
            ++i;
        }
        return cookies;
    }
}

