/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.validators;

import org.exolab.castor.types.Duration;
import org.exolab.castor.xml.TypeValidator;
import org.exolab.castor.xml.ValidationException;

public class DurationValidator
implements TypeValidator {
    private Duration _maxInclusive;
    private Duration _maxExclusive;
    private Duration _minInclusive;
    private Duration _minExclusive;

    public void setMaxExclusive(Duration duration) {
        this._maxExclusive = duration;
        this._maxInclusive = null;
    }

    public void setMaxInclusive(Duration duration) {
        this._maxInclusive = duration;
        this._maxExclusive = null;
    }

    public void setMinExclusive(Duration duration) {
        this._minExclusive = duration;
        this._minInclusive = null;
    }

    public void setMinInclusive(Duration duration) {
        this._minInclusive = duration;
        this._minExclusive = null;
    }

    public void validate(Object object) throws ValidationException {
        if (object == null) {
            String string = "durationValidator cannot validate a null object.";
            throw new ValidationException(string);
        }
        Duration duration = null;
        try {
            duration = Duration.parseDuration(object.toString());
        }
        catch (Exception exception) {
            String string = "Expecting a duration, received instead: ";
            string = String.valueOf(string) + object.getClass().getName();
            throw new ValidationException(string);
        }
        this.validate(duration);
    }

    public void validate(Duration duration) throws ValidationException {
        boolean bl;
        boolean bl2 = this._minInclusive != null;
        boolean bl3 = this._minExclusive != null;
        boolean bl4 = this._maxInclusive != null;
        boolean bl5 = bl = this._maxExclusive != null;
        if (bl3 && bl2) {
            throw new ValidationException("both minInclusive and minExclusiveare set up");
        }
        if (bl && bl4) {
            throw new ValidationException("both maxInclusive and maxExclusiveare set up");
        }
        if (bl2 && this._minInclusive.isGreater(duration)) {
            String string = String.valueOf(String.valueOf(duration)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minInclusive;
            throw new ValidationException(string);
        }
        if (bl3 && (this._minExclusive.isGreater(duration) || duration.equals(this._minExclusive))) {
            String string = String.valueOf(String.valueOf(duration)) + " is less than the minimum allowable ";
            string = String.valueOf(string) + "value of " + this._minExclusive;
            throw new ValidationException(string);
        }
        if (bl4 && duration.isGreater(this._maxInclusive)) {
            String string = String.valueOf(String.valueOf(duration)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxInclusive;
            throw new ValidationException(string);
        }
        if (bl && (duration.isGreater(this._maxExclusive) || duration.equals(this._maxExclusive))) {
            String string = String.valueOf(String.valueOf(duration)) + " is greater than the maximum allowable ";
            string = String.valueOf(string) + "value of " + this._maxExclusive;
            throw new ValidationException(string);
        }
    }
}

