/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema.reader;

import org.exolab.castor.xml.schema.Annotation;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.Resolver;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.AnnotationUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeGroupUnmarshaller;
import org.exolab.castor.xml.schema.reader.AttributeUnmarshaller;
import org.exolab.castor.xml.schema.reader.FacetUnmarshaller;
import org.exolab.castor.xml.schema.reader.SaxUnmarshaller;
import org.exolab.castor.xml.schema.reader.SimpleTypeDefinition;
import org.exolab.castor.xml.schema.reader.SimpleTypeUnmarshaller;
import org.exolab.castor.xml.schema.reader.WildcardUnmarshaller;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;

public class SimpleContentRestrictionUnmarshaller
extends SaxUnmarshaller {
    private SaxUnmarshaller unmarshaller;
    private int depth = 0;
    private ComplexType _complexType = null;
    private Schema _schema = null;
    private String _id = null;
    private boolean foundAnnotation = false;
    private boolean foundSimpleType = false;
    private boolean foundFacets = false;
    private boolean foundAnyAttribute = false;
    private boolean foundAttribute = false;
    private boolean foundAttributeGroup = false;
    private SimpleTypeDefinition _baseTypeDef = null;

    public SimpleContentRestrictionUnmarshaller(ComplexType complexType, AttributeList attributeList, Resolver resolver) throws SAXException {
        this.setResolver(resolver);
        this._complexType = complexType;
        this._schema = complexType.getSchema();
        this._id = attributeList.getValue("id");
        String string = attributeList.getValue("base");
        if (string != null && string.length() > 0) {
            XMLType xMLType = this._schema.getType(string);
            if (xMLType == null) {
                this._complexType.setBase(string);
            } else {
                if (xMLType.getStructureType() == 14) {
                    String string2 = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    string2 = String.valueOf(string2) + "A complex type cannot be a restriction of a simpleType.";
                    throw new IllegalStateException(string2);
                }
                if (((ComplexType)xMLType).getBaseType().getStructureType() != 14) {
                    String string3 = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    string3 = String.valueOf(string3) + "In a simpleContent when using restriction the base type must be a complexType whose base is a simpleType.";
                    throw new IllegalStateException(string3);
                }
                if (((ComplexType)xMLType).isRestricted()) {
                    String string4 = "complexType: " + this._complexType.getName() != null ? this._complexType.getName() : "\n";
                    string4 = String.valueOf(string4) + "A complex type cannot be a restriction of a restriction.";
                    throw new IllegalStateException(string4);
                }
                this._complexType.setBaseType((ComplexType)xMLType);
                this._baseTypeDef = new SimpleTypeDefinition(this._schema, xMLType.getName(), this._id);
                this._baseTypeDef.setBaseType((SimpleType)xMLType.getBaseType());
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.characters(cArray, n, n2);
        }
    }

    public String elementName() {
        return "restriction";
    }

    public void endElement(String string) throws SAXException {
        Structure structure;
        if (this.unmarshaller != null && this.depth > 0) {
            this.unmarshaller.endElement(string);
            --this.depth;
            return;
        }
        this.unmarshaller.finish();
        if ("annotation".equals(string)) {
            structure = ((AnnotationUnmarshaller)this.unmarshaller).getAnnotation();
            this._complexType.addAnnotation((Annotation)structure);
        }
        if ("anyAttribute".equals(string)) {
            structure = ((WildcardUnmarshaller)this.unmarshaller).getWildcard();
            try {
                this._complexType.setAnyAttribute((Wildcard)structure);
            }
            catch (SchemaException schemaException) {
                throw new IllegalArgumentException(schemaException.getMessage());
            }
        } else if ("attribute".equals(string)) {
            structure = ((AttributeUnmarshaller)this.unmarshaller).getAttribute();
            this._complexType.addAttributeDecl((AttributeDecl)structure);
        } else if ("attributeGroup".equals(string)) {
            structure = (AttributeGroupReference)this.unmarshaller.getObject();
            this._complexType.addAttributeGroupReference((AttributeGroupReference)structure);
        } else if ("simpleType".equals(string)) {
            structure = (SimpleType)this.unmarshaller.getObject();
            this._complexType.setBaseType((XMLType)structure);
        } else {
            this._baseTypeDef.addFacet((Facet)this.unmarshaller.getObject());
        }
        this.unmarshaller = null;
    }

    public void finish() {
        if (this.foundFacets) {
            SimpleType simpleType = this._baseTypeDef.createSimpleType();
            this._complexType.setBaseType(simpleType);
            simpleType = null;
        }
        this._complexType.setRestriction(true);
    }

    public Object getObject() {
        return null;
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.unmarshaller != null) {
            this.unmarshaller.startElement(string, attributeList);
            ++this.depth;
            return;
        }
        if (string.equals("annotation")) {
            if (this.foundFacets || this.foundSimpleType || this.foundAttribute || this.foundAttributeGroup) {
                this.error("An annotation must appear as the first child of 'restriction' elements.");
            }
            if (this.foundAnnotation) {
                this.error("Only one (1) annotation may appear as a child of 'restriction' elements.");
            }
            this.foundAnnotation = true;
            this.unmarshaller = new AnnotationUnmarshaller(attributeList);
        } else if ("simpleType".equals(string)) {
            if (this.foundSimpleType) {
                this.error("Only one (1) 'simpleType' may appear as a child of 'restriction' elements.");
            }
            if (this.foundFacets) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any facets.");
            }
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("A 'simpleType', as a child of 'restriction' elements, must appear before any attribute elements.");
            }
            this.foundSimpleType = true;
            this.unmarshaller = new SimpleTypeUnmarshaller(this._schema, attributeList);
        } else if (FacetUnmarshaller.isFacet(string)) {
            this.foundFacets = true;
            if (this.foundAttribute || this.foundAttributeGroup) {
                this.error("A 'facet', as a child of 'restriction' elements, must appear before any attribute elements.");
            }
            this.unmarshaller = new FacetUnmarshaller(string, attributeList);
        } else if ("attribute".equals(string)) {
            this.foundAttribute = true;
            this.unmarshaller = new AttributeUnmarshaller(this._schema, attributeList, this.getResolver());
        } else if ("attributeGroup".equals(string)) {
            if (attributeList.getValue("ref") == null) {
                this.error("A 'complexType' may contain referring attributeGroups, but not defining ones.");
            }
            this.foundAttributeGroup = true;
            this.unmarshaller = new AttributeGroupUnmarshaller(this._schema, attributeList);
        } else if ("anyAttribute".equals(string)) {
            this.foundAnyAttribute = true;
            this.unmarshaller = new WildcardUnmarshaller(this._complexType, this._schema, string, attributeList, this.getResolver());
        } else {
            this.illegalElement(string);
        }
        this.unmarshaller.setDocumentLocator(this.getDocumentLocator());
    }
}

