/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.Date;
import org.exolab.castor.types.OperationNotSupportedException;

public class GYearMonth
extends Date {
    private static final String YEARMONTH_FORMAT = "yyyy-MM";

    public GYearMonth() {
    }

    public GYearMonth(int n, int n2) {
        short s = (short)(n / 100);
        this.setCentury(s);
        this.setYear((short)(n %= 100));
        this.setMonth((short)n2);
    }

    public GYearMonth(short s, short s2, short s3) {
        this();
        this.setCentury(s);
        this.setYear(s2);
        this.setMonth(s3);
    }

    public GYearMonth(short[] sArray) {
        this.setValues(sArray);
    }

    public short getDay() {
        String string = "GYearMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }

    public short[] getValues() {
        short[] sArray = null;
        sArray = new short[]{this.getCentury(), this.getYear(), this.getMonth()};
        return sArray;
    }

    public static Object parse(String string) throws ParseException {
        return GYearMonth.parseGYearMonth(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GYearMonth parseGYearMonth(String string) throws ParseException {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        GYearMonth gYearMonth = new GYearMonth();
        char[] cArray = string.toCharArray();
        if (cArray[n = 0] == '-') {
            ++n;
            gYearMonth.setNegative();
        }
        boolean bl = false;
        boolean bl2 = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 7;
        while (n < cArray.length) {
            char c = cArray[n++];
            switch (c) {
                case '-': {
                    if (n4 == 7) {
                        if (n2 == 0 && n3 == 0) throw new ParseException("Bad gYearMonth Format: " + string + "\n'0000' is not allowed as a year.", n);
                        if (!bl2) {
                            throw new ParseException("Bad gYearMonth Format: " + string + "\nThe Century field must have 2 digits.", n);
                        }
                        gYearMonth.setCentury((short)n2);
                        gYearMonth.setYear((short)n3);
                        n4 = 3;
                        n3 = -1;
                    } else {
                        if (n4 != 3) throw new ParseException("Bad gYearMonth Format:" + string + "\nA gYearMonth must follow the pattern CCYY-MM-DD(Z|((+|-)hh:mm)).", n);
                        if (!bl2 || n3 != -1) throw new ParseException("Bad gYearMonth Format:" + string + "\nThe month field must have 2 digits.", n);
                        gYearMonth.setMonth((short)n2);
                        n4 = 1;
                        gYearMonth.setUTC();
                        gYearMonth.setZoneNegative();
                    }
                    bl = false;
                    bl2 = false;
                    break;
                }
                case 'Z': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gYearMonth Format:" + string + "'Z' is wrongly placed", n);
                    }
                    gYearMonth.setUTC();
                    break;
                }
                case '+': {
                    if (n4 != 3) {
                        throw new ParseException("Bad gYearMonth Format:" + string + "'+' is wrongly placed", n);
                    }
                    if (!bl2 || n3 != -1) {
                        throw new ParseException("Bad gYearMonth Format:" + string + "\nThe month field must have 2 digits.", n);
                    }
                    gYearMonth.setMonth((short)n2);
                    n4 = 1;
                    gYearMonth.setUTC();
                    bl = false;
                    bl2 = false;
                    break;
                }
                case ':': {
                    if (n4 != 1) {
                        throw new ParseException("Bad gYearMonth Format:" + string + "':' is wrongly placed", n);
                    }
                    n3 = n2;
                    n2 = -1;
                    n4 = 0;
                    bl = false;
                    bl2 = false;
                    break;
                }
                default: {
                    if (c < '0' || c > '9') throw new ParseException(String.valueOf(string) + ": Invalid character: " + c, n);
                    if (bl) {
                        if (bl2) {
                            n3 = (short)(n3 * 10 + (c - 48));
                            break;
                        }
                        n2 = (short)(n2 * 10 + (c - 48));
                        bl2 = true;
                        break;
                    }
                    bl = true;
                    n2 = (short)(c - 48);
                    break;
                }
            }
        }
        if (n4 != 3 && n4 != 0) {
            throw new ParseException("Bad gYearMonth Format: " + string + "\nA gYearMonth must follow the pattern CCYY-MM(Z|((+|-)hh:mm)).", n);
        }
        if (n4 == 3) {
            if (!bl2 || n3 != -1) throw new ParseException("Bad gYearMonth Format:" + string + "\nThe month field must have 2 digits.", n);
            gYearMonth.setMonth((short)n2);
            return gYearMonth;
        } else {
            if (n4 != 0) return gYearMonth;
            if (n2 == -1) throw new ParseException(String.valueOf(string) + "\n In a time zone, the minute field must always be present.", n);
            gYearMonth.setZone((short)n3, (short)n2);
        }
        return gYearMonth;
    }

    public void setDay(short s) {
        String string = "GYearMonth: couldn't access to the Day field.";
        throw new OperationNotSupportedException(string);
    }

    public void setValues(short[] sArray) {
        if (sArray.length != 3) {
            throw new IllegalArgumentException("GYearMonth#setValues: not the right number of values");
        }
        this.setCentury(sArray[0]);
        this.setYear(sArray[1]);
        this.setMonth(sArray[2]);
    }

    public java.util.Date toDate() {
        java.util.Date date = null;
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(YEARMONTH_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "UTC");
            int n = 0;
            n = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            n = this.isZoneNegative() ? -n : n;
            simpleTimeZone.setRawOffset(n);
            simpleTimeZone.setID(TimeZone.getAvailableIDs(n)[0]);
            simpleDateFormat.setTimeZone(simpleTimeZone);
        }
        try {
            date = simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isNegative()) {
            stringBuffer.append('-');
        }
        stringBuffer.append(this.getCentury());
        if (stringBuffer.length() == 1) {
            stringBuffer.insert(0, 0);
        }
        if (this.getYear() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getYear());
        stringBuffer.append('-');
        if (this.getMonth() / 10 == 0) {
            stringBuffer.append(0);
        }
        stringBuffer.append(this.getMonth());
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                stringBuffer.append('Z');
            } else {
                StringBuffer stringBuffer2 = new StringBuffer();
                if (this.isZoneNegative()) {
                    stringBuffer2.append('-');
                } else {
                    stringBuffer2.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneHour());
                stringBuffer2.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    stringBuffer2.append(0);
                }
                stringBuffer2.append(this.getZoneMinute());
                stringBuffer.append(stringBuffer2.toString());
                stringBuffer2 = null;
            }
        }
        return stringBuffer.toString();
    }
}

