/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import org.exolab.castor.jdo.LockNotGrantedException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.ObjectDeletedWaitingForLockException;
import org.exolab.castor.persist.TransactionContext;

final class ObjectLock
implements DepositBox {
    static final short ACTION_READ = 1;
    static final short ACTION_WRITE = 2;
    static final short ACTION_CREATE = 3;
    static final short ACTION_UPDATE = 4;
    static int idcount = 0;
    static final int[] lock = new int[0];
    private int _id;
    static final boolean TRACE = false;
    private Object _object;
    private OID _oid;
    private TransactionContext _writeLock;
    private LinkedTx _readLock;
    private LinkedTx _readWaiting;
    private int _waitCount;
    private LinkedTx _writeWaiting;
    private TransactionContext _confirmWaiting;
    private short _confirmWaitingAction;
    private int _gateCount;
    private long _timeStamp;
    private boolean _deleted;
    private boolean _invalidated;

    ObjectLock(OID oID) {
        this._oid = oID;
        int[] nArray = lock;
        synchronized (nArray) {
            this._id = idcount++;
        }
    }

    synchronized void acquireCreateLock(TransactionContext transactionContext) throws LockNotGrantedException {
        while (this._deleted || this._confirmWaiting != null) {
            Object var3_2;
            try {
                try {
                    ++this._waitCount;
                    this.wait();
                    while (this._deleted) {
                        this.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                }
                var3_2 = null;
                --this._waitCount;
            }
            catch (Throwable throwable) {
                var3_2 = null;
                --this._waitCount;
                throw throwable;
            }
        }
        if (this._readLock != null || this._writeLock != null) {
            throw new LockNotGrantedException("Lock already exist!");
        }
        this._confirmWaiting = transactionContext;
        this._confirmWaitingAction = (short)3;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireLoadLock(TransactionContext transactionContext, boolean bl, int n) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        long l = n > 0 ? System.currentTimeMillis() + (long)(n * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var7_5;
            block25: {
                block28: {
                    block27: {
                        block26: {
                            try {
                                if (this._deleted) {
                                    throw new ObjectDeletedWaitingForLockException("Object deleted");
                                }
                                if (this._confirmWaiting != null) {
                                    Object var9_9;
                                    try {
                                        try {
                                            ++this._waitCount;
                                            this.wait();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                                        }
                                        var9_9 = null;
                                        --this._waitCount;
                                        break block25;
                                    }
                                    catch (Throwable throwable) {
                                        var9_9 = null;
                                        --this._waitCount;
                                        throw throwable;
                                    }
                                }
                                if (this._writeLock == transactionContext) {
                                    var7_5 = null;
                                    this.removeWaiting(transactionContext);
                                    transactionContext.setWaitOnLock(null);
                                    return;
                                }
                                if (this._readLock == null && this._writeLock == null && bl) {
                                    this._confirmWaiting = transactionContext;
                                    this._confirmWaitingAction = (short)2;
                                    break block26;
                                }
                                if (this._readLock == null && this._writeLock == null && !bl) {
                                    if (this._object == null) {
                                        this._confirmWaiting = transactionContext;
                                        this._confirmWaitingAction = 1;
                                        break block27;
                                    }
                                    this._readLock = new LinkedTx(transactionContext, null);
                                    break block28;
                                }
                                if (this._readLock != null && !bl) {
                                    LinkedTx linkedTx = this._readLock;
                                    while (true) {
                                        if (linkedTx == null) break;
                                        if (linkedTx.tx == transactionContext) {
                                            throw new IllegalStateException("Transaction: " + transactionContext + " has already hold the write lock on " + this._oid + " Acquire shouldn't be called twice");
                                        }
                                        linkedTx = linkedTx.next;
                                    }
                                    this._readLock = new LinkedTx(transactionContext, this._readLock);
                                    var7_5 = null;
                                    this.removeWaiting(transactionContext);
                                    transactionContext.setWaitOnLock(null);
                                    return;
                                }
                                if (n == 0) {
                                    String string;
                                    if (bl) {
                                        string = "persist.writeLockTimeout";
                                        throw new LockNotGrantedException(String.valueOf(string) + this._oid + "/" + this._id + " by " + transactionContext);
                                    }
                                    string = "persist.readLockTimeout";
                                    throw new LockNotGrantedException(String.valueOf(string) + this._oid + "/" + this._id + " by " + transactionContext);
                                }
                                transactionContext.setWaitOnLock(this);
                                this.detectDeadlock(transactionContext, 10);
                                if (bl) {
                                    this._writeWaiting = new LinkedTx(transactionContext, this._writeWaiting);
                                } else {
                                    this._readWaiting = new LinkedTx(transactionContext, this._readWaiting);
                                }
                                try {
                                    long l2 = l - System.currentTimeMillis();
                                    this.wait(l2 < 0L ? 0L : l2);
                                }
                                catch (InterruptedException interruptedException) {
                                    String string;
                                    if (bl) {
                                        string = "persist.writeLockTimeout";
                                        throw new LockNotGrantedException(string);
                                    }
                                    string = "persist.readLockTimeout" + this._oid + "/" + this._id + " by " + transactionContext;
                                    throw new LockNotGrantedException(string);
                                }
                                if (this._deleted) {
                                    throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + transactionContext);
                                }
                                if (System.currentTimeMillis() > l) {
                                    n = 0;
                                }
                                this.removeWaiting(transactionContext);
                                transactionContext.setWaitOnLock(null);
                                break block25;
                            }
                            catch (Throwable throwable) {
                                var7_5 = null;
                                this.removeWaiting(transactionContext);
                                transactionContext.setWaitOnLock(null);
                                throw throwable;
                            }
                        }
                        var7_5 = null;
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        return;
                    }
                    var7_5 = null;
                    this.removeWaiting(transactionContext);
                    transactionContext.setWaitOnLock(null);
                    return;
                }
                var7_5 = null;
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
                return;
            }
            var7_5 = null;
            this.removeWaiting(transactionContext);
            transactionContext.setWaitOnLock(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void acquireUpdateLock(TransactionContext transactionContext, int n) throws LockNotGrantedException, ObjectDeletedException, ObjectDeletedWaitingForLockException {
        long l = n < 0 ? System.currentTimeMillis() + (long)(n * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var6_4;
            block15: {
                block16: {
                    try {
                        if (this._deleted || this._confirmWaiting != null) {
                            Object var8_7;
                            try {
                                try {
                                    ++this._waitCount;
                                    this.wait();
                                }
                                catch (InterruptedException interruptedException) {
                                    throw new LockNotGrantedException("Thread interrupted acquiring lock!");
                                }
                                var8_7 = null;
                                --this._waitCount;
                                break block15;
                            }
                            catch (Throwable throwable) {
                                var8_7 = null;
                                --this._waitCount;
                                throw throwable;
                            }
                        }
                        if (this._writeLock == transactionContext) {
                            var6_4 = null;
                            this.removeWaiting(transactionContext);
                            transactionContext.setWaitOnLock(null);
                            return;
                        }
                        if (this._writeLock == null && this._readLock == null) {
                            this._confirmWaiting = transactionContext;
                            this._confirmWaitingAction = (short)4;
                            break block16;
                        }
                        if (n == 0) {
                            throw new LockNotGrantedException("persist.writeLockTimeout");
                        }
                        transactionContext.setWaitOnLock(this);
                        this.detectDeadlock(transactionContext, 10);
                        this._writeWaiting = new LinkedTx(transactionContext, this._writeWaiting);
                        long l2 = System.currentTimeMillis();
                        try {
                            long l3 = l - System.currentTimeMillis();
                            this.wait(l3 < 0L ? 0L : l3);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new LockNotGrantedException("persist.writeLockTimeout" + this._oid + "/" + this._id + " by " + transactionContext);
                        }
                        if (this._deleted) {
                            throw new ObjectDeletedWaitingForLockException("object deleted" + this._oid + "/" + this._id + " by " + transactionContext);
                        }
                        if (System.currentTimeMillis() > l) {
                            n = 0;
                        }
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        break block15;
                    }
                    catch (Throwable throwable) {
                        var6_4 = null;
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        throw throwable;
                    }
                }
                var6_4 = null;
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
                return;
            }
            var6_4 = null;
            this.removeWaiting(transactionContext);
            transactionContext.setWaitOnLock(null);
        }
    }

    synchronized void confirm(TransactionContext transactionContext, boolean bl) {
        if (this._confirmWaiting == transactionContext) {
            if (bl) {
                if (this._confirmWaitingAction == 1) {
                    if (this._readLock == null) {
                        this._readLock = new LinkedTx(transactionContext, null);
                    }
                } else {
                    this._writeLock = transactionContext;
                }
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._confirmWaiting == null) {
            if (!bl) {
                if (this._writeLock != null) {
                    this._deleted = true;
                    this._object = null;
                    this._timeStamp = System.currentTimeMillis();
                    this.notifyAll();
                } else if (this._readLock != null) {
                    if (this._readLock.tx == transactionContext) {
                        this._readLock = this._readLock.next;
                    } else {
                        LinkedTx linkedTx = this._readLock;
                        while (linkedTx != null) {
                            if (linkedTx.next != null && linkedTx.next.tx == transactionContext) {
                                linkedTx.next = linkedTx.next.next;
                                this.notifyAll();
                                return;
                            }
                            linkedTx = linkedTx.next;
                        }
                    }
                }
            }
            this.notifyAll();
        } else {
            throw new IllegalStateException("Confirm transaction does not match the locked transaction");
        }
    }

    synchronized void delete(TransactionContext transactionContext) {
        if (transactionContext != this._writeLock) {
            throw new IllegalStateException("persist.notOwnerLock oid:" + this._oid + "/" + this._id + " by " + transactionContext);
        }
        try {
            this._deleted = true;
            this._object = null;
            this.notifyAll();
        }
        catch (ThreadDeath threadDeath) {
            this.release(transactionContext);
            throw threadDeath;
        }
    }

    private void detectDeadlock(TransactionContext transactionContext, int n) throws LockNotGrantedException {
        if (n <= 0) {
            return;
        }
        if (this._writeLock != null) {
            ObjectLock objectLock = this._writeLock.getWaitOnLock();
            if (objectLock != null) {
                if (objectLock._writeLock == transactionContext) {
                    throw new LockNotGrantedException("persist.deadlock");
                }
                LinkedTx linkedTx = objectLock._readLock;
                while (linkedTx != null) {
                    if (linkedTx.tx == transactionContext) {
                        throw new LockNotGrantedException("persist.deadlock");
                    }
                    linkedTx = linkedTx.next;
                }
                objectLock.detectDeadlock(transactionContext, n - 1);
            }
        } else {
            LinkedTx linkedTx = this._readLock;
            while (linkedTx != null) {
                ObjectLock objectLock = linkedTx.tx.getWaitOnLock();
                if (objectLock != null && linkedTx.tx != transactionContext) {
                    if (objectLock._writeLock == transactionContext) {
                        throw new LockNotGrantedException("persist.deadlock");
                    }
                    LinkedTx linkedTx2 = objectLock._readLock;
                    while (linkedTx2 != null) {
                        if (linkedTx2.tx == transactionContext) {
                            throw new LockNotGrantedException("persist.deadlock");
                        }
                        linkedTx2 = linkedTx2.next;
                    }
                    objectLock.detectDeadlock(transactionContext, n - 1);
                }
                linkedTx = linkedTx.next;
            }
        }
    }

    void enter() {
        ++this._gateCount;
    }

    OID getOID() {
        return this._oid;
    }

    public synchronized Object getObject(TransactionContext transactionContext) {
        if (this._confirmWaiting != null && this._confirmWaiting == transactionContext) {
            return this._object;
        }
        if (this._writeLock != null && this._writeLock == transactionContext) {
            return this._object;
        }
        LinkedTx linkedTx = this._readLock;
        while (linkedTx != null) {
            if (linkedTx.tx == transactionContext) {
                return this._object;
            }
            linkedTx = linkedTx.next;
        }
        throw new IllegalArgumentException("Transaction tx does not own this lock!");
    }

    public synchronized long getTimeStamp() {
        return this._timeStamp;
    }

    boolean hasLock(TransactionContext transactionContext, boolean bl) {
        if (this._writeLock == transactionContext) {
            return true;
        }
        if (this._confirmWaiting == transactionContext) {
            if (this._confirmWaitingAction == 2 || this._confirmWaitingAction == 3) {
                return true;
            }
            return !bl && this._confirmWaitingAction == 1;
        }
        if (bl) {
            return false;
        }
        LinkedTx linkedTx = this._readLock;
        while (linkedTx != null) {
            if (linkedTx.tx == transactionContext) {
                return true;
            }
            linkedTx = linkedTx.next;
        }
        return false;
    }

    synchronized void invalidate(TransactionContext transactionContext) {
        if (transactionContext != this._writeLock) {
            throw new IllegalStateException("persist.notOwnerLock oid:" + this._oid + "/" + this._id + " by " + transactionContext);
        }
        this._invalidated = true;
    }

    boolean isDisposable() {
        return this._gateCount == 0 && this.isFree() && this._waitCount == 0;
    }

    boolean isEntered() {
        return this._gateCount != 0;
    }

    boolean isExclusivelyOwned(TransactionContext transactionContext) {
        if (this._writeLock == null && this._readLock == null) {
            return false;
        }
        if (this._writeLock == null && this._readLock.tx == transactionContext && this._readLock.next.tx == null) {
            return true;
        }
        return this._writeLock == transactionContext && this._readLock == null;
    }

    boolean isFree() {
        return this._writeLock == null && this._readLock == null && this._writeWaiting == null && this._readWaiting == null && this._confirmWaiting == null && this._waitCount == 0;
    }

    void leave() {
        --this._gateCount;
    }

    synchronized void release(TransactionContext transactionContext) {
        try {
            transactionContext.setWaitOnLock(null);
            if (this._writeLock == transactionContext) {
                this._writeLock = null;
                if (this._invalidated || this._deleted) {
                    this._timeStamp = System.currentTimeMillis();
                    this._object = null;
                }
                this._deleted = false;
                this._invalidated = false;
            } else if (this._readLock != null) {
                if (this._readLock.tx == transactionContext) {
                    this._readLock = this._readLock.next;
                } else {
                    LinkedTx linkedTx = this._readLock;
                    while (linkedTx != null) {
                        if (linkedTx.next != null && linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                    if (linkedTx == null) {
                        throw new IllegalStateException("persist.notOwnerLock" + this._oid + "/" + this._id + " by " + transactionContext);
                    }
                }
            } else {
                throw new IllegalStateException("persist.notOwnerLock" + this._oid + "/" + this._id + " by " + transactionContext);
            }
            this.notifyAll();
        }
        catch (ThreadDeath threadDeath) {
            this.release(transactionContext);
            throw threadDeath;
        }
    }

    private void removeWaiting(TransactionContext transactionContext) {
        try {
            LinkedTx linkedTx;
            if (this._writeWaiting != null) {
                if (this._writeWaiting.tx == transactionContext) {
                    this._writeWaiting = this._writeWaiting.next;
                } else {
                    linkedTx = this._writeWaiting;
                    while (linkedTx.next != null) {
                        if (linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                }
            }
            if (this._readWaiting != null) {
                if (this._readWaiting.tx == transactionContext) {
                    this._readWaiting = this._readWaiting.next;
                } else {
                    linkedTx = this._readWaiting;
                    while (linkedTx.next != null) {
                        if (linkedTx.next.tx == transactionContext) {
                            linkedTx.next = linkedTx.next.next;
                            break;
                        }
                        linkedTx = linkedTx.next;
                    }
                }
            }
            if (this._deleted && this._readWaiting == null && this._writeWaiting == null && this._confirmWaiting == null) {
                this._deleted = false;
            }
        }
        catch (ThreadDeath threadDeath) {
            this.removeWaiting(transactionContext);
            throw threadDeath;
        }
    }

    void setOID(OID oID) {
        this._oid = oID;
    }

    public synchronized void setObject(TransactionContext transactionContext, Object object) {
        if (this._confirmWaiting != null && this._confirmWaiting == transactionContext) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
            if (this._confirmWaitingAction == 1) {
                this._readLock = new LinkedTx(transactionContext, null);
            } else {
                this._writeLock = transactionContext;
            }
            this._confirmWaiting = null;
            this.notifyAll();
        } else if (this._writeLock != null && this._writeLock == transactionContext) {
            this._timeStamp = System.currentTimeMillis();
            this._object = object;
        } else {
            throw new IllegalArgumentException("Transaction tx does not own this lock, " + this.toString() + "!");
        }
    }

    public String toString() {
        return String.valueOf(this._oid.toString()) + "/" + this._id + " " + (this._readLock == null ? "-" : "R") + "/" + (this._writeLock == null ? "-" : "W");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized void upgrade(TransactionContext transactionContext, int n) throws LockNotGrantedException, ObjectDeletedWaitingForLockException {
        if (this._confirmWaiting != null) {
            IllegalStateException illegalStateException = new IllegalStateException("Internal error: acquire when confirmWaiting is not null");
            throw illegalStateException;
        }
        if (!this.hasLock(transactionContext, false)) {
            IllegalStateException illegalStateException = new IllegalStateException("Transaction doesn't previously acquire this lock");
            throw illegalStateException;
        }
        long l = n < 0 ? System.currentTimeMillis() + (long)(n * 1000) : Long.MAX_VALUE;
        while (true) {
            Object var6_6;
            block13: {
                block12: {
                    try {
                        if (this._writeLock == transactionContext) {
                            var6_6 = null;
                            this.removeWaiting(transactionContext);
                            transactionContext.setWaitOnLock(null);
                            return;
                        }
                        if (this._writeLock == null && this._readLock.tx == transactionContext && this._readLock.next == null) {
                            this._writeLock = transactionContext;
                            this._readLock = null;
                            break block12;
                        }
                        if (n == 0) {
                            throw new LockNotGrantedException("persist.writeTimeout" + this._oid + "/" + this._id + " by " + transactionContext);
                        }
                        transactionContext.setWaitOnLock(this);
                        this.detectDeadlock(transactionContext, 10);
                        this._writeWaiting = new LinkedTx(transactionContext, this._writeWaiting);
                        long l2 = System.currentTimeMillis();
                        try {
                            long l3 = l - System.currentTimeMillis();
                            this.wait(l3 < 0L ? 0L : l3);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new LockNotGrantedException("persist.writeLockTimeout");
                        }
                        if (this._deleted) {
                            throw new IllegalStateException("internal error: object deleted" + this._oid + "/" + this._id + " by " + transactionContext);
                        }
                        if (System.currentTimeMillis() > l) {
                            n = 0;
                        }
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        break block13;
                    }
                    catch (Throwable throwable) {
                        var6_6 = null;
                        this.removeWaiting(transactionContext);
                        transactionContext.setWaitOnLock(null);
                        throw throwable;
                    }
                }
                var6_6 = null;
                this.removeWaiting(transactionContext);
                transactionContext.setWaitOnLock(null);
                return;
            }
            var6_6 = null;
            this.removeWaiting(transactionContext);
            transactionContext.setWaitOnLock(null);
        }
    }

    static class LinkedTx {
        TransactionContext tx;
        LinkedTx next;

        LinkedTx(TransactionContext transactionContext, LinkedTx linkedTx) {
            this.tx = transactionContext;
            this.next = linkedTx;
        }
    }
}

