/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.jdo.engine;

import java.util.Hashtable;
import org.exolab.castor.jdo.engine.KeyGeneratorDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.persist.KeyGeneratorFactoryRegistry;
import org.exolab.castor.persist.spi.KeyGenerator;
import org.exolab.castor.persist.spi.KeyGeneratorFactory;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Logger;
import org.exolab.castor.util.Messages;

final class KeyGeneratorRegistry {
    private Hashtable _keyGens = new Hashtable();

    KeyGeneratorRegistry() {
    }

    public KeyGenerator getKeyGenerator(PersistenceFactory persistenceFactory, KeyGeneratorDescriptor keyGeneratorDescriptor, int n, LogInterceptor logInterceptor) throws MappingException {
        String string = String.valueOf(keyGeneratorDescriptor.getName()) + " " + n;
        KeyGenerator keyGenerator = (KeyGenerator)this._keyGens.get(string);
        if (keyGenerator == null) {
            KeyGeneratorFactory keyGeneratorFactory = KeyGeneratorFactoryRegistry.getKeyGeneratorFactory(keyGeneratorDescriptor.getKeyGeneratorFactoryName());
            if (keyGeneratorFactory != null && (keyGenerator = keyGeneratorFactory.getKeyGenerator(persistenceFactory, keyGeneratorDescriptor.getParams(), n)) != null && logInterceptor != null) {
                logInterceptor.message("Key generator " + keyGeneratorDescriptor.getKeyGeneratorFactoryName() + " has been instantiated, parameters: " + keyGeneratorDescriptor.getParams());
            }
            if (keyGenerator == null) {
                Logger.getSystemLogger().println(Messages.format("mapping.noKeyGen", keyGeneratorDescriptor.getKeyGeneratorFactoryName()));
                return null;
            }
            this._keyGens.put(string, keyGenerator);
        }
        return keyGenerator;
    }
}

