/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.dsml.mozilla;

import java.util.Enumeration;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSchema;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPObjectClassSchema;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSearchResults;
import org.exolab.castor.dsml.Producer;
import org.exolab.castor.util.MimeBase64Encoder;
import org.xml.sax.DocumentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributeListImpl;

public class MozillaProducer
extends Producer {
    public MozillaProducer(DocumentHandler documentHandler, boolean bl) {
        super(documentHandler, bl);
    }

    public void produce(Enumeration enumeration) throws SAXException {
        while (enumeration.hasMoreElements()) {
            this.produce((LDAPEntry)enumeration.nextElement());
        }
    }

    public void produce(LDAPAttributeSchema lDAPAttributeSchema) throws SAXException {
        this.leaveDirectory();
        this.enterSchema();
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        attributeListImpl.addAttribute("id", "ID", lDAPAttributeSchema.getName());
        if (lDAPAttributeSchema.getSuperior() != null) {
            attributeListImpl.addAttribute("superior", "CDATA", "#" + lDAPAttributeSchema.getSuperior());
        }
        attributeListImpl.addAttribute("obsolete", null, lDAPAttributeSchema.isObsolete() ? "true" : "false");
        attributeListImpl.addAttribute("single-value", null, lDAPAttributeSchema.isSingleValued() ? "true" : "false");
        this._docHandler.startElement(this.prefix("attribute-type"), attributeListImpl);
        if (lDAPAttributeSchema.getName() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("name"), attributeListImpl);
            this._docHandler.characters(lDAPAttributeSchema.getName().toCharArray(), 0, lDAPAttributeSchema.getName().length());
            this._docHandler.endElement(this.prefix("name"));
        }
        if (lDAPAttributeSchema.getDescription() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("description"), attributeListImpl);
            this._docHandler.characters(lDAPAttributeSchema.getDescription().toCharArray(), 0, lDAPAttributeSchema.getDescription().length());
            this._docHandler.endElement(this.prefix("description"));
        }
        if (lDAPAttributeSchema.getID() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("object-identifier"), attributeListImpl);
            this._docHandler.characters(lDAPAttributeSchema.getID().toCharArray(), 0, lDAPAttributeSchema.getID().length());
            this._docHandler.endElement(this.prefix("object-identifier"));
        }
        if (lDAPAttributeSchema.getSyntaxString() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("syntax"), attributeListImpl);
            this._docHandler.characters(lDAPAttributeSchema.getSyntaxString().toCharArray(), 0, lDAPAttributeSchema.getSyntaxString().length());
            this._docHandler.endElement(this.prefix("syntax"));
        }
        this._docHandler.endElement(this.prefix("attribute-type"));
    }

    public void produce(LDAPEntry lDAPEntry) throws SAXException {
        this.leaveSchema();
        this.enterDirectory();
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        attributeListImpl.addAttribute("dn", "CDATA", lDAPEntry.getDN());
        this._docHandler.startElement(this.prefix("entry"), attributeListImpl);
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        if (lDAPAttributeSet != null) {
            char[] cArray;
            Enumeration enumeration;
            LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("objectclass");
            if (lDAPAttribute != null) {
                attributeListImpl = new AttributeListImpl();
                this._docHandler.startElement(this.prefix("objectclass"), attributeListImpl);
                enumeration = lDAPAttribute.getStringValues();
                while (enumeration.hasMoreElements()) {
                    cArray = ((String)enumeration.nextElement()).toCharArray();
                    attributeListImpl = new AttributeListImpl();
                    this._docHandler.startElement(this.prefix("oc-value"), attributeListImpl);
                    this._docHandler.characters(cArray, 0, cArray.length);
                    this._docHandler.endElement(this.prefix("oc-value"));
                }
                this._docHandler.endElement(this.prefix("objectclass"));
            }
            Enumeration enumeration2 = lDAPAttributeSet.getAttributes();
            while (enumeration2.hasMoreElements()) {
                lDAPAttribute = (LDAPAttribute)enumeration2.nextElement();
                if (lDAPAttribute.getName().equals("objectclass")) continue;
                attributeListImpl = new AttributeListImpl();
                attributeListImpl.addAttribute("name", "CDATA", lDAPAttribute.getName());
                this._docHandler.startElement(this.prefix("attr"), attributeListImpl);
                enumeration = lDAPAttribute.getByteValues();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray = (byte[])enumeration.nextElement();
                    attributeListImpl = new AttributeListImpl();
                    if (byArray == null) {
                        cArray = new char[]{};
                    } else {
                        int n = 0;
                        while (n < byArray.length) {
                            if (byArray[n] < 32 || byArray[n] == 127) break;
                            ++n;
                        }
                        if (n == byArray.length) {
                            cArray = new char[byArray.length];
                            n = 0;
                            while (n < byArray.length) {
                                cArray[n] = (char)byArray[n];
                                ++n;
                            }
                        } else {
                            MimeBase64Encoder mimeBase64Encoder = new MimeBase64Encoder();
                            mimeBase64Encoder.translate(byArray);
                            cArray = mimeBase64Encoder.getCharArray();
                            attributeListImpl.addAttribute("encoding", "NMTOKEN", "base64");
                        }
                    }
                    this._docHandler.startElement(this.prefix("value"), attributeListImpl);
                    this._docHandler.characters(cArray, 0, cArray.length);
                    this._docHandler.endElement(this.prefix("value"));
                }
                this._docHandler.endElement(this.prefix("attr"));
            }
        }
        this._docHandler.endElement(this.prefix("entry"));
    }

    public void produce(LDAPObjectClassSchema lDAPObjectClassSchema) throws SAXException {
        this.leaveDirectory();
        this.enterSchema();
        AttributeListImpl attributeListImpl = new AttributeListImpl();
        attributeListImpl.addAttribute("id", "ID", lDAPObjectClassSchema.getName());
        String[] stringArray = lDAPObjectClassSchema.getSuperiors();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            string = n == 0 ? stringArray[n] : String.valueOf(string) + "," + stringArray[n];
            ++n;
        }
        if (n > 0) {
            attributeListImpl.addAttribute("superior", "CDATA", string);
        }
        attributeListImpl.addAttribute("obsolete", null, lDAPObjectClassSchema.isObsolete() ? "true" : "false");
        switch (lDAPObjectClassSchema.getType()) {
            case 0: {
                attributeListImpl.addAttribute("type", null, "structural");
                break;
            }
            case 1: {
                attributeListImpl.addAttribute("type", null, "abstract");
                break;
            }
            case 2: {
                attributeListImpl.addAttribute("type", null, "auxiliary");
                break;
            }
        }
        this._docHandler.startElement(this.prefix("class"), attributeListImpl);
        if (lDAPObjectClassSchema.getName() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("name"), attributeListImpl);
            this._docHandler.characters(lDAPObjectClassSchema.getName().toCharArray(), 0, lDAPObjectClassSchema.getName().length());
            this._docHandler.endElement(this.prefix("name"));
        }
        if (lDAPObjectClassSchema.getDescription() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("description"), attributeListImpl);
            this._docHandler.characters(lDAPObjectClassSchema.getDescription().toCharArray(), 0, lDAPObjectClassSchema.getDescription().length());
            this._docHandler.endElement(this.prefix("description"));
        }
        if (lDAPObjectClassSchema.getID() != null) {
            attributeListImpl = new AttributeListImpl();
            this._docHandler.startElement(this.prefix("object-identifier"), attributeListImpl);
            this._docHandler.characters(lDAPObjectClassSchema.getID().toCharArray(), 0, lDAPObjectClassSchema.getID().length());
            this._docHandler.endElement(this.prefix("object-identifier"));
        }
        Enumeration enumeration = lDAPObjectClassSchema.getOptionalAttributes();
        while (enumeration.hasMoreElements()) {
            attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("ref", "CDATA", "#" + (String)enumeration.nextElement());
            attributeListImpl.addAttribute("required", null, "false");
            this._docHandler.startElement(this.prefix("attribute"), attributeListImpl);
            this._docHandler.endElement(this.prefix("attribute"));
        }
        enumeration = lDAPObjectClassSchema.getRequiredAttributes();
        while (enumeration.hasMoreElements()) {
            attributeListImpl = new AttributeListImpl();
            attributeListImpl.addAttribute("ref", "CDATA", "#" + (String)enumeration.nextElement());
            attributeListImpl.addAttribute("required", null, "true");
            this._docHandler.startElement(this.prefix("attribute"), attributeListImpl);
            this._docHandler.endElement(this.prefix("attribute"));
        }
        this._docHandler.endElement(this.prefix("class"));
    }

    public void produce(LDAPSchema lDAPSchema) throws SAXException {
        Enumeration enumeration = lDAPSchema.getObjectClasses();
        while (enumeration.hasMoreElements()) {
            this.produce((LDAPObjectClassSchema)enumeration.nextElement());
        }
        enumeration = lDAPSchema.getAttributes();
        while (enumeration.hasMoreElements()) {
            this.produce((LDAPAttributeSchema)enumeration.nextElement());
        }
    }

    public void produce(LDAPSearchResults lDAPSearchResults) throws SAXException {
        while (lDAPSearchResults.hasMoreElements()) {
            this.produce((LDAPEntry)lDAPSearchResults.nextElement());
        }
    }
}

