/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.util.parser;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.pool.Recyclable;
import org.apache.fulcrum.upload.TurbineUpload;
import org.apache.fulcrum.util.parser.BaseValueParser;
import org.apache.fulcrum.util.parser.ParameterParser;
import org.apache.log4j.Category;

public class DefaultParameterParser
extends BaseValueParser
implements ParameterParser,
Recyclable {
    private HttpServletRequest request = null;
    private byte[] uploadData = null;
    Category category = Category.getInstance((String)this.getClass().getName());

    public DefaultParameterParser() {
    }

    public DefaultParameterParser(String characterEncoding) {
        super(characterEncoding);
    }

    public void dispose() {
        this.request = null;
        this.uploadData = null;
        super.dispose();
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpServletRequest req) {
        Enumeration names;
        this.clear();
        this.uploadData = null;
        String enc = req.getCharacterEncoding();
        this.setCharacterEncoding(enc != null ? enc : "US-ASCII");
        String tmp = null;
        tmp = req.getHeader("Content-type");
        if (TurbineUpload.getAutomatic() && tmp != null && tmp.startsWith("multipart/form-data")) {
            try {
                ArrayList items = TurbineUpload.parseRequest(req);
                Iterator i = items.iterator();
                while (i.hasNext()) {
                    FileItem item = (FileItem)i.next();
                    if (item.isFormField()) {
                        String value = null;
                        try {
                            value = item.getString(this.getCharacterEncoding());
                        }
                        catch (UnsupportedEncodingException e) {
                            this.category.error((Object)(this.getCharacterEncoding() + "encoding is not supported.  Used the default " + "when reading form data."));
                            value = item.getString();
                        }
                        this.append(item.getFieldName(), value);
                        continue;
                    }
                    this.append(item.getFieldName(), item);
                }
            }
            catch (ServiceException e) {
                this.category.error((Object)new ServiceException("File upload failed", (Throwable)((Object)e)));
            }
        }
        if ((names = req.getParameterNames()) != null) {
            while (names.hasMoreElements()) {
                tmp = (String)names.nextElement();
                this.parameters.put(this.convert(tmp), req.getParameterValues(tmp));
            }
        }
        try {
            StringTokenizer st = new StringTokenizer(req.getPathInfo(), "/");
            boolean isNameTok = true;
            String pathPart = null;
            while (st.hasMoreTokens()) {
                if (isNameTok) {
                    tmp = URLDecoder.decode(st.nextToken());
                    isNameTok = false;
                    continue;
                }
                pathPart = URLDecoder.decode(st.nextToken());
                if (tmp.length() > 0) {
                    this.add(this.convert(tmp), pathPart);
                }
                isNameTok = true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.request = req;
    }

    public void setUploadData(byte[] uploadData) {
        this.uploadData = uploadData;
    }

    public byte[] setUploadData() {
        return this.uploadData;
    }

    public void append(String name, FileItem value) {
        FileItem[] items = this.getFileItems(name);
        if (items == null) {
            items = new FileItem[]{value};
            this.parameters.put(this.convert(name), items);
        } else {
            FileItem[] newItems = new FileItem[items.length + 1];
            System.arraycopy(items, 0, newItems, 0, items.length);
            newItems[items.length] = value;
            this.parameters.put(this.convert(name), newItems);
        }
    }

    public FileItem getFileItem(String name) {
        try {
            FileItem value = null;
            Object object = this.parameters.get(this.convert(name));
            if (object != null) {
                value = ((FileItem[])object)[0];
            }
            return value;
        }
        catch (ClassCastException e) {
            return null;
        }
    }

    public FileItem[] getFileItems(String name) {
        try {
            return (FileItem[])this.parameters.get(this.convert(name));
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

