/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.template;

import java.net.URL;
import java.util.Hashtable;
import javax.mail.MessagingException;
import org.apache.commons.mail.HtmlEmail;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TurbineTemplate;

public class TemplateHtmlEmail
extends HtmlEmail {
    private String htmlTemplate = null;
    private TemplateContext context = null;
    private String textTemplate = null;
    private Hashtable embmap = null;

    public TemplateHtmlEmail(TemplateContext context) throws MessagingException {
        this.context = context;
        this.embmap = new Hashtable();
    }

    public TemplateHtmlEmail setHtmlTemplate(String template) {
        this.htmlTemplate = template;
        return this;
    }

    public TemplateHtmlEmail setTextTemplate(String template) {
        this.textTemplate = template;
        return this;
    }

    public void send() throws MessagingException {
        this.context.put("mail", (Object)this);
        String htmlbody = "";
        String textbody = "";
        try {
            if (this.htmlTemplate != null) {
                htmlbody = TurbineTemplate.handleRequest(this.context, this.htmlTemplate);
            }
            if (this.textTemplate != null) {
                textbody = TurbineTemplate.handleRequest(this.context, this.textTemplate);
            }
        }
        catch (Exception e) {
            throw new MessagingException("Cannot parse template", e);
        }
        this.setHtmlMsg(htmlbody);
        this.setTextMsg(textbody);
        super.send();
    }

    public String embed(String surl, String name) throws MessagingException {
        String cid = "";
        try {
            URL url = new URL(surl);
            cid = super.embed(url, name);
            this.embmap.put(name, cid);
        }
        catch (Exception e) {
            // empty catch block
        }
        return cid;
    }

    public String getCid(String filename) {
        String cid = (String)this.embmap.get(filename);
        return "cid:" + cid;
    }
}

