/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.security.impl.db.entity;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Hashtable;
import org.apache.fulcrum.security.TurbineSecurity;
import org.apache.fulcrum.security.entity.User;
import org.apache.fulcrum.security.impl.db.entity.BaseTurbineUser;
import org.apache.fulcrum.security.session.SessionBindingEvent;

public class TurbineUser
extends BaseTurbineUser
implements User {
    private Date lastAccessDate = null;
    private Hashtable permStorage = null;
    private Hashtable tempStorage = null;

    public TurbineUser() {
        this.setCreateDate(new Date());
        this.tempStorage = new Hashtable(10);
        this.setHasLoggedIn(Boolean.FALSE);
    }

    public int getAccessCounter() {
        try {
            return (Integer)this.getPerm("_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public int getAccessCounterForSession() {
        try {
            return (Integer)this.getTemp("_session_access_counter");
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void incrementAccessCounter() {
        this.setAccessCounter(this.getAccessCounter() + 1);
    }

    public void incrementAccessCounterForSession() {
        this.setAccessCounterForSession(this.getAccessCounterForSession() + 1);
    }

    public void setAccessCounter(int cnt) {
        this.setPerm("_access_counter", new Integer(cnt));
    }

    public void setAccessCounterForSession(int cnt) {
        this.setTemp("_session_access_counter", new Integer(cnt));
    }

    public boolean isConfirmed() {
        String value = this.getConfirmed();
        return value != null && value.equals("CONFIRMED");
    }

    public boolean hasLoggedIn() {
        Boolean loggedIn = this.getHasLoggedIn();
        return loggedIn != null && loggedIn != false;
    }

    public void setHasLoggedIn(Boolean value) {
        this.setTemp("_has_logged_in", value);
    }

    private Boolean getHasLoggedIn() {
        return (Boolean)this.getTemp("_has_logged_in");
    }

    public Date getLastAccessDate() {
        if (this.lastAccessDate == null) {
            this.setLastAccessDate();
        }
        return this.lastAccessDate;
    }

    public void setLastAccessDate() {
        this.lastAccessDate = new Date();
    }

    public Object getPerm(String name) {
        return this.permStorage.get(name);
    }

    public Object getPerm(String name, Object def) {
        try {
            Object val = this.permStorage.get(name);
            return val == null ? def : val;
        }
        catch (Exception e) {
            return def;
        }
    }

    public Hashtable getPermStorage() {
        if (this.permStorage == null) {
            this.permStorage = new Hashtable();
        }
        return this.permStorage;
    }

    public void setPerm(String name, Object value) {
        TurbineUser.safeAddToHashtable(this.getPermStorage(), name, value);
    }

    public void setPermStorage(Hashtable stuff) {
        this.permStorage = stuff;
    }

    public Object getTemp(String name) {
        return this.tempStorage.get(name);
    }

    public Object getTemp(String name, Object def) {
        Object val;
        try {
            val = this.tempStorage.get(name);
            if (val == null) {
                val = def;
            }
        }
        catch (Exception e) {
            val = def;
        }
        return val;
    }

    public Hashtable getTempStorage() {
        if (this.tempStorage == null) {
            this.tempStorage = new Hashtable();
        }
        return this.tempStorage;
    }

    public Object removeTemp(String name) {
        return this.tempStorage.remove(name);
    }

    public void setTemp(String name, Object value) {
        TurbineUser.safeAddToHashtable(this.tempStorage, name, value);
    }

    public void setTempStorage(Hashtable storage) {
        this.tempStorage = storage;
    }

    public void updateLastLogin() throws Exception {
        this.setPerm("LAST_LOGIN", new Date());
    }

    public void valueBound(SessionBindingEvent event) {
    }

    public void valueUnbound(SessionBindingEvent event) {
        try {
            if (this.hasLoggedIn()) {
                TurbineSecurity.saveUser(this);
            }
        }
        catch (Exception e) {
            ByteArrayOutputStream ostr = new ByteArrayOutputStream();
            e.printStackTrace(new PrintWriter(ostr, true));
            String stackTrace = ostr.toString();
            System.out.println(stackTrace);
        }
    }

    public void setName(String v) {
        this.setUserName(v);
    }

    public String getName() {
        return this.getUserName();
    }

    public static final void safeAddToHashtable(Hashtable hash, Object key, Object value) throws NullPointerException {
        if (value == null) {
            hash.put(key, "");
        } else {
            hash.put(key, value);
        }
    }
}

