/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import java.util.Vector;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.fulcrum.schedule.JobQueue;
import org.apache.fulcrum.schedule.TurbineSchedulerService;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;

public class TurbineNonPersistentSchedulerService
extends TurbineSchedulerService {
    public void init() throws InitializationException {
        try {
            this.scheduleQueue = new JobQueue();
            this.mainLoop = new TurbineSchedulerService.MainLoop(this);
            Vector jobProps = this.getConfiguration().getVector("scheduler.jobs");
            Vector<JobEntry> jobs = new Vector<JobEntry>();
            if (!jobProps.isEmpty()) {
                int i = 0;
                while (i < jobProps.size()) {
                    String jobName = (String)jobProps.elementAt(i);
                    String jobPrefix = "scheduler.job." + jobName;
                    if (this.getConfiguration().getString(jobPrefix + ".ID", null) == null) {
                        throw new Exception("There is an error in the TurbineResources.properties file. \n" + jobPrefix + ".ID is not found.\n");
                    }
                    int sec = this.getConfiguration().getInt(jobPrefix + ".SECOND", -1);
                    int min = this.getConfiguration().getInt(jobPrefix + ".MINUTE", -1);
                    int hr = this.getConfiguration().getInt(jobPrefix + ".HOUR", -1);
                    int wkday = this.getConfiguration().getInt(jobPrefix + ".WEEKDAY", -1);
                    int dayOfMonth = this.getConfiguration().getInt(jobPrefix + ".DAY_OF_MONTH", -1);
                    JobEntry je = new JobEntry(sec, min, hr, wkday, dayOfMonth, jobName);
                    jobs.addElement(je);
                    ++i;
                }
            }
            if (jobs != null && jobs.size() > 0) {
                this.scheduleQueue.batchLoad(jobs);
                this.restart();
            }
            this.setInit(true);
        }
        catch (Exception e) {
            this.getCategory().error((Object)"Cannot initialize TurbineNonPersistentSchedulerService!: ", (Throwable)e);
        }
    }

    public JobEntry getJob(int oid) throws Exception {
        JobEntry je = new JobEntry(-1, -1, -1, -1, -1, null);
        je.setPrimaryKey((ObjectKey)new NumberKey(oid));
        return this.scheduleQueue.getJob(je);
    }

    public void addJob(JobEntry je) throws Exception {
        this.scheduleQueue.add(je);
        this.restart();
    }

    public void removeJob(JobEntry je) throws Exception {
        this.scheduleQueue.remove(je);
        this.restart();
    }

    public void updateJob(JobEntry je) throws Exception {
        try {
            je.calcRunTime();
        }
        catch (Exception e) {
            this.getCategory().error((Object)("Problem updating Scheduled Job: " + e));
        }
        this.scheduleQueue.modify(je);
        this.restart();
    }
}

