/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.schedule;

import com.workingdogs.village.DataSetException;
import com.workingdogs.village.QueryDataSet;
import com.workingdogs.village.Record;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.fulcrum.schedule.JobEntry;
import org.apache.fulcrum.schedule.JobEntryPeer;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.map.MapBuilder;
import org.apache.torque.map.TableMap;
import org.apache.torque.om.NumberKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.util.BasePeer;
import org.apache.torque.util.Criteria;

public abstract class BaseJobEntryPeer
extends BasePeer {
    public static final String DATABASE_NAME = "default";
    public static final String TABLE_NAME = "TURBINE_SCHEDULED_JOB";
    public static final String JOB_ID;
    public static final String JOB_SECOND;
    public static final String JOB_MINUTE;
    public static final String JOB_HOUR;
    public static final String WEEK_DAY;
    public static final String DAY_OF_MONTH;
    public static final String TASK;
    public static final String EMAIL;
    public static final String JOB_PROPERTY;
    public static final int numColumns = 9;
    protected static final String CLASSNAME_DEFAULT = "org.apache.fulcrum.schedule.JobEntry";
    protected static final Class CLASS_DEFAULT;

    public static MapBuilder getMapBuilder() throws TorqueException {
        return BasePeer.getMapBuilder((String)"org.apache.fulcrum.schedule.map.JobEntryMapBuilder");
    }

    private static Class initClass(String className) {
        Class<?> c;
        block2: {
            c = null;
            try {
                c = Class.forName(className);
            }
            catch (Throwable t) {
                BasePeer.category.error((Object)"A FATAL ERROR has occurred which should not have happened under any circumstance.  Please notify the Turbine developers <turbine-dev@jakarta.apache.org> and give as many details as possible (including the error stack trace).", t);
                if (!(t instanceof Error)) break block2;
                throw (Error)t.fillInStackTrace();
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List resultSet2Objects(ResultSet results) throws TorqueException {
        try {
            QueryDataSet qds = null;
            List rows = null;
            try {
                qds = new QueryDataSet(results);
                rows = BasePeer.getSelectResults((QueryDataSet)qds);
                Object var4_5 = null;
                if (qds == null) return BaseJobEntryPeer.populateObjects(rows);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (qds == null) throw throwable;
                qds.close();
                throw throwable;
            }
            qds.close();
            return BaseJobEntryPeer.populateObjects(rows);
        }
        catch (SQLException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static ObjectKey doInsert(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doInsert(criteria, (Connection)null);
    }

    public static ObjectKey doInsert(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null) {
            return BasePeer.doInsert((Criteria)criteria);
        }
        return BasePeer.doInsert((Criteria)criteria, (Connection)con);
    }

    public static void addSelectColumns(Criteria criteria) throws TorqueException {
        criteria.addSelectColumn(JOB_ID);
        criteria.addSelectColumn(JOB_SECOND);
        criteria.addSelectColumn(JOB_MINUTE);
        criteria.addSelectColumn(JOB_HOUR);
        criteria.addSelectColumn(WEEK_DAY);
        criteria.addSelectColumn(DAY_OF_MONTH);
        criteria.addSelectColumn(TASK);
        criteria.addSelectColumn(EMAIL);
        criteria.addSelectColumn(JOB_PROPERTY);
    }

    public static JobEntry row2Object(Record row, int offset, Class cls) throws TorqueException {
        try {
            JobEntry obj = (JobEntry)cls.newInstance();
            BaseJobEntryPeer.populateObject(row, offset, obj);
            obj.setModified(false);
            obj.setNew(false);
            return obj;
        }
        catch (InstantiationException e) {
            throw new TorqueException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static void populateObject(Record row, int offset, JobEntry obj) throws TorqueException {
        try {
            if (row.getValue(offset + 0).asBigDecimal() instanceof Object) {
                if (null == row.getValue(offset + 0).asBigDecimal()) {
                    obj.setJobId(null);
                } else {
                    obj.setJobId(new NumberKey(row.getValue(offset + 0).asBigDecimal()));
                }
            }
            obj.setSecond(row.getValue(offset + 1).asInt());
            obj.setMinute(row.getValue(offset + 2).asInt());
            obj.setHour(row.getValue(offset + 3).asInt());
            obj.setWeekDay(row.getValue(offset + 4).asInt());
            obj.setDayOfMonth(row.getValue(offset + 5).asInt());
            obj.setTask(row.getValue(offset + 6).asString());
            obj.setEmail(row.getValue(offset + 7).asString());
            obj.setProperty(row.getValue(offset + 8).asBytes());
        }
        catch (DataSetException e) {
            throw new TorqueException((Throwable)e);
        }
    }

    public static List doSelect(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria));
    }

    public static List doSelect(Criteria criteria, Connection con) throws TorqueException {
        return BaseJobEntryPeer.populateObjects(BaseJobEntryPeer.doSelectVillageRecords(criteria, con));
    }

    public static List doSelectVillageRecords(Criteria criteria) throws TorqueException {
        return BaseJobEntryPeer.doSelectVillageRecords(criteria, null);
    }

    public static List doSelectVillageRecords(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getSelectColumns().size() == 0) {
            BaseJobEntryPeer.addSelectColumns(criteria);
        }
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null) {
            return BasePeer.doSelect((Criteria)criteria);
        }
        return BasePeer.doSelect((Criteria)criteria, (Connection)con);
    }

    public static List populateObjects(List records) throws TorqueException {
        ArrayList<JobEntry> results = new ArrayList<JobEntry>(records.size());
        int i = 0;
        while (i < records.size()) {
            Record row = (Record)records.get(i);
            results.add(JobEntryPeer.row2Object(row, 1, JobEntryPeer.getOMClass()));
            ++i;
        }
        return results;
    }

    public static Class getOMClass() throws TorqueException {
        return CLASS_DEFAULT;
    }

    public static void doUpdate(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.doUpdate(criteria, (Connection)null);
    }

    public static void doUpdate(Criteria criteria, Connection con) throws TorqueException {
        Criteria selectCriteria = new Criteria(DATABASE_NAME, 2);
        selectCriteria.put((Object)JOB_ID, criteria.remove(JOB_ID));
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null) {
            BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria);
        } else {
            BasePeer.doUpdate((Criteria)selectCriteria, (Criteria)criteria, (Connection)con);
        }
    }

    public static void doDelete(Criteria criteria) throws TorqueException {
        BaseJobEntryPeer.doDelete(criteria, (Connection)null);
    }

    public static void doDelete(Criteria criteria, Connection con) throws TorqueException {
        if (criteria.getDbName() == Torque.getDefaultDB()) {
            criteria.setDbName(DATABASE_NAME);
        }
        if (con == null) {
            BasePeer.doDelete((Criteria)criteria);
        } else {
            BasePeer.doDelete((Criteria)criteria, (Connection)con);
        }
    }

    public static List doSelect(JobEntry obj) throws TorqueException {
        return BaseJobEntryPeer.doSelect(BaseJobEntryPeer.buildCriteria(obj));
    }

    public static void doInsert(JobEntry obj) throws TorqueException {
        obj.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(obj)));
        obj.setNew(false);
        obj.setModified(false);
    }

    public static void doUpdate(JobEntry obj) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(obj));
        obj.setModified(false);
    }

    public static void doDelete(JobEntry obj) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildCriteria(obj));
    }

    public static void doInsert(JobEntry obj, Connection con) throws TorqueException {
        obj.setPrimaryKey(BaseJobEntryPeer.doInsert(BaseJobEntryPeer.buildCriteria(obj), con));
        obj.setNew(false);
        obj.setModified(false);
    }

    public static void doUpdate(JobEntry obj, Connection con) throws TorqueException {
        BaseJobEntryPeer.doUpdate(BaseJobEntryPeer.buildCriteria(obj), con);
        obj.setModified(false);
    }

    public static void doDelete(JobEntry obj, Connection con) throws TorqueException {
        BaseJobEntryPeer.doDelete(BaseJobEntryPeer.buildCriteria(obj), con);
    }

    public static Criteria buildCriteria(JobEntry obj) {
        Criteria criteria = new Criteria(DATABASE_NAME);
        if (!obj.isNew()) {
            criteria.add(JOB_ID, (Object)obj.getJobId());
        }
        criteria.add(JOB_SECOND, obj.getSecond());
        criteria.add(JOB_MINUTE, obj.getMinute());
        criteria.add(JOB_HOUR, obj.getHour());
        criteria.add(WEEK_DAY, obj.getWeekDay());
        criteria.add(DAY_OF_MONTH, obj.getDayOfMonth());
        criteria.add(TASK, (Object)obj.getTask());
        criteria.add(EMAIL, (Object)obj.getEmail());
        criteria.add(JOB_PROPERTY, (Object)obj.getProperty());
        return criteria;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JobEntry retrieveByPK(ObjectKey pk) throws TorqueException {
        Connection db = null;
        JobEntry retVal = null;
        try {
            db = Torque.getConnection((String)DATABASE_NAME);
            retVal = BaseJobEntryPeer.retrieveByPK(pk, db);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Torque.closeConnection((Connection)db);
            throw throwable;
        }
        Torque.closeConnection((Connection)db);
        return retVal;
    }

    public static JobEntry retrieveByPK(ObjectKey pk, Connection con) throws TorqueException {
        Criteria criteria = new Criteria();
        criteria.add(JOB_ID, (Object)pk);
        List v = BaseJobEntryPeer.doSelect(criteria, con);
        if (v.size() != 1) {
            throw new TorqueException("Failed to select one and only one row.");
        }
        return (JobEntry)v.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List retrieveByPKs(List pks) throws TorqueException {
        Connection db = null;
        List retVal = null;
        try {
            db = Torque.getConnection((String)DATABASE_NAME);
            retVal = BaseJobEntryPeer.retrieveByPKs(pks, db);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            Torque.closeConnection((Connection)db);
            throw throwable;
        }
        Torque.closeConnection((Connection)db);
        return retVal;
    }

    public static List retrieveByPKs(List pks, Connection dbcon) throws TorqueException {
        List objs = null;
        if (pks == null || pks.size() == 0) {
            objs = new LinkedList();
        } else {
            Criteria criteria = new Criteria();
            criteria.addIn(JOB_ID, pks);
            objs = BaseJobEntryPeer.doSelect(criteria, dbcon);
        }
        return objs;
    }

    protected static TableMap getTableMap() throws TorqueException {
        return Torque.getDatabaseMap((String)DATABASE_NAME).getTable(TABLE_NAME);
    }

    static {
        DATABASE_NAME = DATABASE_NAME;
        TABLE_NAME = TABLE_NAME;
        JOB_ID = "TURBINE_SCHEDULED_JOB.JOB_ID";
        JOB_SECOND = "TURBINE_SCHEDULED_JOB.JOB_SECOND";
        JOB_MINUTE = "TURBINE_SCHEDULED_JOB.JOB_MINUTE";
        JOB_HOUR = "TURBINE_SCHEDULED_JOB.JOB_HOUR";
        WEEK_DAY = "TURBINE_SCHEDULED_JOB.WEEK_DAY";
        DAY_OF_MONTH = "TURBINE_SCHEDULED_JOB.DAY_OF_MONTH";
        TASK = "TURBINE_SCHEDULED_JOB.TASK";
        EMAIL = "TURBINE_SCHEDULED_JOB.EMAIL";
        JOB_PROPERTY = "TURBINE_SCHEDULED_JOB.JOB_PROPERTY";
        if (Torque.isInit()) {
            try {
                BaseJobEntryPeer.getMapBuilder();
            }
            catch (Exception e) {
                BasePeer.category.error((Object)"Could not initialize Peer", (Throwable)e);
            }
        } else {
            Torque.registerMapBuilder((String)"org.apache.fulcrum.schedule.map.JobEntryMapBuilder");
        }
        numColumns = 9;
        CLASSNAME_DEFAULT = CLASSNAME_DEFAULT;
        CLASS_DEFAULT = BaseJobEntryPeer.initClass(CLASSNAME_DEFAULT);
    }
}

