/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.mimetype.util;

import java.util.ArrayList;

public class MimeType
implements Cloneable {
    public static MimeType TEXT_HTML = new MimeType("text/html");
    public static MimeType TEXT_WML = new MimeType("text/vnd.wap.wml");
    public static MimeType TEXT_HDML = new MimeType("text/x-hdml");
    public static MimeType TEXT_CHTML = new MimeType("text/x-chtml");
    public static MimeType TEXT_PLAIN = new MimeType("text/plain");
    public static MimeType MULTIPART = new MimeType("multipart/*");
    public static MimeType MULTIPART_FORM_DATA = new MimeType("multipart/form-data");
    public static MimeType APPLICATION_POSTSCRIPT = new MimeType("application/postscript");
    public static MimeType APPLICATION_OCTET_STREAM = new MimeType("application/octet-stream");
    public static MimeType APPLICATION_X_JAVA_AGENT = new MimeType("application/x-java-agent");
    public static MimeType APPLICATION_X_WWW_FORM_URLENCODED = new MimeType("application/x-www-form-urlencoded");
    public static MimeType MESSAGE_HTTP = new MimeType("message/http");
    public static MimeType TEXT_CSS = new MimeType("text/css");
    public static MimeType TEXT = new MimeType("text/*");
    public static MimeType IMAGE_GIF = new MimeType("image/gif");
    public static MimeType IMAGE_JPEG = new MimeType("image/jpeg");
    public static MimeType IMAGE_WBMP = new MimeType("image/vnd.wap.wbmp");
    public static final int NO_MATCH = 0;
    public static final int MATCH_TYPE = 1;
    public static final int MATCH_SUBTYPE = 2;
    public static final int MATCH_SPECIFIC_SUBTYPE = 3;
    private String mimeType;
    private String mimeSubtype;
    private String[] parameterNames;
    private String[] parameterValues;
    private String mimeTypeString;

    public MimeType(String spec) {
        this(spec, true);
    }

    /*
     * Unable to fully structure code
     */
    public MimeType(String spec, boolean parsep) {
        block16: {
            super();
            start = 0;
            look = '\u0000';
            length = spec.length();
            while (start < length && Character.isWhitespace(spec.charAt(start))) {
                ++start;
            }
            while (length > start && Character.isWhitespace(spec.charAt(length - 1))) {
                --length;
            }
            sb = new StringBuffer();
            if (true) ** GOTO lbl17
            do {
                sb.append(look);
                ++start;
lbl17:
                // 2 sources

                if (start >= length) break;
                v0 = spec.charAt(start);
                look = v0;
            } while (v0 != '/');
            if (look != '/') {
                throw new IllegalArgumentException("Syntax error in MIME type " + spec);
            }
            this.mimeType = sb.toString();
            ++start;
            sb.setLength(0);
            while (start < length && (look = spec.charAt(start)) != ';' && !Character.isWhitespace(look)) {
                sb.append(look);
                ++start;
            }
            this.mimeSubtype = sb.toString();
            if (!parsep) break block16;
            while (start < length && Character.isWhitespace(spec.charAt(start))) {
                ++start;
            }
            if (start >= length) break block16;
            if (spec.charAt(start) != ';') {
                throw new IllegalArgumentException("Syntax error in MIME type parameters " + spec);
            }
            ++start;
            na = new ArrayList<String>(4);
            va = new ArrayList<String>(4);
            ** GOTO lbl81
            {
                ++start;
                do {
                    if (start < length && Character.isWhitespace(spec.charAt(start))) continue block5;
                    sb.setLength(0);
                    while (start < length && (look = spec.charAt(start)) != '=' && !Character.isWhitespace(look)) {
                        sb.append(Character.toLowerCase(look));
                        ++start;
                    }
                    name = sb.toString();
                    while (start < length && Character.isWhitespace(spec.charAt(start))) {
                        ++start;
                    }
                    if (spec.charAt(start) != '=') {
                        throw new IllegalArgumentException("Syntax error in MIME type parameters " + spec);
                    }
                    ++start;
                    while (start < length && Character.isWhitespace(spec.charAt(start))) {
                        ++start;
                    }
                    sb.setLength(0);
                    delim = 59;
                    if (spec.charAt(start) == '\"') {
                        ++start;
                        delim = 34;
                    }
                    while (!(start >= length || (look = spec.charAt(start)) == delim || delim != 34 && Character.isWhitespace(look))) {
                        sb.append(look);
                        ++start;
                    }
                    while (start < length && spec.charAt(start) != ';') {
                        ++start;
                    }
                    ++start;
                    value = sb.toString();
                    na.add(name);
                    va.add(value);
lbl81:
                    // 2 sources

                } while (start < length);
            }
            this.parameterNames = na.toArray(new String[na.size()]);
            this.parameterValues = va.toArray(new String[va.size()]);
        }
    }

    public MimeType(String type, String subtype) {
        this(type, subtype, null, null);
    }

    public MimeType(String type, String subtype, String[] names, String[] values) {
        if (type == null || subtype == null) {
            throw new NullPointerException("MIME type or subtype missing");
        }
        this.mimeType = type.trim();
        this.mimeSubtype = subtype.trim();
        this.parameterNames = names;
        this.parameterValues = values;
    }

    public int match(MimeType other) {
        if (this.mimeType.equals("*") || other.mimeType.equals("*")) {
            return 1;
        }
        if (!this.mimeType.equalsIgnoreCase(other.mimeType)) {
            return 0;
        }
        if (this.mimeSubtype.equals("*") || other.mimeSubtype.equals("*")) {
            return 2;
        }
        if (!this.mimeSubtype.equalsIgnoreCase(other.mimeSubtype)) {
            return 0;
        }
        return 3;
    }

    public String getType() {
        return this.mimeType;
    }

    public String getSubtype() {
        return this.mimeSubtype;
    }

    public String getTypes() {
        return this.mimeType + '/' + this.mimeSubtype;
    }

    public boolean hasParameter(String param) {
        String[] na = this.parameterNames;
        if (na != null) {
            int i = 0;
            while (i < na.length) {
                if (na[i].equalsIgnoreCase(param)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public String getParameter(String param) {
        String[] na = this.parameterNames;
        if (na != null) {
            String[] va = this.parameterValues;
            int i = 0;
            while (i < na.length) {
                if (na[i].equalsIgnoreCase(param)) {
                    return va[i];
                }
                ++i;
            }
        }
        return null;
    }

    public synchronized void setParameter(String param, String value) {
        if (this.parameterNames != null) {
            int i = 0;
            while (i < this.parameterNames.length) {
                if (this.parameterNames[i].equalsIgnoreCase(param)) {
                    this.parameterValues[i] = value;
                    this.mimeTypeString = null;
                    return;
                }
                ++i;
            }
        }
        this.addParameter(param, value);
    }

    public void addParameter(String param, String value) {
        this.addParameters(new String[]{param}, new String[]{value});
    }

    public synchronized void addParameters(String[] params, String[] values) {
        if (params == null || values == null || params.length != values.length) {
            throw new IllegalArgumentException("Incorrect MIME type parameters");
        }
        if (this.parameterNames != null) {
            String[] na = new String[this.parameterNames.length + params.length];
            String[] va = new String[this.parameterValues.length + values.length];
            System.arraycopy(this.parameterNames, 0, na, 0, this.parameterNames.length);
            System.arraycopy(params, 0, na, this.parameterNames.length, params.length);
            System.arraycopy(this.parameterValues, 0, va, 0, this.parameterValues.length);
            System.arraycopy(values, 0, va, this.parameterValues.length, values.length);
            this.parameterNames = na;
            this.parameterValues = va;
        } else {
            this.parameterNames = params;
            this.parameterValues = values;
        }
        this.mimeTypeString = null;
    }

    public String toString() {
        if (this.mimeTypeString == null) {
            StringBuffer sb = new StringBuffer(this.mimeType);
            sb.append('/');
            sb.append(this.mimeSubtype);
            String[] na = this.parameterNames;
            if (na != null) {
                String[] va = this.parameterValues;
                int i = 0;
                while (i < va.length) {
                    sb.append(';');
                    sb.append(na[i]);
                    if (va[i] != null) {
                        sb.append('=');
                        sb.append(va[i]);
                    }
                    ++i;
                }
            }
            this.mimeTypeString = sb.toString();
        }
        return this.mimeTypeString;
    }

    static {
        NO_MATCH = 0;
        MATCH_TYPE = 1;
        MATCH_SUBTYPE = 2;
        MATCH_SPECIFIC_SUBTYPE = 3;
    }
}

