/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.jsp;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.fulcrum.InitializationException;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.jsp.JspService;
import org.apache.fulcrum.template.BaseTemplateEngineService;
import org.apache.fulcrum.template.TemplateContext;
import org.apache.fulcrum.template.TurbineTemplate;

public class TurbineJspService
extends BaseTemplateEngineService
implements JspService {
    private String[] templatePaths;
    private String[] relativeTemplatePaths;
    private int bufferSize;

    public void init() throws InitializationException {
        try {
            this.initJsp();
            this.registerConfiguration("jsp");
            this.setInit(true);
        }
        catch (Exception e) {
            throw new InitializationException("TurbineJspService failed to initialize", e);
        }
    }

    public int getDefaultBufferSize() {
        return this.bufferSize;
    }

    public String handleRequest(TemplateContext context, String template) throws ServiceException {
        return "";
    }

    public void handleRequest(TemplateContext context, String template, OutputStream outputStream) throws ServiceException {
    }

    public void handleRequest(TemplateContext context, String template, Writer writer) throws ServiceException {
    }

    private void initJsp() throws Exception {
        this.templatePaths = TurbineTemplate.translateTemplatePaths(this.getConfiguration().getStringArray("templates"));
        this.relativeTemplatePaths = this.getConfiguration().getStringArray("templates");
        int i = 0;
        while (i < this.relativeTemplatePaths.length) {
            if (!this.relativeTemplatePaths[i].startsWith("/")) {
                this.relativeTemplatePaths[i] = "/" + this.relativeTemplatePaths[i];
            }
            ++i;
        }
        this.bufferSize = this.getConfiguration().getInt("buffer.size", 8192);
        this.registerConfiguration("jsp");
    }

    public boolean templateExists(String template) {
        return TurbineTemplate.templateExists(template, this.templatePaths);
    }

    public String getRelativeTemplateName(String template) {
        String[] testTemplatePath = new String[1];
        int i = 0;
        while (i < this.relativeTemplatePaths.length) {
            testTemplatePath[0] = this.getRealPath(this.relativeTemplatePaths[i]);
            if (TurbineTemplate.templateExists(template, testTemplatePath)) {
                return this.relativeTemplatePaths[i] + template;
            }
            ++i;
        }
        return null;
    }
}

