/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.validator;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.validator.Constraint;
import org.apache.fulcrum.intake.validator.DefaultValidator;
import org.apache.fulcrum.intake.validator.ValidationException;

public class DateStringValidator
extends DefaultValidator {
    private static final String DEFAULT_DATE_MESSAGE = "Date could not be parsed";
    private List dateFormats;
    private String dateFormatMessage;
    private boolean flexible;
    private DateFormat df;
    private SimpleDateFormat sdf;

    public DateStringValidator(Map paramMap) throws ServiceException {
        this();
        this.init(paramMap);
    }

    public DateStringValidator() {
    }

    public void init(Map paramMap) throws ServiceException {
        super.init(paramMap);
        this.dateFormats = new ArrayList(5);
        Constraint constraint = (Constraint)paramMap.get("format");
        if (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
        }
        int i = 1;
        constraint = (Constraint)paramMap.get("format" + i);
        while (constraint != null) {
            this.dateFormats.add(constraint.getValue());
            this.setDateFormatMessage(constraint.getMessage());
            constraint = (Constraint)paramMap.get("format" + ++i);
        }
        if (this.dateFormatMessage == null || this.dateFormatMessage.equals("")) {
            this.dateFormatMessage = DEFAULT_DATE_MESSAGE;
        }
        if ((constraint = (Constraint)paramMap.get("flexible")) != null) {
            this.flexible = Boolean.valueOf(constraint.getValue());
        }
        if (this.dateFormats.size() == 0 || this.flexible) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
        if (this.dateFormats.size() != 0) {
            this.sdf = new SimpleDateFormat();
        }
    }

    protected void doAssertValidity(String testValue) throws ValidationException {
        try {
            this.parse(testValue);
        }
        catch (ParseException e) {
            this.message = this.dateFormatMessage;
            throw new ValidationException(this.dateFormatMessage);
        }
    }

    public Date parse(String s) throws ParseException {
        Date date = null;
        if (s == null) {
            throw new ParseException("Input string was null", -1);
        }
        int i = 0;
        while (i < this.dateFormats.size()) {
            this.sdf.applyPattern((String)this.dateFormats.get(i));
            try {
                date = this.sdf.parse(s);
            }
            catch (ParseException e) {
                // empty catch block
            }
            if (date != null) break;
            ++i;
        }
        if (date == null && this.df != null) {
            date = this.df.parse(s);
        }
        return date;
    }

    public String format(Date date) {
        String s = null;
        if (date != null) {
            this.sdf.applyPattern((String)this.dateFormats.get(0));
            s = this.sdf.format(date);
        }
        return s;
    }

    public String getDateFormatMessage() {
        return this.dateFormatMessage;
    }

    public void setDateFormatMessage(String v) {
        if (v != null && !v.equals("")) {
            this.dateFormatMessage = v;
        }
    }

    public List getDateFormats() {
        return this.dateFormats;
    }

    public void setDateFormats(List v) {
        this.dateFormats = v;
    }

    public boolean isFlexible() {
        return this.flexible;
    }

    public void setFlexible(boolean v) {
        this.flexible = v;
    }

    static {
        DEFAULT_DATE_MESSAGE = DEFAULT_DATE_MESSAGE;
    }
}

