/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.util.HashMap;
import java.util.Map;
import org.apache.fulcrum.ServiceException;
import org.apache.fulcrum.intake.model.BigDecimalField;
import org.apache.fulcrum.intake.model.BooleanField;
import org.apache.fulcrum.intake.model.ComboKeyField;
import org.apache.fulcrum.intake.model.DateStringField;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.FileItemField;
import org.apache.fulcrum.intake.model.FloatField;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.model.IntegerField;
import org.apache.fulcrum.intake.model.NumberKeyField;
import org.apache.fulcrum.intake.model.StringField;
import org.apache.fulcrum.intake.model.StringKeyField;
import org.apache.fulcrum.intake.xmlmodel.XmlField;

public abstract class FieldFactory {
    private static Map fieldCtors = FieldFactory.initFieldCtors();

    private static Map initFieldCtors() {
        fieldCtors = new HashMap();
        fieldCtors.put("int", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new IntegerField(f, g);
            }
        });
        fieldCtors.put("boolean", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new BooleanField(f, g);
            }
        });
        fieldCtors.put("String", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new StringField(f, g);
            }
        });
        fieldCtors.put("BigDecimal", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new BigDecimalField(f, g);
            }
        });
        fieldCtors.put("NumberKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new NumberKeyField(f, g);
            }
        });
        fieldCtors.put("ComboKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new ComboKeyField(f, g);
            }
        });
        fieldCtors.put("StringKey", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new StringKeyField(f, g);
            }
        });
        fieldCtors.put("FileItem", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new FileItemField(f, g);
            }
        });
        fieldCtors.put("DateString", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new DateStringField(f, g);
            }
        });
        fieldCtors.put("float", new FieldCtor(){

            public Field getInstance(XmlField f, Group g) throws Exception {
                return new FloatField(f, g);
            }
        });
        return fieldCtors;
    }

    public static final Field getInstance(XmlField f, Group g) throws Exception {
        FieldCtor fieldCtor = null;
        Field field = null;
        String type = f.getType();
        fieldCtor = (FieldCtor)fieldCtors.get(type);
        if (fieldCtor == null) {
            throw new ServiceException("Unsupported type: " + type);
        }
        field = fieldCtor.getInstance(f, g);
        return field;
    }

    private static abstract class FieldCtor {
        private FieldCtor() {
        }

        public Field getInstance(XmlField f, Group g) throws Exception {
            return null;
        }
    }
}

