/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fulcrum.intake.model;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Date;
import org.apache.fulcrum.intake.model.Field;
import org.apache.fulcrum.intake.model.Group;
import org.apache.fulcrum.intake.validator.DateStringValidator;
import org.apache.fulcrum.intake.xmlmodel.XmlField;

public class DateStringField
extends Field {
    private DateFormat df = null;

    public DateStringField(XmlField field, Group group) throws Exception {
        super(field, group);
        if (this.validator == null || !(this.validator instanceof DateStringValidator)) {
            this.df = DateFormat.getInstance();
            this.df.setLenient(true);
        }
    }

    protected void setDefaultValue(String prop) {
        this.defaultValue = prop;
    }

    protected String getDefaultValidator() {
        return "org.apache.fulcrum.intake.validator.DateStringValidator";
    }

    protected void doSetValue() {
        if (this.isMultiValued) {
            String[] ss = this.pp.getStrings(this.getKey());
            Date[] dates = new Date[ss.length];
            int i = 0;
            while (i < ss.length) {
                dates[i] = this.getDate(ss[i]);
                ++i;
            }
            this.setTestValue(dates);
        } else {
            this.setTestValue(this.getDate(this.pp.getString(this.getKey())));
        }
    }

    private Date getDate(String dateString) {
        Date date = null;
        try {
            date = this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).parse(dateString) : this.df.parse(dateString);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return date;
    }

    public String toString() {
        String s = null;
        Object value = this.getValue();
        s = value == null ? "" : (value instanceof String ? (String)value : (this.validator != null && this.validator instanceof DateStringValidator ? ((DateStringValidator)this.validator).format((Date)value) : this.df.format((Date)value)));
        return s;
    }
}

