/*
 * Decompiled with CFR 0.152.
 */
package slidestore.file;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.UnknownObjectClassException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectNode;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import slidestore.file.AbstractUriProperties;

public class UriProperties
extends AbstractUriProperties {
    protected SimpleDateFormat dateFormat = new SimpleDateFormat();
    static /* synthetic */ Class class$org$apache$slide$structure$LinkNode;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Vector;

    public UriProperties(String aRootPath, Uri aUri) throws ServiceAccessException {
        super(aRootPath, aUri);
        File aFile = this.getFile(aUri);
        if (aFile.exists()) {
            this.init(aFile);
        }
    }

    public static String booleanToString(boolean aBoolean) {
        return aBoolean ? "true" : "false";
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public Element createElements(String aParent, String aChild, Enumeration aEnum) {
        Element aElement = new Element(aParent);
        while (aEnum.hasMoreElements()) {
            Object aObject = aEnum.nextElement();
            Element aItem = new Element(aChild);
            aItem.setAttribute("val", aObject.toString());
            aElement.addContent(aItem);
        }
        return aElement;
    }

    public Object createObject(String aNomClasse, Class[] aTypes, Object[] aArgs) throws UnknownObjectClassException {
        Class<?> aClasse = null;
        try {
            aClasse = Class.forName(aNomClasse);
            Constructor<?> aConstructor = aClasse.getConstructor(aTypes);
            if (aConstructor == null) {
                aConstructor = aClasse.getSuperclass().getConstructor(aTypes);
            }
            return aConstructor.newInstance(aArgs);
        }
        catch (Exception exception) {
            throw new UnknownObjectClassException(aNomClasse);
        }
    }

    public Vector createVector(Element aElement, String aParentName, String aChildName) {
        Element aParent = aElement.getChild(aParentName);
        Vector<String> aRet = new Vector<String>();
        List aList = aParent.getChildren(aChildName);
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            aRet.addElement(aChild.getAttributeValue("val"));
            ++i;
        }
        return aRet;
    }

    protected void decode(Element aRoot) throws ServiceAccessException {
        this.decodeObject(aRoot);
        this.decodePermissions(aRoot);
        this.decodeLocks(aRoot);
        this.decodeRevisionDescriptors(aRoot);
        this.decodeRevisionDescriptor(aRoot);
    }

    public void decodeLocks(Element aElement) throws ServiceAccessException {
        try {
            this.locks = new Vector();
            Element aElementLocks = aElement.getChild("locks");
            List aList = aElementLocks.getChildren();
            int i = 0;
            while (i < aList.size()) {
                Element aChild = (Element)aList.get(i);
                String aSubject = aChild.getAttributeValue("subjectUri");
                String aType = aChild.getAttributeValue("typeUri");
                Date aDateExpiration = this.dateFormat.parse(aChild.getAttributeValue("date"));
                boolean aInheritable = new Boolean(aChild.getAttributeValue("inheritance"));
                boolean aNegative = new Boolean(aChild.getAttributeValue("exclusive"));
                String aLockId = aChild.getAttributeValue("lockId");
                this.locks.addElement(new NodeLock(aLockId, this.object.getUri(), aSubject, aType, aDateExpiration, aInheritable, aNegative));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }

    public NodeProperty decodeNodeProperty(Element aElement, String aUri) {
        String aName = aElement.getAttributeValue("name");
        String aValue = aElement.getAttributeValue("value");
        String aNamespace = aElement.getAttributeValue("namespace");
        String aType = aElement.getAttributeValue("type");
        boolean aProtected = new Boolean(aElement.getAttributeValue("protected"));
        Element aPermisionsElement = aElement.getChild("permissions");
        List aList = aPermisionsElement.getChildren();
        Vector<NodePermission> aPermission = new Vector<NodePermission>();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            aPermission.addElement(this.decodePermission(aChild, aUri));
            ++i;
        }
        return new NodeProperty(aName, (Object)aValue, aNamespace, aType, aProtected);
    }

    public void decodeObject(Element aElement) throws ServiceAccessException {
        try {
            Element aElementObjectNode = aElement.getChild("objectnode");
            String aClasseName = aElementObjectNode.getAttributeValue("classname");
            String aUri = aElementObjectNode.getAttributeValue("uri");
            Vector aChilds = this.createVector(aElementObjectNode, "childs", "child");
            Vector aLinks = this.createVector(aElementObjectNode, "links", "link");
            Class[] aTypes = null;
            Object[] aArgs = null;
            if (aClasseName.equals((class$org$apache$slide$structure$LinkNode != null ? class$org$apache$slide$structure$LinkNode : (class$org$apache$slide$structure$LinkNode = UriProperties.class$("org.apache.slide.structure.LinkNode"))).getName())) {
                String aLinkTo = aElementObjectNode.getAttributeValue("linkTo");
                aTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = UriProperties.class$("java.lang.String")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = UriProperties.class$("java.util.Vector")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = UriProperties.class$("java.util.Vector")), class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = UriProperties.class$("java.lang.String"))};
                aArgs = new Object[]{aUri, aChilds, aLinks, aLinkTo};
            } else {
                aTypes = new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = UriProperties.class$("java.lang.String")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = UriProperties.class$("java.util.Vector")), class$java$util$Vector != null ? class$java$util$Vector : (class$java$util$Vector = UriProperties.class$("java.util.Vector"))};
                aArgs = new Object[]{aUri, aChilds, aLinks};
            }
            this.object = (ObjectNode)this.createObject(aClasseName, aTypes, aArgs);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }

    public NodePermission decodePermission(Element aElement, String aUri) {
        String aRevisionNumber = aElement.getAttributeValue("revisionNumber");
        String aSubject = aElement.getAttributeValue("subjectUri");
        String aAction = aElement.getAttributeValue("actionUri");
        boolean aInheritable = new Boolean(aElement.getAttributeValue("inheritable"));
        boolean aNegative = new Boolean(aElement.getAttributeValue("negative"));
        return new NodePermission(aUri, aRevisionNumber, aSubject, aAction, aInheritable, aNegative);
    }

    public void decodePermissions(Element aElement) {
        this.permissions = new Vector();
        String aUri = this.object.getUri().toString();
        Element aPermissions = aElement.getChild("permissions");
        List aList = aPermissions.getChildren();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            this.permissions.addElement(this.decodePermission(aChild, aUri));
            ++i;
        }
    }

    public void decodeRevisionDescriptor(Element aParent) {
        this.descriptor = new Hashtable();
        Element aElement = aParent.getChild("descriptor");
        if (aElement == null) {
            return;
        }
        List aList = aElement.getChildren();
        String aUri = this.object.getUri().toString();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            String aBranchName = aChild.getAttributeValue("branchName");
            NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aChild.getAttributeValue("number"));
            Vector<String> aLabels = new Vector<String>();
            Element aLabelsElement = aChild.getChild("labels");
            List aLabelList = aLabelsElement.getChildren();
            int k = 0;
            while (k < aLabelList.size()) {
                Element aLabel = (Element)aLabelList.get(k);
                aLabels.addElement(aLabel.getAttributeValue("val"));
                ++k;
            }
            Hashtable<String, NodeProperty> aProperties = new Hashtable<String, NodeProperty>();
            Element aPropertiesElement = aChild.getChild("properties");
            List aPropertiesList = aPropertiesElement.getChildren();
            int k2 = 0;
            while (k2 < aPropertiesList.size()) {
                Element aProperty = (Element)aPropertiesList.get(k2);
                NodeProperty aProp = this.decodeNodeProperty(aProperty, aUri);
                String key = String.valueOf(aProperty.getAttributeValue("namespace")) + aProperty.getAttributeValue("name");
                aProperties.put(key, aProp);
                ++k2;
            }
            NodeRevisionDescriptor aNode = new NodeRevisionDescriptor(aRevisionNumber, aBranchName, aLabels, aProperties);
            this.descriptor.put(aRevisionNumber.toString(), aNode);
            ++i;
        }
    }

    public void decodeRevisionDescriptors(Element aElement) {
        Element aRevisionsHistory = aElement.getChild("revisionsHistory");
        NodeRevisionNumber aInitialRevision = this.decodeRevisionNumber(aRevisionsHistory.getAttributeValue("initialRevision"));
        boolean aUseVersionning = new Boolean(aRevisionsHistory.getAttributeValue("useVersioning"));
        Element aBranchesElement = aRevisionsHistory.getChild("branches");
        if (aBranchesElement == null) {
            this.revisionDescriptors = new NodeRevisionDescriptors(this.object.getUri().toString(), aInitialRevision, new Hashtable(), new Hashtable(), new Hashtable(), aUseVersionning);
            return;
        }
        List aList = aBranchesElement.getChildren();
        Hashtable<String, NodeRevisionNumber> aLastestRevisions = new Hashtable<String, NodeRevisionNumber>();
        int i = 0;
        while (i < aList.size()) {
            Element aChild = (Element)aList.get(i);
            String aName = aChild.getAttributeValue("name");
            NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aChild.getAttributeValue("lastestRevision"));
            aLastestRevisions.put(aName, aRevisionNumber);
            ++i;
        }
        Hashtable aBranches = new Hashtable();
        Element aRevisionsElement = aRevisionsHistory.getChild("revisions");
        aList = aRevisionsElement.getChildren();
        int i2 = 0;
        while (i2 < aList.size()) {
            Element aChild = (Element)aList.get(i2);
            NodeRevisionNumber aStartNumber = this.decodeRevisionNumber(aChild.getAttributeValue("start"));
            List aSuccessors = aChild.getChildren();
            Vector<NodeRevisionNumber> aSuccessorsNumbers = new Vector<NodeRevisionNumber>();
            int k = 0;
            while (k < aSuccessors.size()) {
                Element aSuccessor = (Element)aSuccessors.get(k);
                NodeRevisionNumber aRevisionNumber = this.decodeRevisionNumber(aSuccessor.getAttributeValue("number"));
                aSuccessorsNumbers.addElement(aRevisionNumber);
                ++k;
            }
            aBranches.put(aStartNumber, aSuccessorsNumbers);
            ++i2;
        }
        this.revisionDescriptors = new NodeRevisionDescriptors(this.object.getUri().toString(), aInitialRevision, new Hashtable(), aLastestRevisions, aBranches, aUseVersionning);
    }

    public NodeRevisionNumber decodeRevisionNumber(String aStr) {
        return aStr == null ? null : new NodeRevisionNumber(aStr);
    }

    public NodeRevisionNumber decodeRevisionNumber(Element aElement) {
        Element aElementRevision = aElement.getChild("revision");
        return new NodeRevisionNumber(Integer.parseInt(aElementRevision.getAttributeValue("major")), Integer.parseInt(aElementRevision.getAttributeValue("minor")));
    }

    protected Element encode() throws ServiceAccessException {
        Element aRoot = new Element("data");
        aRoot.addContent(this.encodeObject());
        aRoot.addContent(this.encodePermissions());
        aRoot.addContent(this.encodeLocks());
        aRoot.addContent(this.encodeRevisionDescriptors());
        aRoot.addContent(this.encodeRevisionDescriptor());
        return aRoot;
    }

    public Element encodeLocks() {
        Element aElementLocks = new Element("locks");
        if (this.locks == null) {
            return aElementLocks;
        }
        int aSize = this.locks.size();
        int i = 0;
        while (i < aSize) {
            NodeLock aLock = (NodeLock)this.locks.elementAt(i);
            Element aElementLock = new Element("lock");
            aElementLock.setAttribute("subjectUri", aLock.getSubjectUri());
            aElementLock.setAttribute("typeUri", aLock.getTypeUri());
            aElementLock.setAttribute("date", this.dateFormat.format(aLock.getExpirationDate()));
            aElementLock.setAttribute("inheritance", UriProperties.booleanToString(aLock.isInheritable()));
            aElementLock.setAttribute("exclusive", UriProperties.booleanToString(aLock.isExclusive()));
            aElementLock.setAttribute("lockId", aLock.getLockId());
            aElementLocks.addContent(aElementLock);
            ++i;
        }
        return aElementLocks;
    }

    public Element encodeNodePermission(NodePermission aPermission) {
        Element aElementPermission = new Element("permission");
        NodeRevisionNumber aRevisionNumber = aPermission.getRevisionNumber();
        if (aRevisionNumber != null) {
            aElementPermission.setAttribute("revisionNumber", this.encodeRevisionNumber(aRevisionNumber));
        }
        aElementPermission.setAttribute("subjectUri", aPermission.getSubjectUri());
        aElementPermission.setAttribute("actionUri", aPermission.getActionUri());
        aElementPermission.setAttribute("inheritable", UriProperties.booleanToString(aPermission.isInheritable()));
        aElementPermission.setAttribute("negative", UriProperties.booleanToString(aPermission.isNegative()));
        return aElementPermission;
    }

    public Element encodeNodeProperty(NodeProperty aProp) {
        Element aElement = new Element("property");
        aElement.setAttribute("name", aProp.getName());
        aElement.setAttribute("namespace", aProp.getNamespace());
        aElement.setAttribute("value", aProp.getValue().toString());
        aElement.setAttribute("type", aProp.getType());
        aElement.setAttribute("protected", UriProperties.booleanToString(aProp.isProtected()));
        Element aPermissions = new Element("permissions");
        Enumeration aEnum = aProp.enumeratePermissions();
        while (aEnum.hasMoreElements()) {
            NodePermission aPermission = (NodePermission)aEnum.nextElement();
            aPermissions.addContent(this.encodeNodePermission(aPermission));
        }
        aElement.addContent(aPermissions);
        return aElement;
    }

    public Element encodeObject() {
        Element aElementObjectNode = new Element("objectnode");
        aElementObjectNode.setAttribute("classname", this.object.getClass().getName());
        aElementObjectNode.setAttribute("uri", this.object.getUri());
        aElementObjectNode.addContent(this.createElements("childs", "child", this.object.enumerateChildren()));
        aElementObjectNode.addContent(this.createElements("links", "link", this.object.enumerateLinks()));
        if (this.object instanceof LinkNode) {
            aElementObjectNode.setAttribute("linkTo", ((LinkNode)this.object).getLinkedUri());
        }
        return aElementObjectNode;
    }

    public Element encodePermissions() {
        Element aPermissions = new Element("permissions");
        if (this.permissions == null) {
            return aPermissions;
        }
        int aSize = this.permissions.size();
        int i = 0;
        while (i < aSize) {
            NodePermission aPermission = (NodePermission)this.permissions.elementAt(i);
            aPermissions.addContent(this.encodeNodePermission(aPermission));
            ++i;
        }
        return aPermissions;
    }

    public Element encodeRevisionDescriptor() {
        Element aRet = new Element("descriptor");
        if (this.descriptor == null) {
            return aRet;
        }
        Enumeration aEnum = this.descriptor.elements();
        while (aEnum.hasMoreElements()) {
            NodeRevisionDescriptor aRevisionDescriptor = (NodeRevisionDescriptor)aEnum.nextElement();
            aRet.addContent(this.encodeRevisionDescriptor(aRevisionDescriptor));
        }
        return aRet;
    }

    public Element encodeRevisionDescriptor(NodeRevisionDescriptor aDescriptor) {
        Element aRevisions = new Element("revisions");
        aRevisions.setAttribute("branchName", aDescriptor.getBranchName());
        aRevisions.setAttribute("number", this.encodeRevisionNumber(aDescriptor.getRevisionNumber()));
        aRevisions.addContent(this.createElements("labels", "label", aDescriptor.enumerateLabels()));
        Element aProperties = new Element("properties");
        Enumeration aEnum = aDescriptor.enumerateProperties();
        while (aEnum.hasMoreElements()) {
            Object aObject = aEnum.nextElement();
            NodeProperty aProp = (NodeProperty)aObject;
            aProperties.addContent(this.encodeNodeProperty(aProp));
        }
        aRevisions.addContent(aProperties);
        return aRevisions;
    }

    public Element encodeRevisionDescriptors() {
        NodeRevisionNumber aRevisionNumber;
        Element aRevisionsHistory = new Element("revisionsHistory");
        if (this.revisionDescriptors == null) {
            return aRevisionsHistory;
        }
        aRevisionsHistory.setAttribute("initialRevision", this.encodeRevisionNumber(this.revisionDescriptors.getInitialRevision()));
        aRevisionsHistory.setAttribute("useVersioning", UriProperties.booleanToString(this.revisionDescriptors.isVersioned()));
        Element aBranchesElement = new Element("branches");
        Enumeration aBranches = this.revisionDescriptors.enumerateBranchNames();
        while (aBranches.hasMoreElements()) {
            String aBranchName = (String)aBranches.nextElement();
            Element aElementBranch = new Element("branch");
            aElementBranch.setAttribute("name", aBranchName);
            aRevisionNumber = this.revisionDescriptors.getLatestRevision(aBranchName);
            aElementBranch.setAttribute("lastestRevision", this.encodeRevisionNumber(aRevisionNumber));
            aBranchesElement.addContent(aElementBranch);
        }
        aRevisionsHistory.addContent(aBranchesElement);
        Element aRevisionsElement = new Element("revisions");
        Enumeration aRevisions = this.revisionDescriptors.enumerateRevisionNumbers();
        while (aRevisions.hasMoreElements()) {
            aRevisionNumber = (NodeRevisionNumber)aRevisions.nextElement();
            Element aRevisionElement = new Element("branch");
            aRevisionElement.setAttribute("start", this.encodeRevisionNumber(aRevisionNumber));
            Enumeration aSuccessors = this.revisionDescriptors.getSuccessors(aRevisionNumber);
            while (aSuccessors.hasMoreElements()) {
                NodeRevisionNumber aSuccessorRevisionNumber = (NodeRevisionNumber)aSuccessors.nextElement();
                Element aSuccessorRevisionElement = new Element("revision");
                aSuccessorRevisionElement.setAttribute("number", this.encodeRevisionNumber(aSuccessorRevisionNumber));
                aRevisionElement.addContent(aSuccessorRevisionElement);
            }
            aRevisionsElement.addContent(aRevisionElement);
        }
        aRevisionsHistory.addContent(aRevisionsElement);
        return aRevisionsHistory;
    }

    public String encodeRevisionNumber(NodeRevisionNumber aRevisionNumber) {
        return String.valueOf(aRevisionNumber.getMajor()) + "." + aRevisionNumber.getMinor();
    }

    public static File getFile(String aRootPath, Uri aUri) {
        File aFile = new File(String.valueOf(aRootPath) + aUri + ".def.xml");
        File aParentFile = new File(aFile.getParent());
        if (aParentFile != null && !aParentFile.exists()) {
            aParentFile.mkdirs();
        }
        return aFile;
    }

    public File getFile(Uri aUri) {
        return UriProperties.getFile(this.rootpath, aUri);
    }

    public static XMLOutputter getXMLOutputter() {
        XMLOutputter aOutputter = new XMLOutputter();
        aOutputter.setEncoding("ISO-8859-1");
        aOutputter.setNewlines(true);
        aOutputter.setIndent(true);
        aOutputter.setLineSeparator("\n");
        return aOutputter;
    }

    protected void init(File aFile) throws ServiceAccessException {
        try {
            SAXBuilder aBuilder = new SAXBuilder();
            FileInputStream aIn = new FileInputStream(aFile);
            Document aDocument = aBuilder.build((InputStream)aIn);
            this.decode(aDocument.getRootElement());
            aIn.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }

    protected void save(Uri aUri) throws ServiceAccessException {
        try {
            File aFile = this.getFile(aUri);
            Element aRoot = this.encode();
            Document aDocument = new Document(aRoot);
            FileOutputStream aOut = new FileOutputStream(aFile);
            XMLOutputter aOutputter = UriProperties.getXMLOutputter();
            aOutputter.output(aDocument, (OutputStream)aOut);
            aOut.flush();
            ((OutputStream)aOut).close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ServiceAccessException(null, (Throwable)e);
        }
    }
}

