/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.lang.reflect.Array;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.StringStack;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.om.DateKey;
import org.apache.torque.om.ObjectKey;
import org.apache.torque.om.StringKey;
import org.apache.torque.util.Criteria;
import org.apache.torque.util.SqlEnum;

public class SqlExpression {
    private static final char SINGLE_QUOTE = '\'';
    private static final char BACKSLASH = '\\';

    public static String buildInnerJoin(String column, String relatedColumn) {
        return SqlExpression.buildInnerJoin(column, relatedColumn, false, null);
    }

    public static String buildInnerJoin(String column, String relatedColumn, boolean ignoreCase, DB db) {
        int addlength = ignoreCase ? 25 : 1;
        StringBuffer sb = new StringBuffer(column.length() + relatedColumn.length() + addlength);
        SqlExpression.buildInnerJoin(column, relatedColumn, ignoreCase, db, sb);
        return sb.toString();
    }

    public static void buildInnerJoin(String column, String relatedColumn, boolean ignoreCase, DB db, StringBuffer whereClause) {
        if (ignoreCase) {
            whereClause.append(db.ignoreCase(column)).append('=').append(db.ignoreCase(relatedColumn));
        } else {
            whereClause.append(column).append('=').append(relatedColumn);
        }
    }

    public static String build(String columnName, Object criteria, SqlEnum comparison) throws TorqueException {
        return SqlExpression.build(columnName, criteria, comparison, false, null);
    }

    public static String build(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db) throws TorqueException {
        int addlength = ignoreCase ? 40 : 20;
        StringBuffer sb = new StringBuffer(columnName.length() + addlength);
        SqlExpression.build(columnName, criteria, comparison, ignoreCase, db, sb);
        return sb.toString();
    }

    public static void build(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) {
        Date dt;
        if (criteria != null && criteria instanceof ObjectKey && ((ObjectKey)criteria).getValue() == null) {
            criteria = null;
        }
        if (criteria == null) {
            criteria = "null";
            if (comparison.equals(Criteria.EQUAL)) {
                comparison = Criteria.ISNULL;
            } else if (comparison.equals(Criteria.NOT_EQUAL)) {
                comparison = Criteria.ISNOTNULL;
            } else if (comparison.equals(Criteria.ALT_NOT_EQUAL)) {
                comparison = Criteria.ISNOTNULL;
            }
        } else if (criteria instanceof String || criteria instanceof StringKey) {
            criteria = SqlExpression.quoteAndEscapeText(criteria.toString(), db);
        } else if (criteria instanceof Date) {
            dt = (Date)criteria;
            criteria = db.getDateString(dt);
        } else if (criteria instanceof DateKey) {
            dt = (Date)((DateKey)criteria).getValue();
            criteria = db.getDateString(dt);
        } else if (criteria instanceof Boolean) {
            criteria = db.getBooleanString((Boolean)criteria);
        }
        if (comparison.equals(Criteria.LIKE) || comparison.equals(Criteria.NOT_LIKE)) {
            SqlExpression.buildLike(columnName, (String)criteria, comparison, ignoreCase, db, whereClause);
        } else if (comparison.equals(Criteria.IN) || comparison.equals(Criteria.NOT_IN)) {
            SqlExpression.buildIn(columnName, criteria, comparison, ignoreCase, db, whereClause);
        } else if (comparison.equals(Criteria.ISNULL) || comparison.equals(Criteria.ISNOTNULL)) {
            whereClause.append(columnName).append(comparison);
        } else {
            String columnValue = criteria.toString();
            if (ignoreCase && db != null) {
                columnName = db.ignoreCase(columnName);
                columnValue = db.ignoreCase(columnValue);
            }
            whereClause.append(columnName).append(comparison).append(columnValue);
        }
    }

    static String buildLike(String columnName, String criteria, SqlEnum comparison, boolean ignoreCase, DB db) {
        StringBuffer whereClause = new StringBuffer();
        SqlExpression.buildLike(columnName, criteria, comparison, ignoreCase, db, whereClause);
        return whereClause.toString();
    }

    static void buildLike(String columnName, String criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) {
        if (ignoreCase) {
            columnName = db.ignoreCase(columnName);
        }
        whereClause.append(columnName);
        String equalsOrLike = " = ";
        Object parsedCriteria = null;
        int position = 0;
        StringBuffer sb = new StringBuffer();
        while (position < criteria.length()) {
            int checkWildcard = criteria.charAt(position);
            switch (checkWildcard) {
                case 92: {
                    switch (criteria.charAt(position + 1)) {
                        case '%': 
                        case '*': 
                        case '?': 
                        case '\\': 
                        case '_': {
                            ++position;
                        }
                    }
                    break;
                }
                case 37: 
                case 95: {
                    equalsOrLike = comparison.toString();
                    break;
                }
                case 42: {
                    equalsOrLike = comparison.toString();
                    checkWildcard = 37;
                    break;
                }
                case 63: {
                    equalsOrLike = comparison.toString();
                    checkWildcard = 95;
                }
            }
            sb.append((char)checkWildcard);
            ++position;
        }
        whereClause.append(equalsOrLike);
        String clauseItem = sb.toString();
        if (ignoreCase) {
            clauseItem = db.ignoreCase(clauseItem);
        }
        whereClause.append(clauseItem);
    }

    static String buildIn(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db) {
        StringBuffer whereClause = new StringBuffer();
        SqlExpression.buildIn(columnName, criteria, comparison, ignoreCase, db, whereClause);
        return whereClause.toString();
    }

    static void buildIn(String columnName, Object criteria, SqlEnum comparison, boolean ignoreCase, DB db, StringBuffer whereClause) {
        if (ignoreCase) {
            whereClause.append(db.ignoreCase(columnName));
        } else {
            whereClause.append(columnName);
        }
        whereClause.append(comparison);
        StringStack inClause = new StringStack();
        if (criteria instanceof List) {
            Iterator iter = ((List)criteria).iterator();
            while (iter.hasNext()) {
                Object value = iter.next();
                inClause.add(SqlExpression.processInValue(value, ignoreCase, db));
            }
        } else {
            int i = 0;
            while (i < Array.getLength(criteria)) {
                Object value = Array.get(criteria, i);
                inClause.add(SqlExpression.processInValue(value, ignoreCase, db));
                ++i;
            }
        }
        whereClause.append('(').append(inClause.toString(",")).append(')');
    }

    static String processInValue(Object value, boolean ignoreCase, DB db) {
        String ret = null;
        ret = value instanceof String ? SqlExpression.quoteAndEscapeText((String)value, db) : value.toString();
        if (ignoreCase) {
            ret = db.ignoreCase(ret);
        }
        return ret;
    }

    public static String quoteAndEscapeText(String rawText, DB db) {
        StringBuffer buf = new StringBuffer((int)((double)rawText.length() * 1.1));
        String escapeString = new String();
        escapeString = db != null && !db.escapeText() ? String.valueOf('\\') : String.valueOf('\\') + String.valueOf('\\');
        char[] data = rawText.toCharArray();
        buf.append('\'');
        int i = 0;
        while (i < data.length) {
            switch (data[i]) {
                case '\'': {
                    buf.append('\'').append('\'');
                    break;
                }
                case '\\': {
                    buf.append(escapeString);
                    break;
                }
                default: {
                    buf.append(data[i]);
                }
            }
            ++i;
        }
        buf.append('\'');
        return buf.toString();
    }

    public static String quoteAndEscapeText(String rawText) {
        return SqlExpression.quoteAndEscapeText(rawText, null);
    }
}

