/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.task;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.ProjectComponent;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.transform.XmlToData;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.velocity.context.Context;

public class TorqueDataSQLTask
extends TorqueDataModelTask {
    private String dataXmlFile;
    private String dataDTD;
    private String targetDatabase;

    public void setDataXmlFile(String dataXmlFile) {
        this.dataXmlFile = ((ProjectComponent)this).project.resolveFile(dataXmlFile).toString();
    }

    public String getDataXmlFile() {
        return this.dataXmlFile;
    }

    public String getTargetDatabase() {
        return this.targetDatabase;
    }

    public void setTargetDatabase(String v) {
        this.targetDatabase = v;
    }

    public String getDataDTD() {
        return this.dataDTD;
    }

    public void setDataDTD(String dataDTD) {
        this.dataDTD = ((ProjectComponent)this).project.resolveFile(dataDTD).toString();
    }

    public Context initControlContext() throws Exception {
        super.initControlContext();
        AppData app = (AppData)this.getDataModels().get(0);
        Database db = app.getDatabase();
        try {
            XmlToData dataXmlParser = new XmlToData(db, this.dataDTD);
            List data = dataXmlParser.parseFile(this.dataXmlFile);
            this.context.put("data", (Object)data);
        }
        catch (Exception e) {
            throw new Exception("Exception parsing data XML:");
        }
        this.context.put("appData", (Object)app);
        this.context.put("targetDatabase", (Object)this.targetDatabase);
        Properties p = new Properties();
        FileInputStream fis = new FileInputStream(this.getSqlDbMap());
        p.load(fis);
        fis.close();
        p.setProperty(this.getOutputFile(), db.getName());
        p.store(new FileOutputStream(this.getSqlDbMap()), "Sqlfile -> Database map");
        return this.context;
    }
}

