/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.pool;

import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import org.apache.commons.lang.SerializationUtils;
import org.apache.torque.pool.ConnectionPool;

public class TorqueClassicDataSource
implements DataSource,
Referenceable,
Serializable,
ObjectFactory {
    private static Map pools = new HashMap();
    private static int cpdsCounter;
    private String dataSourceName;
    private String description;
    private int loginTimeout;
    private ConnectionPoolDataSource cpds;
    private PrintWriter logWriter;
    private Properties jndiEnvironment;
    private int defaultMaxConnections;
    private Properties perUserMaxConnections;
    private int maxExpiryTime;
    private int connectionWaitTimeout;
    private int logInterval;
    private boolean defaultAutoCommit = true;
    private boolean defaultReadOnly;

    public int getDefaultMaxConnections() {
        return this.defaultMaxConnections;
    }

    public void setDefaultMaxConnections(int v) {
        this.defaultMaxConnections = v;
    }

    public Properties getPerUserMaxConnections() {
        return this.perUserMaxConnections;
    }

    public void setPerUserMaxConnections(Properties v) {
        this.perUserMaxConnections = v;
    }

    public int getMaxExpiryTime() {
        return this.maxExpiryTime;
    }

    public void setMaxExpiryTime(int v) {
        this.maxExpiryTime = v;
    }

    public int getConnectionWaitTimeout() {
        return this.connectionWaitTimeout;
    }

    public void setConnectionWaitTimeout(int v) {
        this.connectionWaitTimeout = v;
    }

    public int getLogInterval() {
        return this.logInterval;
    }

    public void setLogInterval(int v) {
        this.logInterval = v;
    }

    public boolean isDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(boolean v) {
        this.defaultAutoCommit = v;
    }

    public boolean isDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean v) {
        this.defaultReadOnly = v;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    public void setDataSourceName(String v) {
        if (this.getConnectionPoolDataSource() != null) {
            throw new IllegalStateException("connectionPoolDataSource property already has a value.  Both dataSourceName and connectionPoolDataSource properties cannot be set.");
        }
        this.dataSourceName = v;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String v) {
        this.description = v;
    }

    public String getJndiEnvironment(String key) {
        String value = null;
        if (this.jndiEnvironment != null) {
            value = this.jndiEnvironment.getProperty(key);
        }
        return value;
    }

    public void setJndiEnvironment(String key, String value) {
        if (this.jndiEnvironment == null) {
            this.jndiEnvironment = new Properties();
        }
        this.jndiEnvironment.setProperty(key, value);
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.cpds;
    }

    public void setConnectionPoolDataSource(ConnectionPoolDataSource v) {
        if (v == null) {
            throw new IllegalArgumentException("Null argument value is not allowed.");
        }
        if (this.getDataSourceName() != null) {
            throw new IllegalStateException("dataSourceName property already has a value.  Both dataSourceName and connectionPoolDataSource properties cannot be set.");
        }
        this.cpds = v;
        this.dataSourceName = v.hashCode() + " internal cpds name " + cpdsCounter++;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public synchronized Connection getConnection(String username, String password) throws SQLException {
        String key = this.getKey(username);
        ConnectionPool pool = (ConnectionPool)pools.get(key);
        if (pool == null) {
            try {
                this.registerPool(username, password);
                pool = (ConnectionPool)pools.get(key);
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        Connection con = pool.getConnection(username, password).getConnection();
        con.setAutoCommit(this.defaultAutoCommit);
        con.setReadOnly(this.defaultReadOnly);
        return con;
    }

    private String getKey(String suffix) {
        String key = this.getDataSourceName();
        if (key == null) {
            throw new IllegalStateException("Attempted to use DataSource without a backend ConnectionPoolDataSource defined.");
        }
        if (suffix != null) {
            key = key + suffix;
        }
        return key;
    }

    private synchronized void registerPool(String username, String password) throws NamingException {
        String key = this.getKey(username);
        if (!pools.containsKey(key)) {
            String userMaxCon;
            ConnectionPoolDataSource cpds = this.cpds;
            if (cpds == null) {
                InitialContext ctx = null;
                ctx = this.jndiEnvironment == null ? new InitialContext() : new InitialContext(this.jndiEnvironment);
                cpds = (ConnectionPoolDataSource)ctx.lookup(this.dataSourceName);
            }
            int maxConnections = this.getDefaultMaxConnections();
            if (username != null && (userMaxCon = (String)((Hashtable)this.getPerUserMaxConnections()).get(username)) != null) {
                maxConnections = Integer.parseInt(userMaxCon);
            }
            ConnectionPool pool = new ConnectionPool(cpds, username, password, maxConnections, this.maxExpiryTime, this.connectionWaitTimeout, this.logInterval, this.getLogWriter());
            HashMap<String, ConnectionPool> newPools = new HashMap<String, ConnectionPool>(pools);
            newPools.put(key, pool);
            pools = newPools;
        }
    }

    public int getLoginTimeout() {
        return this.loginTimeout;
    }

    public PrintWriter getLogWriter() {
        if (this.logWriter == null) {
            this.logWriter = new PrintWriter(System.out);
        }
        return this.logWriter;
    }

    public void setLoginTimeout(int seconds) {
        this.loginTimeout = seconds;
    }

    public void setLogWriter(PrintWriter out) {
        this.logWriter = out;
    }

    public Reference getReference() throws NamingException {
        String factory = this.getClass().getName();
        Reference ref = new Reference(this.getClass().getName(), factory, null);
        ref.add(new StringRefAddr("defaultMaxConnections", String.valueOf(this.getDefaultMaxConnections())));
        ref.add(new StringRefAddr("maxExpiryTime", String.valueOf(this.getMaxExpiryTime())));
        ref.add(new StringRefAddr("connectionWaitTimeout", String.valueOf(this.getConnectionWaitTimeout())));
        ref.add(new StringRefAddr("logInterval", String.valueOf(this.getLogInterval())));
        ref.add(new StringRefAddr("dataSourceName", this.getDataSourceName()));
        ref.add(new StringRefAddr("description", this.getDescription()));
        byte[] serJndiEnv = null;
        if (this.jndiEnvironment != null) {
            serJndiEnv = SerializationUtils.serialize((Serializable)this.jndiEnvironment);
            ref.add(new BinaryRefAddr("jndiEnvironment", serJndiEnv));
        }
        byte[] serPUMC = null;
        if (this.getPerUserMaxConnections() != null) {
            serPUMC = SerializationUtils.serialize((Serializable)this.getPerUserMaxConnections());
            ref.add(new BinaryRefAddr("perUserMaxConnections", serPUMC));
        }
        return ref;
    }

    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable env) throws Exception {
        Reference ref = (Reference)refObj;
        if (ref.getClassName().equals(this.getClass().getName())) {
            byte[] serialized;
            this.setDefaultMaxConnections(Integer.parseInt((String)ref.get("defaultMaxConnections").getContent()));
            this.setMaxExpiryTime(Integer.parseInt((String)ref.get("maxExpiryTime").getContent()));
            this.setConnectionWaitTimeout(Integer.parseInt((String)ref.get("connectionWaitTimeout").getContent()));
            this.setLogInterval(Integer.parseInt((String)ref.get("logInterval").getContent()));
            this.setDataSourceName((String)ref.get("dataSourceName").getContent());
            this.setDescription((String)ref.get("description").getContent());
            RefAddr refAddr = ref.get("jndiEnvironment");
            if (refAddr != null) {
                serialized = (byte[])refAddr.getContent();
                this.jndiEnvironment = (Properties)SerializationUtils.deserialize((byte[])serialized);
            }
            if ((refAddr = ref.get("perUserMaxConnections")) != null) {
                serialized = (byte[])refAddr.getContent();
                this.setPerUserMaxConnections((Properties)SerializationUtils.deserialize((byte[])serialized));
            }
            return this;
        }
        return null;
    }
}

