/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.pool;

import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.torque.pool.ConnectionWaitTimeoutException;

class ConnectionPool
implements ConnectionEventListener {
    private Stack pool = new Stack();
    private String driver;
    private String url;
    private String username;
    private String password;
    private int totalConnections = 0;
    private int maxConnections;
    private int expiryTime;
    private int waitCount = 0;
    int logInterval;
    Monitor monitor;
    private long connectionWaitTimeout;
    private ConnectionPoolDataSource cpds;
    private Map timeStamps = new HashMap();
    private PrintWriter logWriter;

    ConnectionPool(ConnectionPoolDataSource cpds, String username, String password, int maxConnections, int expiryTime, int connectionWaitTimeout, int logInterval, PrintWriter logWriter) {
        this.cpds = cpds;
        this.username = username;
        this.password = password;
        this.maxConnections = maxConnections > 0 ? maxConnections : 1;
        this.expiryTime = expiryTime > 0 ? expiryTime * 1000 : 3600000;
        this.connectionWaitTimeout = connectionWaitTimeout > 0 ? (long)(connectionWaitTimeout * 1000) : 10000L;
        this.logInterval = logInterval * 1000;
        this.logWriter = logWriter;
        this.monitor = new Monitor();
        this.monitor.setDaemon(true);
        this.monitor.start();
    }

    final synchronized PooledConnection getConnection(String username, String password) throws SQLException {
        if (username != this.username || password != this.password) {
            throw new SQLException("Username and password are invalid.");
        }
        PooledConnection pcon = null;
        if (this.pool.empty() && this.totalConnections < this.maxConnections) {
            pcon = this.getNewConnection();
        } else {
            try {
                pcon = this.getInternalPooledConnection();
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage());
            }
        }
        return pcon;
    }

    private PooledConnection getNewConnection() throws SQLException {
        PooledConnection pc = null;
        pc = this.username == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.username, this.password);
        pc.addConnectionEventListener(this);
        long currentTime = System.currentTimeMillis();
        double ratio = 1.0 * (double)this.totalConnections / (double)this.maxConnections;
        currentTime = (long)((double)currentTime - (double)this.expiryTime * 0.25 * (1.0 - ratio));
        this.timeStamps.put(pc, new Long(currentTime));
        ++this.totalConnections;
        return pc;
    }

    private synchronized PooledConnection getInternalPooledConnection() throws ConnectionWaitTimeoutException, Exception {
        if (this.waitCount > 0 || this.pool.empty()) {
            try {
                try {
                    ++this.waitCount;
                    this.wait(this.connectionWaitTimeout);
                }
                catch (InterruptedException ignored) {
                    Object var3_2 = null;
                    --this.waitCount;
                }
                Object var3_1 = null;
                --this.waitCount;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                --this.waitCount;
                throw throwable;
            }
            if (this.pool.empty()) {
                throw new ConnectionWaitTimeoutException(this.url);
            }
        }
        return this.popConnection();
    }

    private PooledConnection popConnection() throws Exception {
        while (!this.pool.empty()) {
            PooledConnection con = (PooledConnection)this.pool.pop();
            if (this.isValid(con)) {
                return con;
            }
            con.close();
            --this.totalConnections;
            if (!this.pool.empty()) continue;
            return this.getNewConnection();
        }
        throw new Exception("Assertaion failure: Attempted to pop connection from empty pool!");
    }

    private boolean isExpired(PooledConnection connection) {
        return (long)this.expiryTime < System.currentTimeMillis() - (Long)this.timeStamps.get(connection);
    }

    private boolean isValid(PooledConnection connection) {
        return !this.isExpired(connection);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
    }

    void shutdown() {
        if (this.pool != null) {
            while (!this.pool.isEmpty()) {
                Object var3_2;
                try {
                    try {
                        ((PooledConnection)this.pool.pop()).close();
                    }
                    catch (SQLException ignore) {
                        var3_2 = null;
                        --this.totalConnections;
                        continue;
                    }
                    var3_2 = null;
                    --this.totalConnections;
                }
                catch (Throwable throwable) {
                    var3_2 = null;
                    --this.totalConnections;
                    throw throwable;
                }
            }
        }
        this.monitor.shutdown();
    }

    int getTotalCount() {
        return this.totalConnections;
    }

    int getNbrAvailable() {
        return this.pool.size();
    }

    int getNbrCheckedOut() {
        return this.totalConnections - this.pool.size();
    }

    void decrementConnections() {
        --this.totalConnections;
        this.notify();
    }

    String getPoolName() {
        return this.toString();
    }

    public void connectionClosed(ConnectionEvent event) {
        this.releaseConnection((PooledConnection)event.getSource());
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            ((PooledConnection)event.getSource()).removeConnectionEventListener(this);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        try {
            this.closePooledConnection((PooledConnection)event.getSource());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private synchronized void releaseConnection(PooledConnection pcon) {
        if (this.isValid(pcon)) {
            this.pool.push(pcon);
            this.notify();
        } else {
            this.closePooledConnection(pcon);
        }
    }

    private void closePooledConnection(PooledConnection pcon) {
        try {
            try {
                pcon.close();
                this.timeStamps.remove(pcon);
            }
            catch (Exception e) {
                this.log("[ERROR] Error occurred trying to close a PooledConnection." + e.getMessage());
                Object var4_3 = null;
                this.decrementConnections();
            }
            Object var4_2 = null;
            this.decrementConnections();
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.decrementConnections();
            throw throwable;
        }
    }

    private void log(String s) {
        if (this.logWriter != null) {
            this.logWriter.println(s);
        } else {
            System.out.println(s);
        }
    }

    protected class Monitor
    extends Thread {
        private boolean isRun = true;

        protected Monitor() {
        }

        public void run() {
            StringBuffer buf = new StringBuffer();
            while (ConnectionPool.this.logInterval > 0 && this.isRun) {
                buf.setLength(0);
                buf.append(ConnectionPool.this.getPoolName()).append(" (in + out = total): ").append(ConnectionPool.this.getNbrAvailable()).append(" + ").append(ConnectionPool.this.getNbrCheckedOut()).append(" = ").append(ConnectionPool.this.getTotalCount());
                ConnectionPool.this.log(buf.toString());
            }
            try {
                Thread.sleep(ConnectionPool.this.logInterval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void shutdown() {
            this.isRun = false;
        }
    }
}

