/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.manager;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.apache.jcs.access.GroupCacheAccess;
import org.apache.jcs.access.exception.CacheException;
import org.apache.log4j.Category;
import org.apache.torque.TorqueException;
import org.apache.torque.manager.MethodCacheKey;

public class MethodResultCache {
    private static final Category log = Category.getInstance((String)"org.apache.torque");
    private static final String keyClassName = "org.apache.torque.manager.MethodCacheKey";
    private ObjectPool pool;
    private GroupCacheAccess jcsCache;
    private boolean lockCache;
    private int inGet;
    private Map groups;

    public MethodResultCache(GroupCacheAccess cache) throws TorqueException {
        this.jcsCache = cache;
        this.groups = new HashMap();
        this.pool = new StackObjectPool((PoolableObjectFactory)new MethodCacheKey.Factory(), 10000);
    }

    protected MethodResultCache() {
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.remove();
                this.groups.clear();
            }
            catch (CacheException ce) {
                log.error((Object)new TorqueException("Could not clear cache due to internal JCS error.", ce));
            }
        }
    }

    protected Object getImpl(MethodCacheKey key) {
        Object result = null;
        if (this.jcsCache != null) {
            if (this.lockCache) {
                MethodResultCache methodResultCache = this;
                synchronized (methodResultCache) {
                    result = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
                }
            } else {
                ++this.inGet;
                result = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
                --this.inGet;
            }
        }
        if (result != null) {
            log.debug((Object)("MethodResultCache saved expensive operation: " + key));
        }
        return result;
    }

    protected Object putImpl(MethodCacheKey key, Object value) throws TorqueException {
        String group = key.getGroupKey();
        if (!this.groups.containsKey(group)) {
            this.groups.put(group, null);
        }
        Object old = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                this.lockCache = true;
                try {
                    try {
                        old = this.jcsCache.getFromGroup((Object)key, group);
                        while (this.inGet > 0) {
                            Thread.yield();
                        }
                        this.jcsCache.putInGroup((Object)key, group, value);
                    }
                    catch (CacheException ce) {
                        this.lockCache = false;
                        throw new TorqueException("Could not cache due to internal JCS error.", ce);
                    }
                    Object var8_6 = null;
                    this.lockCache = false;
                }
                catch (Throwable throwable) {
                    Object var8_7 = null;
                    this.lockCache = false;
                    throw throwable;
                }
            }
        }
        return old;
    }

    protected Object removeImpl(MethodCacheKey key) throws TorqueException {
        Object old = null;
        if (this.jcsCache != null) {
            MethodResultCache methodResultCache = this;
            synchronized (methodResultCache) {
                this.lockCache = true;
                try {
                    try {
                        old = this.jcsCache.getFromGroup((Object)key, key.getGroupKey());
                        while (this.inGet > 0) {
                            Thread.yield();
                        }
                        this.jcsCache.remove((Object)key, key.getGroupKey());
                    }
                    catch (Exception ce) {
                        this.lockCache = false;
                        throw new TorqueException("Could not cache due to internal JCS error.", ce);
                    }
                    Object var6_4 = null;
                    this.lockCache = false;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    this.lockCache = false;
                    throw throwable;
                }
            }
        }
        return old;
    }

    public Object get(Serializable instanceOrClass, String method) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2, arg3);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object get(Serializable[] keys) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(keys);
                result = this.getImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public void put(Object value, Serializable instanceOrClass, String method) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1, arg2);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(instanceOrClass, method, arg1, arg2, arg3);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void put(Object value, Serializable[] keys) {
        try {
            MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
            key.init(keys);
            this.putImpl(key, value);
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
    }

    public void removeAll(Serializable instanceOrClass, String method) {
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                String groupName = key.getGroupKey();
                this.jcsCache.invalidateGroup(groupName);
                this.groups.remove(groupName);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
    }

    public Object remove(Serializable instanceOrClass, String method) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable instanceOrClass, String method, Serializable arg1, Serializable arg2, Serializable arg3) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(instanceOrClass, method, arg1, arg2, arg3);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }

    public Object remove(Serializable[] keys) {
        Object result = null;
        if (this.jcsCache != null) {
            try {
                MethodCacheKey key = (MethodCacheKey)this.pool.borrowObject();
                key.init(keys);
                result = this.removeImpl(key);
                try {
                    this.pool.returnObject((Object)key);
                }
                catch (Exception e) {
                    log.warn((Object)"Nonfatal error.  Could not return key to pool", (Throwable)e);
                }
            }
            catch (Exception e) {
                log.error((Object)"", (Throwable)e);
            }
        }
        return result;
    }
}

