/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.engine.database.transform;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.torque.engine.database.model.AppData;
import org.apache.torque.engine.database.model.Column;
import org.apache.torque.engine.database.model.Database;
import org.apache.torque.engine.database.model.ForeignKey;
import org.apache.torque.engine.database.model.Index;
import org.apache.torque.engine.database.model.Table;
import org.apache.torque.engine.database.model.Unique;
import org.apache.torque.engine.database.transform.DTDResolver;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlToAppData
extends DefaultHandler {
    private static final boolean DEBUG = false;
    private AppData app;
    private Database currDB;
    private Table currTable;
    private Column currColumn;
    private ForeignKey currFK;
    private Index currIndex;
    private Unique currUnique;
    private boolean firstPass;
    private String errorMessage;
    private boolean isExternalSchema;
    private String currentPackage;
    private String currentXmlFile;
    private String defaultPackage;
    private static SAXParserFactory saxFactory = SAXParserFactory.newInstance();

    public XmlToAppData(String databaseType, String defaultPackage, String basePropsFilePath) {
        this.app = new AppData(databaseType, basePropsFilePath);
        this.defaultPackage = defaultPackage;
        this.firstPass = true;
        this.errorMessage = "";
    }

    public AppData parseFile(String xmlFile) {
        try {
            if (!this.firstPass) {
                throw new Error("No more double pass");
            }
            this.currentXmlFile = xmlFile;
            SAXParser parser = saxFactory.newSAXParser();
            FileReader fr = null;
            try {
                fr = new FileReader(xmlFile);
            }
            catch (FileNotFoundException fnfe) {
                throw new FileNotFoundException(new File(xmlFile).getAbsolutePath());
            }
            BufferedReader br = new BufferedReader(fr);
            try {
                InputSource is = new InputSource(br);
                parser.parse(is, (DefaultHandler)this);
                Object var7_8 = null;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                br.close();
                throw throwable;
            }
            br.close();
            {
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.isExternalSchema) {
            this.firstPass = false;
        }
        if (this.errorMessage.length() > 0) {
            System.out.println("Error in XML schema: " + this.errorMessage);
        }
        return this.app;
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        return new DTDResolver().resolveEntity(publicId, systemId);
    }

    public void startElement(String uri, String localName, String rawName, Attributes attributes) {
        try {
            if (rawName.equals("database")) {
                if (this.isExternalSchema) {
                    this.currentPackage = attributes.getValue("package");
                    if (this.currentPackage == null) {
                        this.currentPackage = this.defaultPackage;
                    }
                } else {
                    this.currDB = this.app.addDatabase(attributes);
                }
            } else if (rawName.equals("external-schema")) {
                this.isExternalSchema = true;
                String xmlFile = attributes.getValue("filename");
                if (xmlFile.charAt(0) != '/') {
                    File f = new File(this.currentXmlFile);
                    xmlFile = new File(f.getParent(), xmlFile).getPath();
                }
                this.parseFile(xmlFile);
                this.isExternalSchema = false;
            } else if (rawName.equals("table")) {
                this.currTable = this.currDB.addTable(attributes);
                if (this.isExternalSchema) {
                    this.currTable.setForReferenceOnly(true);
                    this.currTable.setPackage(this.currentPackage);
                }
            } else if (rawName.equals("column")) {
                this.currColumn = this.currTable.addColumn(attributes);
            } else if (rawName.equals("inheritance")) {
                this.currColumn.addInheritance(attributes);
            } else if (rawName.equals("foreign-key")) {
                this.currFK = this.currTable.addForeignKey(attributes);
            } else if (rawName.equals("reference")) {
                this.currFK.addReference(attributes);
            } else if (rawName.equals("index")) {
                this.currIndex = this.currTable.addIndex(attributes);
            } else if (rawName.equals("index-column")) {
                this.currIndex.addColumn(attributes);
            } else if (rawName.equals("unique")) {
                this.currUnique = this.currTable.addUnique(attributes);
            } else if (rawName.equals("unique-column")) {
                this.currUnique.addColumn(attributes);
            } else if (rawName.equals("id-method-parameter")) {
                this.currTable.addIdMethodParameter(attributes);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void endElement(String uri, String localName, String rawName) {
    }

    public void warning(SAXParseException spe) {
        this.printParseError("Warning", spe);
    }

    public void error(SAXParseException spe) {
        this.printParseError("Error", spe);
    }

    public void fatalError(SAXParseException spe) {
        this.printParseError("Fatal Error", spe);
    }

    private final void printParseError(String type, SAXParseException spe) {
        System.err.println(type + " [line " + spe.getLineNumber() + ", row " + spe.getColumnNumber() + "]: " + spe.getMessage());
    }

    static {
        saxFactory.setValidating(true);
    }
}

