/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.log4j.Category;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.stratum.lifecycle.Configurable;
import org.apache.stratum.lifecycle.Disposable;
import org.apache.stratum.lifecycle.Initializable;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.DB;
import org.apache.torque.adapter.DBFactory;
import org.apache.torque.dsfactory.DataSourceFactory;
import org.apache.torque.manager.AbstractBaseManager;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;
import org.apache.torque.oid.IDBroker;
import org.apache.torque.oid.IDGeneratorFactory;
import org.apache.torque.util.BasePeer;

public class Torque
implements Initializable,
Configurable,
Disposable {
    public static final String DATABASE_DEFAULT = "database.default";
    private static final String DEFAULT_NAME = "default";
    public static final String MANAGER_PREFIX = "managed_class.";
    public static final String MANAGER_SUFFIX = ".manager";
    public static final String CACHE_KEY = "manager.useCache";
    private static String defaultDBName;
    private static Map dbMaps;
    private static Map dsFactoryMap;
    private static Map adapterMap;
    protected static Map managers;
    private static Category category;
    private static Configuration configuration;
    private static boolean isInit;
    private static List mapBuilders;
    static /* synthetic */ Class class$org$apache$torque$Torque;

    public void initialize() throws TorqueException {
        if (configuration == null) {
            throw new TorqueException("Torque cannot be initialized without a valid configuration. Please check the log files for further details.");
        }
        Torque.configureLogging();
        Configuration originalConf = configuration;
        configuration = configuration.subset("torque");
        if ((configuration == null || configuration.isEmpty()) && ((configuration = originalConf.subset("services.DatabaseService")) == null || configuration.isEmpty())) {
            configuration = originalConf;
        }
        dbMaps = new HashMap();
        Torque.initAdapters(configuration);
        Torque.initDataSourceFactories(configuration);
        isInit = true;
        Iterator i = mapBuilders.iterator();
        while (i.hasNext()) {
            BasePeer.getMapBuilder((String)i.next());
        }
        mapBuilders = null;
        Torque.initManagerMappings(configuration);
    }

    private static final void initAdapters(Configuration configuration) throws TorqueException {
        category.debug((Object)"Starting initAdapters");
        adapterMap = new HashMap();
        Configuration c = configuration.subset("database");
        if (c != null) {
            try {
                Iterator i = c.getKeys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (!key.endsWith("adapter")) continue;
                    String adapter = c.getString(key);
                    String handle = key.substring(0, key.indexOf(46));
                    DB db = DBFactory.create(adapter);
                    adapterMap.put(handle, db);
                }
            }
            catch (Exception e) {
                category.error((Object)"", (Throwable)e);
                throw new TorqueException(e);
            }
        } else {
            category.warn((Object)"There were no adapters in the configuration.");
        }
    }

    private static void initDataSourceFactories(Configuration configuration) throws TorqueException {
        category.debug((Object)"Starting initDSF");
        dsFactoryMap = new HashMap();
        Configuration c = configuration.subset("dsfactory");
        if (c != null) {
            try {
                Iterator i = c.getKeys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (!key.endsWith("factory")) continue;
                    String classname = c.getString(key);
                    String handle = key.substring(0, key.indexOf(46));
                    category.debug((Object)("handle: " + handle + " DataSourceFactory: " + classname));
                    Class<?> dsfClass = Class.forName(classname);
                    DataSourceFactory dsf = (DataSourceFactory)dsfClass.newInstance();
                    dsf.initialize(c.subset(handle));
                    dsFactoryMap.put(handle, dsf);
                }
            }
            catch (Exception e) {
                category.error((Object)"", (Throwable)e);
                throw new TorqueException(e);
            }
        }
        String defaultDB = Torque.getDefaultDB();
        if (dsFactoryMap.get(DEFAULT_NAME) == null && !defaultDB.equals(DEFAULT_NAME)) {
            category.debug((Object)("Adding a dummy entry for default, mapped onto " + defaultDB));
            dsFactoryMap.put(DEFAULT_NAME, dsFactoryMap.get(defaultDB));
        }
    }

    public void configure(Configuration config) throws TorqueException {
        configuration = config;
    }

    public static void init(String configFile) throws TorqueException {
        try {
            PropertiesConfiguration c = new PropertiesConfiguration(configFile);
            Torque.init((Configuration)c);
        }
        catch (IOException e) {
            throw new TorqueException(e);
        }
    }

    public static void init(Configuration c) throws TorqueException {
        Torque torque = new Torque();
        torque.configure(c);
        torque.initialize();
    }

    protected static void initManagerMappings(Configuration configuration) throws TorqueException {
        int pref = MANAGER_PREFIX.length();
        int suff = MANAGER_SUFFIX.length();
        Iterator keys = configuration.getKeys();
        while (keys.hasNext()) {
            String managedClassKey;
            String key = (String)keys.next();
            if (!key.startsWith(MANAGER_PREFIX) || !key.endsWith(MANAGER_SUFFIX) || managers.containsKey(managedClassKey = key.substring(pref, key.length() - suff))) continue;
            String managerClass = configuration.getString(key);
            category.info((Object)("Added Manager for Class: " + managedClassKey + " -> " + managerClass));
            try {
                Torque.initManager(managedClassKey, managerClass);
            }
            catch (TorqueException e) {
                category.error((Object)"", (Throwable)((Object)e));
                e.printStackTrace();
                throw e;
            }
        }
    }

    private static synchronized void initManager(String name, String className) throws TorqueException {
        AbstractBaseManager manager = (AbstractBaseManager)managers.get(name);
        if (manager == null && className != null && className.length() != 0) {
            try {
                manager = (AbstractBaseManager)Class.forName(className).newInstance();
                managers.put(name, manager);
            }
            catch (Exception e) {
                throw new TorqueException("Could not instantiate manager associated with class: " + name, e);
            }
        }
    }

    public static boolean isInit() {
        return isInit;
    }

    public static void setConfiguration(Configuration c) {
        configuration = c;
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    protected static void configureLogging() {
        if (!Torque.isLoggingConfigured()) {
            String applicationRoot = Torque.getConfiguration().getString("torque.applicationRoot", ".");
            File logsDir = new File(applicationRoot, "logs");
            if (!logsDir.exists() && !logsDir.mkdirs()) {
                System.err.println("Cannot create logs directory!");
            }
            Properties p = new Properties();
            ((Hashtable)p).put("torque.applicationRoot", applicationRoot);
            Iterator i = Torque.getConfiguration().getKeys();
            while (i.hasNext()) {
                String key = (String)i.next();
                if (!key.startsWith("log4j")) continue;
                String[] values = Torque.getConfiguration().getStringArray(key);
                String value = values.length == 1 ? values[0] : values[0] + "," + values[1];
                ((Hashtable)p).put(key, value);
            }
            PropertyConfigurator.configure((Properties)p);
            category.info((Object)"Logging has been configured by Torque.");
        }
    }

    protected static boolean isLoggingConfigured() {
        Enumeration enumeration = Category.getRoot().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            return true;
        }
        Enumeration cats = Category.getCurrentCategories();
        while (cats.hasMoreElements()) {
            Category c = (Category)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            return true;
        }
        return false;
    }

    public static AbstractBaseManager getManager(String name) {
        AbstractBaseManager m = (AbstractBaseManager)managers.get(name);
        if (m == null) {
            category.error((Object)("No configured manager for key " + name + "."));
        }
        return m;
    }

    public static AbstractBaseManager getManager(String name, String defaultClassName) {
        AbstractBaseManager m = (AbstractBaseManager)managers.get(name);
        if (m == null) {
            category.debug((Object)("Added late Manager mapping for Class: " + name + " -> " + defaultClassName));
            try {
                Torque.initManager(name, defaultClassName);
            }
            catch (TorqueException e) {
                category.error((Object)e.getMessage(), (Throwable)((Object)e));
            }
            m = (AbstractBaseManager)managers.get(name);
        }
        return m;
    }

    public void dispose() {
        Torque.shutdown();
    }

    public static void shutdown() {
        if (dbMaps != null) {
            Iterator maps = dbMaps.values().iterator();
            while (maps.hasNext()) {
                DatabaseMap map = (DatabaseMap)maps.next();
                IDBroker idBroker = map.getIDBroker();
                if (idBroker == null) continue;
                idBroker.stop();
            }
        }
    }

    public static DatabaseMap getDatabaseMap() throws TorqueException {
        return Torque.getDatabaseMap(Torque.getDefaultDB());
    }

    public static DatabaseMap getDatabaseMap(String name) throws TorqueException {
        if (name == null) {
            throw new TorqueException("DatabaseMap name was null!");
        }
        if (dbMaps == null) {
            throw new TorqueException("Torque was not initialized properly.");
        }
        Map map = dbMaps;
        synchronized (map) {
            DatabaseMap map2 = (DatabaseMap)dbMaps.get(name);
            if (map2 == null) {
                map2 = Torque.initDatabaseMap(name);
            }
            DatabaseMap databaseMap = map2;
            return databaseMap;
        }
    }

    private static final DatabaseMap initDatabaseMap(String name) throws TorqueException {
        DatabaseMap map = new DatabaseMap(name);
        Torque.setupIdTable(map);
        try {
            String key = Torque.getDatabaseProperty(name, "driver");
            if (key == null || key.length() == 0) {
                key = Torque.getDatabaseProperty(name, "adapter");
            }
            DB db = DBFactory.create(key);
            int i = 0;
            while (i < IDGeneratorFactory.ID_GENERATOR_METHODS.length) {
                map.addIdGenerator(IDGeneratorFactory.ID_GENERATOR_METHODS[i], IDGeneratorFactory.create(db));
                ++i;
            }
        }
        catch (InstantiationException e) {
            throw new TorqueException(e);
        }
        HashMap<String, DatabaseMap> newMaps = new HashMap<String, DatabaseMap>(dbMaps);
        newMaps.put(name, map);
        dbMaps = newMaps;
        return map;
    }

    public static void registerMapBuilder(String className) {
        mapBuilders.add(className);
    }

    private static String getDatabaseProperty(String db, String prop) {
        return configuration.getString("database." + db + '.' + prop, "");
    }

    private static final void setupIdTable(DatabaseMap map) {
        map.setIdTable("ID_TABLE");
        TableMap tMap = map.getIdTable();
        tMap.addPrimaryKey("ID_TABLE_ID", new Integer(0));
        tMap.addColumn("TABLE_NAME", new String(""));
        tMap.addColumn("NEXT_ID", new Integer(0));
        tMap.addColumn("QUANTITY", new Integer(0));
    }

    public static Connection getConnection() throws TorqueException, SQLException, NamingException {
        return Torque.getConnection(Torque.getDefaultDB());
    }

    public static Connection getConnection(String name, String username, String password) throws TorqueException {
        Connection con = null;
        DataSourceFactory dsf = null;
        try {
            dsf = (DataSourceFactory)dsFactoryMap.get(name);
            con = dsf.getDataSource().getConnection(username, password);
        }
        catch (Exception e) {
            if (dsf == null && e instanceof NullPointerException) {
                throw new NullPointerException("There was no DataSourceFactory configured for the connection " + name);
            }
            throw new TorqueException(e);
        }
        return con;
    }

    public static Connection getConnection(String name) throws TorqueException {
        Connection con = null;
        DataSourceFactory dsf = null;
        try {
            dsf = (DataSourceFactory)dsFactoryMap.get(name);
            con = dsf.getDataSource().getConnection();
        }
        catch (Exception e) {
            if (dsf == null && e instanceof NullPointerException) {
                throw new NullPointerException("There was no DataSourceFactory configured for the connection " + name);
            }
            throw new TorqueException(e);
        }
        return con;
    }

    public static DB getDB(String name) throws TorqueException {
        return (DB)adapterMap.get(name);
    }

    public static String getDefaultDB() {
        if (configuration == null) {
            return DEFAULT_NAME;
        }
        if (defaultDBName == null) {
            defaultDBName = configuration.getString(DATABASE_DEFAULT, DEFAULT_NAME);
        }
        return defaultDBName;
    }

    public static String getDefaultMap() {
        return Torque.getDefaultDB();
    }

    public static void closeConnection(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException e) {
                category.error((Object)"Error occured while closing connection.", (Throwable)e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        managers = new HashMap();
        category = Category.getInstance((String)(class$org$apache$torque$Torque == null ? (class$org$apache$torque$Torque = Torque.class$("org.apache.torque.Torque")) : class$org$apache$torque$Torque).getName());
        isInit = false;
        mapBuilders = Collections.synchronizedList(new ArrayList());
    }
}

