/*
 * Decompiled with CFR 0.152.
 */
package org.apache.util;

import java.io.IOException;
import java.io.Writer;

public class XMLPrinter {
    public static final int OPENING = 0;
    public static final int CLOSING = 1;
    public static final int NO_CONTENT = 2;
    protected StringBuffer buffer = new StringBuffer();
    protected Writer writer = null;

    public XMLPrinter() {
    }

    public XMLPrinter(Writer writer) {
        this.writer = writer;
    }

    public void sendData() throws IOException {
        if (this.writer != null) {
            this.writer.write(this.buffer.toString());
            this.buffer = new StringBuffer();
        }
    }

    public String toString() {
        return this.buffer.toString();
    }

    public void writeData(String data) {
        this.buffer.append("<![CDATA[");
        this.buffer.append(data);
        this.buffer.append("]]>");
    }

    public void writeElement(String namespace, String name, int type) {
        this.writeElement(namespace, null, name, type);
    }

    public void writeElement(String namespace, String namespaceInfo, String name, int type) {
        if (namespace != null && namespace.length() > 0) {
            switch (type) {
                case 0: {
                    if (namespaceInfo != null && namespaceInfo.length() > 0) {
                        this.buffer.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\">");
                        break;
                    }
                    this.buffer.append("<" + namespace + ":" + name + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + namespace + ":" + name + ">");
                    break;
                }
                default: {
                    if (namespaceInfo != null && namespaceInfo.length() > 0) {
                        this.buffer.append("<" + namespace + ":" + name + " xmlns:" + namespace + "=\"" + namespaceInfo + "\"/>");
                        break;
                    }
                    this.buffer.append("<" + namespace + ":" + name + "/>");
                    break;
                }
            }
        } else {
            switch (type) {
                case 0: {
                    if (namespaceInfo != null && namespaceInfo.length() > 0) {
                        this.buffer.append("<" + name + " xmlns=\"" + namespaceInfo + "\">");
                        break;
                    }
                    this.buffer.append("<" + name + ">");
                    break;
                }
                case 1: {
                    this.buffer.append("</" + name + ">");
                    break;
                }
                default: {
                    if (namespaceInfo != null && namespaceInfo.length() > 0) {
                        this.buffer.append("<" + name + " xmlns=\"" + namespaceInfo + "\"/>");
                        break;
                    }
                    this.buffer.append("<" + name + "/>");
                    break;
                }
            }
        }
    }

    public void writeProperty(String namespace, String name) {
        this.writeElement(namespace, name, 2);
    }

    public void writeProperty(String namespace, String name, String value) {
        this.writeProperty(namespace, null, name, value);
    }

    public void writeProperty(String namespace, String namespaceInfo, String name, String value) {
        this.writeProperty(namespace, namespaceInfo, name, value, false);
    }

    public void writeProperty(String namespace, String namespaceInfo, String name, String value, boolean cdata) {
        this.writeElement(namespace, namespaceInfo, name, 0);
        if (cdata) {
            this.writeData(value);
        } else {
            this.writeText(value);
        }
        this.writeElement(namespace, namespaceInfo, name, 1);
    }

    public void writeText(String text) {
        this.buffer.append(text);
    }

    public void writeXMLHeader() {
        this.buffer.append("<?xml version=\"1.0\" encoding=\"utf-8\" ?>");
    }
}

