/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.util.conf;

import java.util.Enumeration;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationException;

public abstract class AbstractConfiguration
implements Configuration {
    protected String location = "";

    protected AbstractConfiguration() {
        this(null, -1);
    }

    protected AbstractConfiguration(String source, int line) {
        if (source != null) {
            this.location = source;
        }
        if (line >= 0 && this.location.length() > 0) {
            this.location = String.valueOf(this.location) + " ";
        }
        if (line > 0) {
            this.location = String.valueOf(this.location) + "line " + line;
        }
        this.location = this.location.length() > 0 ? "(" + this.location + ")" : null;
    }

    public abstract String getAttribute(String var1) throws ConfigurationException;

    public String getAttribute(String name, String defaultValue) {
        try {
            return this.getAttribute(name);
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public boolean getAttributeAsBoolean(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a boolean", this);
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        try {
            return this.getAttributeAsBoolean(name);
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public float getAttributeAsFloat(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a float", this);
        }
    }

    public float getAttributeAsFloat(String name, float defaultValue) {
        try {
            return this.getAttributeAsFloat(name);
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public int getAttributeAsInt(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as an integer", this);
        }
    }

    public int getAttributeAsInt(String name, int defaultValue) {
        try {
            return this.getAttributeAsInt(name);
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public long getAttributeAsLong(String name) throws ConfigurationException {
        String value = this.getAttribute(name);
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the attribute \"" + name + "\" of the configuration element \"" + this.getName() + "\" as a long", this);
        }
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        try {
            return this.getAttributeAsLong(name);
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public Configuration getConfiguration(String name) {
        Enumeration e = this.getConfigurations(name);
        if (e.hasMoreElements()) {
            return (Configuration)e.nextElement();
        }
        return null;
    }

    public abstract Enumeration getConfigurations(String var1);

    public String getLocation() {
        return this.location;
    }

    public abstract String getName();

    public abstract String getValue();

    public String getValue(String defaultValue) {
        try {
            return this.getValue();
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public boolean getValueAsBoolean() throws ConfigurationException {
        String value = this.getValue();
        if (value.equals("true")) {
            return true;
        }
        if (value.equals("false")) {
            return false;
        }
        throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a boolean", this);
    }

    public boolean getValueAsBoolean(boolean defaultValue) {
        try {
            return this.getValueAsBoolean();
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public float getValueAsFloat() throws ConfigurationException {
        String value = this.getValue();
        try {
            return Float.valueOf(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a float", this);
        }
    }

    public float getValueAsFloat(float defaultValue) {
        try {
            return this.getValueAsFloat();
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public int getValueAsInt() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Integer.parseInt(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Integer.parseInt(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Integer.parseInt(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as an integer", this);
        }
    }

    public int getValueAsInt(int defaultValue) {
        try {
            return this.getValueAsInt();
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }

    public long getValueAsLong() throws ConfigurationException {
        String value = this.getValue();
        try {
            if (value.startsWith("0x")) {
                return Long.parseLong(value.substring(2), 16);
            }
            if (value.startsWith("0o")) {
                return Long.parseLong(value.substring(2), 8);
            }
            if (value.startsWith("0b")) {
                return Long.parseLong(value.substring(2), 2);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ConfigurationException("Cannot parse the value of the configuration element \"" + this.getName() + "\" as a long", this);
        }
    }

    public long getValueAsLong(long defaultValue) {
        try {
            return this.getValueAsLong();
        }
        catch (ConfigurationException configurationException) {
            return defaultValue;
        }
    }
}

