/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.transaction;

import java.util.Hashtable;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.slide.transaction.SlideTransaction;
import org.apache.slide.util.Messages;
import org.apache.slide.util.logger.Logger;
import org.apache.slide.util.logger.SimpleLogger;

public final class SlideTransactionManager
implements TransactionManager {
    protected static final String LOG_CHANNEL = (class$org$apache$slide$transaction$SlideTransactionManager != null ? class$org$apache$slide$transaction$SlideTransactionManager : (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager"))).getName();
    public static final int DEFAULT_TRANSACTION_TIMEOUT = 30;
    private Hashtable bindings = new Hashtable();
    private Hashtable timeouts = new Hashtable();
    private Logger logger = new SimpleLogger();
    static /* synthetic */ Class class$org$apache$slide$transaction$SlideTransactionManager;

    public void begin() throws NotSupportedException, SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction != null) {
            throw new NotSupportedException();
        }
        currentTransaction = new SlideTransaction(this);
        this.bindings.put(Thread.currentThread(), currentTransaction);
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransactionManager != null ? class$org$apache$slide$transaction$SlideTransactionManager : (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager"))).getName()) + ".begin", currentTransaction.toString());
            this.logger.log(logMessage, LOG_CHANNEL, 7);
        }
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        Thread currentThread = Thread.currentThread();
        Transaction currentTransaction = (Transaction)this.bindings.get(currentThread);
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        this.timeouts.remove(currentThread);
        if (this.logger.isEnabled(LOG_CHANNEL, 7)) {
            String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransactionManager != null ? class$org$apache$slide$transaction$SlideTransactionManager : (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager"))).getName()) + ".commit", currentTransaction.toString());
            this.logger.log(logMessage, LOG_CHANNEL, 7);
        }
        try {
            currentTransaction.commit();
        }
        finally {
            Object var4_5 = null;
            this.bindings.remove(currentThread);
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public int getStatus() throws SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction == null) {
            return 6;
        }
        return currentTransaction.getStatus();
    }

    public Transaction getTransaction() throws SystemException {
        return (Transaction)this.bindings.get(Thread.currentThread());
    }

    public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
        if (this.getTransaction() != null) {
            throw new IllegalStateException();
        }
        if (tobj == null) {
            throw new InvalidTransactionException();
        }
        this.bindings.put(Thread.currentThread(), tobj);
    }

    public void rollback() throws SecurityException, IllegalStateException, SystemException {
        Thread currentThread = Thread.currentThread();
        Transaction currentTransaction = (Transaction)this.bindings.remove(currentThread);
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        this.timeouts.remove(currentThread);
        String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransactionManager != null ? class$org$apache$slide$transaction$SlideTransactionManager : (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager"))).getName()) + ".rollback", currentTransaction.toString());
        this.logger.log(logMessage, LOG_CHANNEL, 4);
        currentTransaction.rollback();
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction == null) {
            throw new IllegalStateException();
        }
        String logMessage = Messages.format(String.valueOf((class$org$apache$slide$transaction$SlideTransactionManager != null ? class$org$apache$slide$transaction$SlideTransactionManager : (class$org$apache$slide$transaction$SlideTransactionManager = SlideTransactionManager.class$("org.apache.slide.transaction.SlideTransactionManager"))).getName()) + ".rollbackOnly", currentTransaction.toString());
        this.logger.log(logMessage, LOG_CHANNEL, 6);
        currentTransaction.setRollbackOnly();
    }

    public void setTransactionTimeout(int seconds) throws SystemException {
        this.timeouts.put(Thread.currentThread(), new Integer(seconds));
    }

    public Transaction suspend() throws SystemException {
        Transaction currentTransaction = this.getTransaction();
        if (currentTransaction != null) {
            Thread currentThread = Thread.currentThread();
            this.bindings.remove(currentThread);
            this.timeouts.remove(currentThread);
        }
        return currentTransaction;
    }
}

