/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

class JDBCAwareInputStream
extends FilterInputStream {
    private Statement stmt = null;

    public JDBCAwareInputStream(InputStream in, Statement stmt) {
        super(in);
        this.stmt = stmt;
    }

    public void close() throws IOException {
        if (this.stmt != null) {
            try {
                this.stmt.close();
                ResultSet rs = this.stmt.getResultSet();
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException sqle) {
                throw new IOException(sqle.getMessage());
            }
            this.stmt = null;
        }
        super.close();
    }
}

