/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.store.impl.rdbms;

import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.slide.common.Service;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.Uri;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.LockTokenNotFoundException;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.security.NodePermission;
import org.apache.slide.store.LockStore;
import org.apache.slide.store.NodeStore;
import org.apache.slide.store.RevisionDescriptorStore;
import org.apache.slide.store.RevisionDescriptorsStore;
import org.apache.slide.store.SecurityStore;
import org.apache.slide.store.impl.rdbms.J2EEStore;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;

public class J2EEDescriptorsStore
extends J2EEStore
implements LockStore,
NodeStore,
RevisionDescriptorsStore,
RevisionDescriptorStore,
SecurityStore {
    protected NodeRevisionDescriptor myRevisionDescriptor = null;

    public void createObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectAlreadyExistsException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                long link_to;
                this.setUriId(uri.toString());
                long uriid = this.getUriId(uri.toString());
                String className = object.getClass().getName();
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select 1 from OBJECT where URI_ID= ");
                theSQL.append(uriid);
                ResultSet res = statement.executeQuery(theSQL.toString());
                if (res.next()) {
                    throw new ObjectAlreadyExistsException(uri.toString());
                }
                theSQL = new StringBuffer("insert into OBJECT (URI_ID,CLASS_NAME) values ( ");
                theSQL.append(uriid).append(" , '").append(className).append("' )");
                statement.execute(theSQL.toString());
                Enumeration children = this.getNewChildren(uriid, object.enumerateChildren());
                if (children != null) {
                    while (children.hasMoreElements()) {
                        theSQL = new StringBuffer("insert into CHILDREN ");
                        theSQL.append("(URI_ID,CHILD_URI_ID) values( ");
                        theSQL.append(uriid).append(" , ").append(this.getUriId((String)children.nextElement())).append(" )");
                        statement.execute(theSQL.toString());
                    }
                }
                if (object instanceof LinkNode && !this.isLinkExist(uriid, link_to = this.getUriId(((LinkNode)object).getLinkedUri()))) {
                    theSQL = new StringBuffer("insert into LINKS (URI_ID,");
                    theSQL.append("LINK_TO_ID) values( ");
                    theSQL.append(uriid).append(" , '").append(link_to).append("' )");
                    statement.execute(theSQL.toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_14 = null;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void createRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                ResultSet res = null;
                long uriid = this.getUriId(uri.toString());
                long brid = this.getBranchID(revisionDescriptor.getBranchName());
                if (brid == 0L) {
                    this.setBranchID(revisionDescriptor.getBranchName());
                    brid = this.getBranchID(revisionDescriptor.getBranchName());
                }
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("SELECT 1 FROM VERSION WHERE URI_ID =");
                theSQL.append(uriid);
                res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    theSQL = new StringBuffer("insert into VERSION (URI_ID,IS_VERSIONED) values( ");
                    theSQL.append(uriid).append(", ").append(0).append(")");
                    statement.execute(theSQL.toString());
                }
                theSQL = new StringBuffer("SELECT 1 FROM VERSION_HISTORY WHERE URI_ID =");
                theSQL.append(uriid).append(" and BRANCH_ID = ");
                theSQL.append(brid).append(" and REVISION_NO = '");
                theSQL.append(revisionDescriptor.getRevisionNumber().toString());
                theSQL.append("'");
                res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    theSQL = new StringBuffer("insert into VERSION_HISTORY (URI_ID,BRANCH_ID,");
                    theSQL.append("REVISION_NO) values(");
                    theSQL.append(uriid).append(", ").append(brid);
                    theSQL.append(", '").append(revisionDescriptor.getRevisionNumber().toString());
                    theSQL.append("')");
                    statement.execute(theSQL.toString());
                }
                long Version_ID = this.getVersionID(uriid, revisionDescriptor.getBranchName(), revisionDescriptor.getRevisionNumber().toString());
                Enumeration labels = revisionDescriptor.enumerateLabels();
                while (labels.hasMoreElements()) {
                    String sLabel = (String)labels.nextElement();
                    long label = this.getLabelID(sLabel);
                    if (label == 0L) {
                        this.setLabelID(sLabel);
                        label = this.getLabelID(sLabel);
                    }
                    theSQL = new StringBuffer("insert into VERSION_LABELS ");
                    theSQL.append("(VERSION_ID,LABEL_ID) values( ");
                    theSQL.append(Version_ID).append(", ");
                    theSQL.append(label).append(")");
                    statement.execute(theSQL.toString());
                }
                Enumeration properties = revisionDescriptor.enumerateProperties();
                PreparedStatement pstmt = connection.prepareStatement("insert into PROPERTIES (VERSION_ID,PROPERTY_NAMESPACE,PROPERTY_NAME,PROPERTY_VALUE,PROPERTY_TYPE,IS_PROTECTED) values(?,?,?,?,?,? )");
                while (properties.hasMoreElements()) {
                    NodeProperty property = (NodeProperty)properties.nextElement();
                    int protectedProperty = 0;
                    if (property.isProtected()) {
                        protectedProperty = 1;
                    }
                    pstmt.setLong(1, Version_ID);
                    pstmt.setString(2, property.getNamespace());
                    pstmt.setString(3, property.getName());
                    pstmt.setString(4, property.getValue().toString());
                    pstmt.setString(5, property.getType());
                    pstmt.setInt(6, protectedProperty);
                    pstmt.execute();
                }
                pstmt.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_18 = null;
        }
        catch (Throwable throwable) {
            Object var6_19 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void createRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                ResultSet res = null;
                int isVersioned = 0;
                if (revisionDescriptors.isVersioned()) {
                    isVersioned = 1;
                }
                long urid = this.getUriId(uri.toString());
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("SELECT 1 FROM VERSION WHERE URI_ID =");
                theSQL.append(urid);
                res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    theSQL = new StringBuffer("insert into VERSION ");
                    theSQL.append("(URI_ID,IS_VERSIONED) values( ");
                    theSQL.append(urid).append(", ").append(isVersioned).append(")");
                    statement.execute(theSQL.toString());
                }
                long brid = this.getBranchID("main".toString());
                theSQL = new StringBuffer("SELECT 1 FROM VERSION_HISTORY WHERE URI_ID =");
                theSQL.append(urid).append(" and BRANCH_ID = ").append(brid);
                if (revisionDescriptors.getLatestRevision() == null) {
                    theSQL.append(" and REVISION_NO = ").append("NULL");
                } else {
                    theSQL.append(" and REVISION_NO = '").append(revisionDescriptors.getLatestRevision().toString()).append("'");
                }
                res = statement.executeQuery(theSQL.toString());
                if (!res.next() && revisionDescriptors.getLatestRevision() != null) {
                    theSQL = new StringBuffer("insert into VERSION_HISTORY ");
                    theSQL.append("(URI_ID,BRANCH_ID,REVISION_NO) values(");
                    theSQL.append(urid).append(", ").append(brid);
                    theSQL.append(", '").append(revisionDescriptors.getLatestRevision().toString()).append("')");
                    statement.execute(theSQL.toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_12 = null;
        }
        catch (Throwable throwable) {
            Object var6_13 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public Enumeration enumerateLocks(Uri uri) throws ServiceAccessException {
        Vector<NodeLock> lockVector = new Vector<NodeLock>();
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select * from LOCKS where OBJECT_ID= ");
                theSQL.append(this.getUriId(uri.toString()));
                ResultSet res = statement.executeQuery(theSQL.toString());
                while (res.next()) {
                    Date expirationDate = null;
                    try {
                        Long timeValue = new Long(res.getLong("EXPIRATION_DATE"));
                        expirationDate = new Date(timeValue);
                    }
                    catch (NumberFormatException numberFormatException) {
                        expirationDate = new Date();
                    }
                    NodeLock lock = new NodeLock(this.getUri(res.getLong("LOCK_ID")), this.getUri(res.getLong("OBJECT_ID")), this.getUri(res.getLong("SUBJECT_ID")), this.getUri(res.getLong("TYPE_ID")), expirationDate, res.getBoolean("IS_INHERITABLE"), res.getBoolean("IS_EXCLUSIVE"));
                    lockVector.addElement(lock);
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        return lockVector.elements();
    }

    public Enumeration enumeratePermissions(Uri uri) throws ServiceAccessException {
        Vector<NodePermission> permissionVector = new Vector<NodePermission>();
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select * from PERMISSIONS ");
                theSQL.append("where OBJECT_ID = ");
                theSQL.append(this.getUriId(uri.toString()));
                statement.execute(theSQL.toString());
                ResultSet res = statement.executeQuery(theSQL.toString());
                String object = null;
                while (res.next()) {
                    if (object == null) {
                        object = this.getUri(res.getLong("OBJECT_ID"));
                    }
                    String revision = res.getString("VERSION_NO");
                    String subject = this.getUri(res.getLong("SUBJECT_ID"));
                    String action = this.getUri(res.getLong("ACTION_ID"));
                    boolean inheritable = res.getBoolean("IS_INHERITABLE");
                    boolean negative = res.getBoolean("IS_NEGATIVE");
                    NodePermission permission = new NodePermission(object, revision, subject, action, inheritable, negative);
                    permissionVector.addElement(permission);
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_16 = null;
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        return permissionVector.elements();
    }

    protected long getBranchID(String branchName) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select BRANCH_ID from BRANCH where BRANCH_STRING = '");
        theSQL.append(branchName).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getLong("BRANCH_ID");
        }
        return 0L;
    }

    protected long getLabelID(String labelName) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select LABEL_ID from LABEL where LABEL_STRING = '");
        theSQL.append(labelName).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getLong("LABEL_ID");
        }
        return 0L;
    }

    protected String getLabelName(long labelID) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select LABEL_STRING from LABEL where LABEL_ID= ");
        theSQL.append(labelID);
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getString("LABEL_STRING");
        }
        return null;
    }

    protected Enumeration getNewChildren(long parent, Enumeration childlist) throws SQLException {
        Hashtable<String, String> hshtempHash = new Hashtable<String, String>();
        Hashtable<String, String> hshnewChild = new Hashtable<String, String>();
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select A.URI_STRING FROM URI A, CHILDREN B WHERE A.URI_ID = ");
        theSQL.append("B.CHILD_URI_ID AND B.URI_ID = ");
        theSQL.append(parent);
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        String s_child = null;
        while (rslt.next()) {
            s_child = rslt.getString("URI_STRING");
            hshtempHash.put(s_child, s_child);
        }
        rslt.close();
        while (childlist.hasMoreElements()) {
            String temp_child = (String)childlist.nextElement();
            if (hshtempHash.containsKey(temp_child)) continue;
            hshnewChild.put(temp_child, temp_child);
        }
        hshtempHash.clear();
        return hshnewChild.elements();
    }

    protected long getVersionID(long uri_id, String branch_name, String sXNumber) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select A.VERSION_ID from VERSION_HISTORY A, BRANCH B ");
        theSQL.append("where  A.URI_ID= ");
        theSQL.append(uri_id).append(" and A.BRANCH_ID = B.BRANCH_ID and");
        theSQL.append(" B.BRANCH_STRING = '").append(branch_name);
        theSQL.append("' and A.REVISION_NO= '").append(sXNumber).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getLong("VERSION_ID");
        }
        return 0L;
    }

    protected String getXNumber(long version_id, long uri_id, String branch_name) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select A.REVISION_NO from VERSION_HISTORY A, ");
        theSQL.append("BRANCH B where A.VERSION_ID = ");
        theSQL.append(version_id).append(" and A.URI_ID= ");
        theSQL.append(uri_id).append(" and A.BRANCH_ID = B.BRANCH_ID");
        theSQL.append(" and B.BRANCH_STRING = '");
        theSQL.append(branch_name).append("'");
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        if (rslt.next()) {
            return rslt.getString("REVISION_NO");
        }
        return null;
    }

    public void grantPermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                String revisionNumberStr = revisionNumber == null ? "NULL" : revisionNumber.toString();
                this.setUriId(permission.getObjectUri());
                this.setUriId(permission.getSubjectUri());
                this.setUriId(permission.getActionUri());
                long objid = this.getUriId(permission.getObjectUri());
                long subid = this.getUriId(permission.getSubjectUri());
                long actid = this.getUriId(permission.getActionUri());
                StringBuffer theSQL = new StringBuffer("select 1 from PERMISSIONS");
                theSQL.append(" where OBJECT_ID = ");
                theSQL.append(objid).append(" and SUBJECT_ID= ").append(subid).append(" and ACTION_ID = ").append(actid);
                ResultSet res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    theSQL = new StringBuffer("insert into PERMISSIONS ");
                    theSQL.append("(OBJECT_ID,SUBJECT_ID,ACTION_ID,VERSION_NO,");
                    theSQL.append("IS_INHERITABLE,IS_NEGATIVE) values( ");
                    theSQL.append(objid).append(", ").append(subid).append(", ").append(actid).append(", ").append(revisionNumberStr).append(", ").append(permission.isInheritable()).append(", ").append(permission.isNegative()).append(")");
                    statement.execute(theSQL.toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_14 = null;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    protected boolean isLinkExist(long parent, long child) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select 1 from LINKS where URI_ID = ");
        theSQL.append(parent).append(" and LINK_TO_ID = ").append(child);
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        return rslt.next();
    }

    protected boolean isLockExist(long parent) throws SQLException {
        Connection connection = this.getCurrentConnection();
        Statement getStatement = connection.createStatement();
        StringBuffer theSQL = new StringBuffer("select 1 from LOCKS where LOCK_ID = ");
        theSQL.append(parent);
        ResultSet rslt = getStatement.executeQuery(theSQL.toString());
        return rslt.next();
    }

    public void killLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        this.removeLock(uri, lock);
    }

    public void putLock(Uri uri, NodeLock lock) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("insert into LOCKS (LOCK_ID,OBJECT_ID,");
                theSQL.append("SUBJECT_ID,TYPE_ID,EXPIRATION_DATE,");
                theSQL.append("IS_INHERITABLE,IS_EXCLUSIVE) values( ");
                long in_lockid = this.getUriId(lock.getLockId());
                if (in_lockid == 0L) {
                    this.setUriId(lock.getLockId());
                    in_lockid = this.getUriId(lock.getLockId());
                }
                theSQL.append(in_lockid).append(", ");
                theSQL.append(this.getUriId(lock.getObjectUri())).append(", ");
                theSQL.append(this.getUriId(lock.getSubjectUri())).append(", ");
                theSQL.append(this.getUriId(lock.getTypeUri())).append(", ");
                theSQL.append(lock.getExpirationDate().getTime()).append(", ");
                theSQL.append(lock.isInheritable()).append(", ");
                theSQL.append(lock.isExclusive()).append(" ) ");
                statement.execute(theSQL.toString());
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void removeLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                boolean inheritable = false;
                if (lock.isInheritable()) {
                    inheritable = true;
                }
                StringBuffer theSQL = new StringBuffer("delete from LOCKS where LOCK_ID= '");
                long in_lock = this.getUriId(lock.getLockId());
                theSQL.append(in_lock).append("'");
                statement.execute(theSQL.toString());
                statement.execute("delete from URI where URI_ID = " + in_lock);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_11 = null;
        }
        catch (Throwable throwable) {
            Object var6_12 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void removeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        try {
            long uriid = this.getUriId(object.getUri());
            Statement statement = null;
            Connection connection = this.getCurrentConnection();
            statement = connection.createStatement();
            StringBuffer theSQL = new StringBuffer("delete from CHILDREN where URI_ID = ");
            theSQL.append(uriid).append(" OR CHILD_URI_ID = ").append(uriid);
            statement.execute(theSQL.toString());
            theSQL = new StringBuffer("delete from LINKS where URI_ID = ");
            theSQL.append(uriid);
            statement.execute(theSQL.toString());
            theSQL = new StringBuffer("delete from VERSION_HISTORY where URI_ID = ");
            theSQL.append(uriid);
            statement.execute(theSQL.toString());
            theSQL = new StringBuffer("delete from VERSION where URI_ID = ");
            theSQL.append(uriid);
            statement.execute(theSQL.toString());
            theSQL = new StringBuffer("delete from OBJECT where URI_ID = ");
            theSQL.append(uriid);
            statement.execute(theSQL.toString());
            theSQL = new StringBuffer("delete from URI where URI_ID = ");
            theSQL.append(uriid);
            statement.execute(theSQL.toString());
            this.removeUri(object.getUri());
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void removeRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                long uriid = this.getUriId(uri.toString());
                String revisionNumberStr = revisionNumber == null ? "NULL" : revisionNumber.toString();
                String branchStr = null;
                try {
                    branchStr = this.myRevisionDescriptor.getBranchName();
                }
                catch (NullPointerException nullPointerException) {
                    branchStr = "main";
                }
                long Version_ID = this.getVersionID(uriid, branchStr, revisionNumberStr);
                StringBuffer theSQL = new StringBuffer("delete from VERSION_LABELS where VERSION_ID= ");
                theSQL.append(Version_ID);
                statement.execute(theSQL.toString());
                theSQL = new StringBuffer("delete from PROPERTIES where VERSION_ID= ");
                theSQL.append(Version_ID);
                statement.execute(theSQL.toString());
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_13 = null;
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void removeRevisionDescriptors(Uri uri) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                long uriid = this.getUriId(uri.toString());
                ResultSet res = null;
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("SELECT VERSION_ID FROM VERSION_HISTORY");
                theSQL.append(" where URI_ID = ");
                theSQL.append(uriid);
                res = statement.executeQuery(theSQL.toString());
                Statement substatement = connection.createStatement();
                if (res.next()) {
                    theSQL = new StringBuffer("delete from VERSION_PREDS where VERSION_ID = ");
                    theSQL.append(res.getLong("VERSION_ID"));
                    substatement.execute(theSQL.toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_11 = null;
        }
        catch (Throwable throwable) {
            Object var5_12 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void renewLock(Uri uri, NodeLock lock) throws ServiceAccessException, LockTokenNotFoundException {
        try {
            if (!this.isLockExist(this.getUriId(lock.getLockId()))) {
                this.putLock(uri, lock);
            }
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public ObjectNode retrieveObject(Uri uri) throws ServiceAccessException, ObjectNotFoundException {
        ObjectNode result = null;
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            block15: {
                try {
                    long currentUriID = this.getUriId(uri.toString());
                    statement = connection.createStatement();
                    if (currentUriID == 0L) {
                        throw new ObjectNotFoundException(uri);
                    }
                    StringBuffer theSQL = new StringBuffer("select CLASS_NAME from OBJECT where URI_ID= ");
                    theSQL.append(currentUriID);
                    ResultSet res = statement.executeQuery(theSQL.toString());
                    if (!res.next()) {
                        throw new ObjectNotFoundException(uri);
                    }
                    String className = res.getString("CLASS_NAME");
                    theSQL = new StringBuffer("SELECT A.URI_STRING FROM URI A, CHILDREN B WHERE A.URI_ID = ");
                    theSQL.append("B.CHILD_URI_ID AND B.URI_ID = ");
                    theSQL.append(currentUriID);
                    res = statement.executeQuery(theSQL.toString());
                    Vector<String> childrenVector = new Vector<String>();
                    while (res.next()) {
                        String sts = res.getString("URI_STRING");
                        childrenVector.addElement(sts);
                    }
                    theSQL = new StringBuffer("select A.URI_STRING from URI A, LINKS B where A.URI_ID = ");
                    theSQL.append("B.URI_ID AND B.LINK_TO_ID= ");
                    theSQL.append(currentUriID);
                    res = statement.executeQuery(theSQL.toString());
                    Vector<String> linksVector = new Vector<String>();
                    while (res.next()) {
                        linksVector.addElement(res.getString("URI_STRING"));
                    }
                    if (className.equals("org.apache.slide.structure.LinkNode")) {
                        String linkTo = new String();
                        theSQL = new StringBuffer("select A.URI_STRING from URI A, LINKS B ");
                        theSQL.append(" where A.URI_ID = B.LINK_TO_ID AND B.URI_ID= ");
                        theSQL.append(currentUriID);
                        res = statement.executeQuery(theSQL.toString());
                        if (res.next()) {
                            linkTo = res.getString("URI_STRING");
                        }
                        result = new LinkNode(uri.toString(), childrenVector, linksVector, linkTo);
                        break block15;
                    }
                    try {
                        Class<?> objclass = Class.forName(className);
                        Class[] argClasses = new Class[]{Class.forName("java.lang.String"), Class.forName("java.util.Vector"), Class.forName("java.util.Vector")};
                        Object[] arguments = new Object[]{uri.toString(), childrenVector, linksVector};
                        Constructor<?> constructor = objclass.getConstructor(argClasses);
                        result = (ObjectNode)constructor.newInstance(arguments);
                    }
                    catch (Exception e) {
                        throw new ServiceAccessException((Service)this, (Throwable)e);
                    }
                }
                catch (SQLException e) {
                    this.getLogger().log(e, this.LOG_CHANNEL, 2);
                    throw new ServiceAccessException((Service)this, (Throwable)e);
                }
            }
            Object var6_20 = null;
        }
        catch (Throwable throwable) {
            Object var6_21 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        return result;
    }

    public NodeRevisionDescriptor retrieveRevisionDescriptor(Uri uri, NodeRevisionNumber revisionNumber) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptor revisionDescriptor = null;
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        if (revisionNumber == null) {
            throw new RevisionDescriptorNotFoundException(uri.toString());
        }
        try {
            try {
                ResultSet res = null;
                long uriid = this.getUriId(uri.toString());
                String branchName = null;
                Vector<String> labels = new Vector<String>();
                Hashtable<String, NodeProperty> properties = new Hashtable<String, NodeProperty>();
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select A.VERSION_ID, ");
                theSQL.append("B.BRANCH_STRING from VERSION_HISTORY A, BRANCH B");
                theSQL.append(" where A.URI_ID = ");
                theSQL.append(uriid).append(" and A.REVISION_NO = '");
                theSQL.append(revisionNumber.toString());
                theSQL.append("' and B.BRANCH_ID = A.BRANCH_ID");
                res = statement.executeQuery(theSQL.toString());
                long Version_ID = 0L;
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                branchName = res.getString("BRANCH_STRING");
                Version_ID = res.getLong("VERSION_ID");
                theSQL = new StringBuffer("select LABEL_ID from VERSION_LABELS where VERSION_ID = ");
                theSQL.append(Version_ID);
                res = statement.executeQuery(theSQL.toString());
                while (res.next()) {
                    labels.addElement(this.getLabelName(res.getLong("LABEL_ID")));
                }
                theSQL = new StringBuffer("select * from PROPERTIES where VERSION_ID = ");
                theSQL.append(Version_ID);
                res = statement.executeQuery(theSQL.toString());
                while (res.next()) {
                    String propertyName = res.getString("PROPERTY_NAME");
                    String propertyNamespace = res.getString("PROPERTY_NAMESPACE");
                    NodeProperty property = new NodeProperty(propertyName, res.getString("PROPERTY_VALUE"), propertyNamespace, res.getString("PROPERTY_TYPE"), res.getBoolean("IS_PROTECTED"));
                    properties.put(String.valueOf(propertyNamespace) + propertyName, property);
                }
                revisionDescriptor = new NodeRevisionDescriptor(revisionNumber, branchName, labels, properties);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var7_18 = null;
        }
        catch (Throwable throwable) {
            Object var7_19 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        return revisionDescriptor;
    }

    public NodeRevisionDescriptors retrieveRevisionDescriptors(Uri uri) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        NodeRevisionDescriptors revisionDescriptors = null;
        Statement statement = null;
        Statement statement2 = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                ResultSet res = null;
                NodeRevisionNumber initialRevision = new NodeRevisionNumber();
                Hashtable workingRevisions = new Hashtable();
                Hashtable<String, NodeRevisionNumber> latestRevisionNumbers = new Hashtable<String, NodeRevisionNumber>();
                Hashtable branches = new Hashtable();
                boolean isVersioned = false;
                long uriid = this.getUriId(uri.toString());
                statement = connection.createStatement();
                statement2 = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select IS_VERSIONED from VERSION");
                theSQL.append(" where URI_ID= ");
                theSQL.append(uriid);
                res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    throw new RevisionDescriptorNotFoundException(uri.toString());
                }
                isVersioned = res.getBoolean("IS_VERSIONED");
                theSQL = new StringBuffer("select VERSION_ID,REVISION_NO, ");
                theSQL.append("B.BRANCH_STRING  from VERSION_HISTORY A , ");
                theSQL.append("BRANCH B where A.URI_ID= ");
                theSQL.append(uriid).append(" and A.BRANCH_ID = B.BRANCH_ID");
                res = statement.executeQuery(theSQL.toString());
                while (res.next()) {
                    String branchid = res.getString("BRANCH_STRING");
                    long versionid = res.getLong("VERSION_ID");
                    String currentRevisionNumber = res.getString("REVISION_NO");
                    latestRevisionNumbers.put(branchid, new NodeRevisionNumber(currentRevisionNumber));
                    theSQL = new StringBuffer("select PREDECESSOR_ID from ");
                    theSQL.append("VERSION_PREDS where VERSION_ID  = ");
                    theSQL.append(versionid);
                    ResultSet res2 = statement2.executeQuery(theSQL.toString());
                    Vector<NodeRevisionNumber> childList = new Vector<NodeRevisionNumber>();
                    while (res2.next()) {
                        childList.addElement(new NodeRevisionNumber(this.getXNumber(res2.getLong("PREDECESSOR_ID"), uriid, branchid)));
                    }
                    branches.put(new NodeRevisionNumber(currentRevisionNumber), childList);
                    res2.close();
                }
                revisionDescriptors = new NodeRevisionDescriptors(uri.toString(), initialRevision, workingRevisions, latestRevisionNumbers, branches, isVersioned);
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var7_21 = null;
        }
        catch (Throwable throwable) {
            Object var7_22 = null;
            try {
                statement.close();
                statement2.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
            statement2.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
        return revisionDescriptors;
    }

    public void revokePermission(Uri uri, NodePermission permission) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                NodeRevisionNumber revisionNumber = permission.getRevisionNumber();
                StringBuffer theSQL = new StringBuffer("delete from PERMISSIONS ");
                theSQL.append("where OBJECT_ID= ");
                theSQL.append(this.getUriId(permission.getObjectUri())).append(" and SUBJECT_ID = ").append(this.getUriId(permission.getSubjectUri())).append(" and ACTION_ID = ").append(this.getUriId(permission.getActionUri()));
                if (revisionNumber != null) {
                    statement.execute(theSQL.append(" and VERSION_NO = ").append(revisionNumber.toString()).toString());
                } else {
                    statement.execute(theSQL.append(" and VERSION_NO = NULL").toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void revokePermissions(Uri uri) throws ServiceAccessException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("delete from PERMISSIONS");
                theSQL.append(" where OBJECT_ID= ");
                theSQL.append(this.getUriId(uri.toString()));
                statement.execute(theSQL.toString());
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var5_7 = null;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    protected void setBranchID(String branchName) throws SQLException {
        if (this.getBranchID(branchName) == 0L) {
            Connection connection = this.getCurrentConnection();
            Statement addStatement = connection.createStatement();
            StringBuffer theSQL = new StringBuffer("insert into BRANCH (BRANCH_STRING) values ('");
            theSQL.append(branchName).append("')");
            addStatement.execute(theSQL.toString());
            addStatement.close();
        }
    }

    protected void setLabelID(String labelName) throws SQLException {
        if (this.getBranchID(labelName) == 0L) {
            Connection connection = this.getCurrentConnection();
            Statement addStatement = connection.createStatement();
            StringBuffer theSQL = new StringBuffer("insert into LABEL (LABEL_STRING) values ('");
            theSQL.append(labelName).append("')");
            addStatement.execute(theSQL.toString());
            addStatement.close();
        }
    }

    public void storeObject(Uri uri, ObjectNode object) throws ServiceAccessException, ObjectNotFoundException {
        Statement statement = null;
        Connection connection = this.getCurrentConnection();
        try {
            try {
                long link_to;
                long uriid = this.getUriId(uri.toString());
                statement = connection.createStatement();
                StringBuffer theSQL = new StringBuffer("select 1 from OBJECT where URI_ID= ");
                theSQL.append(uriid);
                ResultSet res = statement.executeQuery(theSQL.toString());
                if (!res.next()) {
                    throw new ObjectNotFoundException(uri);
                }
                long parent = this.getUriId(object.getUri());
                Enumeration children = this.getNewChildren(parent, object.enumerateChildren());
                if (children != null) {
                    while (children.hasMoreElements()) {
                        theSQL = new StringBuffer("insert into CHILDREN ");
                        theSQL.append("(URI_ID,CHILD_URI_ID) values( ");
                        theSQL.append(parent).append(" , ").append(this.getUriId((String)children.nextElement())).append(")");
                        statement.execute(theSQL.toString());
                    }
                }
                if (object instanceof LinkNode && !this.isLinkExist(parent, link_to = this.getUriId(((LinkNode)object).getLinkedUri()))) {
                    theSQL = new StringBuffer("insert into LINKS (URI_ID,");
                    theSQL.append("LINK_TO_ID) values( ");
                    theSQL.append(parent).append(" , ").append(link_to).append(")");
                    statement.execute(theSQL.toString());
                }
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            Object var6_14 = null;
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            try {
                statement.close();
            }
            catch (SQLException e) {
                this.getLogger().log(e, this.LOG_CHANNEL, 2);
                throw new ServiceAccessException((Service)this, (Throwable)e);
            }
            throw throwable;
        }
        try {
            statement.close();
        }
        catch (SQLException e) {
            this.getLogger().log(e, this.LOG_CHANNEL, 2);
            throw new ServiceAccessException((Service)this, (Throwable)e);
        }
    }

    public void storeRevisionDescriptor(Uri uri, NodeRevisionDescriptor revisionDescriptor) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.myRevisionDescriptor = revisionDescriptor;
        this.removeRevisionDescriptor(uri, revisionDescriptor.getRevisionNumber());
        this.createRevisionDescriptor(uri, revisionDescriptor);
    }

    public void storeRevisionDescriptors(Uri uri, NodeRevisionDescriptors revisionDescriptors) throws ServiceAccessException, RevisionDescriptorNotFoundException {
        this.removeRevisionDescriptors(uri);
        this.createRevisionDescriptors(uri, revisionDescriptors);
    }
}

