/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic.expression;

import java.util.Collection;
import java.util.Iterator;
import org.apache.slide.search.InvalidQueryException;
import org.apache.slide.search.SearchException;
import org.apache.slide.search.basic.BasicExpressionFactory;
import org.apache.slide.search.basic.IBasicExpression;
import org.apache.slide.search.basic.IBasicResultSet;
import org.apache.slide.search.basic.expression.GenericBasicExpression;
import org.jdom.Element;

public abstract class MergeExpression
extends GenericBasicExpression {
    protected Collection expressionsToMerge = null;
    protected BasicExpressionFactory expressionFactory;

    MergeExpression(Element e, Collection expressionsToMerge) throws InvalidQueryException {
        super(e);
        this.expressionsToMerge = expressionsToMerge;
        if (expressionsToMerge.size() == 0) {
            throw new InvalidQueryException(MergeExpression.getMustHaveMergeExpressionsMessage(e.getName()));
        }
    }

    public IBasicResultSet execute() throws SearchException {
        Iterator iterator = this.expressionsToMerge.iterator();
        if (iterator.hasNext()) {
            this.resultSet = ((IBasicExpression)iterator.next()).execute();
        }
        while (iterator.hasNext()) {
            IBasicExpression expression = (IBasicExpression)iterator.next();
            this.merge(expression.execute());
        }
        return this.resultSet;
    }

    public Collection getExpressionsToMerge() {
        return this.expressionsToMerge;
    }

    public static String getMustHaveMergeExpressionsMessage(String operationName) {
        return "<" + operationName + "> must have at least on nested expression.";
    }

    protected abstract void merge(IBasicResultSet var1);

    protected String toString(String op) {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.expressionsToMerge.iterator();
        while (it.hasNext()) {
            sb.append(((IBasicExpression)it.next()).toString());
            if (!it.hasNext()) continue;
            sb.append(" ").append(op).append(" ");
        }
        return sb.toString();
    }
}

