/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.search.basic;

import java.io.Reader;
import java.io.StringReader;
import org.apache.slide.common.SlideRuntimeException;
import org.apache.slide.common.Uri;
import org.apache.slide.search.BadQueryException;
import org.apache.slide.search.PropertyProvider;
import org.apache.slide.search.QueryScope;
import org.apache.slide.search.SearchLanguage;
import org.apache.slide.search.SearchQuery;
import org.apache.slide.search.SearchToken;
import org.apache.slide.search.basic.BasicQueryImpl;
import org.apache.slide.store.AbstractStore;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class BasicSearchLanguage
extends SearchLanguage {
    static final String GRAMMAR_NAME = "basicsearch";
    static final String GRAMMAR_NAMESPACE = "DAV:";
    public static final String BASIC_QUERY_CLASS = "basicQueryClass";

    public String getGrammarUri() {
        return GRAMMAR_NAMESPACE;
    }

    public String getName() {
        return GRAMMAR_NAME;
    }

    public SearchQuery parseQuery(String queryString, SearchToken token, PropertyProvider propertyProvider) throws BadQueryException {
        try {
            Document doc = new SAXBuilder().build((Reader)new StringReader(queryString));
            Element root = doc.getRootElement();
            return this.parseQuery(root, token, propertyProvider);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BadQueryException(e.getMessage());
        }
    }

    public SearchQuery parseQuery(Element basicSearchElement, SearchToken token, PropertyProvider propertyProvider) throws BadQueryException {
        QueryScope scope = BasicQueryImpl.getScope(basicSearchElement);
        BasicQueryImpl query = null;
        Uri uri = new Uri(token.getNamespace(), token.getSlideContext().getSlidePath(scope.getHref()));
        AbstractStore store = (AbstractStore)uri.getStore();
        String className = (String)store.getParameter(BASIC_QUERY_CLASS);
        if (className != null) {
            try {
                Class<?> queryClass = Class.forName(className);
                query = (BasicQueryImpl)queryClass.newInstance();
                query.init(token);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SlideRuntimeException(e.getMessage());
            }
        } else {
            query = new BasicQueryImpl(token);
        }
        query.parseQueryElement(basicSearchElement, propertyProvider);
        return query;
    }
}

