/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.macro;

import java.util.Enumeration;
import java.util.Stack;
import org.apache.slide.common.Domain;
import org.apache.slide.common.Namespace;
import org.apache.slide.common.NamespaceConfig;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.content.Content;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.NodeRevisionNumber;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.lock.Lock;
import org.apache.slide.lock.NodeLock;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.macro.ConflictException;
import org.apache.slide.macro.CopyListener;
import org.apache.slide.macro.CopyMacroException;
import org.apache.slide.macro.CopyRouteRedirector;
import org.apache.slide.macro.DeleteListener;
import org.apache.slide.macro.DeleteMacroException;
import org.apache.slide.macro.DeleteTargetRedirector;
import org.apache.slide.macro.ForbiddenException;
import org.apache.slide.macro.Macro;
import org.apache.slide.macro.MacroException;
import org.apache.slide.macro.MacroParameters;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.security.Security;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectHasChildrenException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.Structure;

public final class MacroImpl
implements Macro {
    private Namespace namespace;
    private NamespaceConfig namespaceConfig;
    private Content contentHelper;
    private Structure structureHelper;
    private Security securityHelper;
    private Lock lockHelper;

    public MacroImpl(Namespace namespace, NamespaceConfig namespaceConfig, Security securityHelper, Content contentHelper, Structure structureHelper, Lock lockHelper) {
        this.namespace = namespace;
        this.namespaceConfig = namespaceConfig;
        this.securityHelper = securityHelper;
        this.contentHelper = contentHelper;
        this.structureHelper = structureHelper;
        this.lockHelper = lockHelper;
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, null, null, null, null);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, Macro.RECURSIVE_OVERWRITE_PARAMETERS, copyRedirector, copyListener, deleteRedirector, deleteListener);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, parameters, null, null, null, null);
    }

    public void copy(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        Domain.debug("Copy " + sourceUri + " to " + destinationUri);
        if (sourceUri.equals(destinationUri)) {
            CopyMacroException e = new CopyMacroException("Copy failed");
            e.addException(new ForbiddenException(sourceUri));
            throw e;
        }
        if (parameters.isOverwrite()) {
            try {
                this.structureHelper.retrieve(token, destinationUri);
                this.delete(token, destinationUri, deleteRedirector, deleteListener);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
            }
            catch (DeleteMacroException s) {
                throw s;
            }
            catch (SlideException s) {
                CopyMacroException e = new CopyMacroException("Copy failed");
                e.addException(s);
                throw e;
            }
        }
        CopyMacroException e = new CopyMacroException("Copy failed");
        this.copyObject(token, sourceUri, destinationUri, parameters, e, copyRedirector, copyListener);
        if (!e.isEmpty()) {
            throw e;
        }
    }

    private void copyObject(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyMacroException e, CopyRouteRedirector copyRedirector, CopyListener copyListener) {
        Domain.debug("Copy object : from " + sourceUri + " to " + destinationUri);
        try {
            ObjectNode object = this.structureHelper.retrieve(token, sourceUri, false);
            Enumeration childrenList = object.enumerateChildren();
            if (copyRedirector != null) {
                CopyRouteRedirector.CopyRoute copyRoute = new CopyRouteRedirector.CopyRoute(sourceUri, destinationUri);
                copyRoute = copyRedirector.getRedirectedCopyRoute(copyRoute);
                sourceUri = copyRoute.getSourceUri();
                destinationUri = copyRoute.getDestinationUri();
                object = this.structureHelper.retrieve(token, sourceUri, false);
            }
            if (copyListener != null) {
                copyListener.beforeCopy(sourceUri, destinationUri);
            }
            try {
                this.structureHelper.create(token, object.copyObject(), destinationUri);
            }
            catch (ObjectNotFoundException s) {
                throw new ConflictException(s.getObjectUri());
            }
            try {
                Enumeration permissions = this.securityHelper.enumeratePermissions(token, object);
                while (permissions.hasMoreElements()) {
                    NodePermission permission = (NodePermission)permissions.nextElement();
                    NodePermission newPermission = new NodePermission(destinationUri, permission.getSubjectUri(), permission.getActionUri(), permission.isInheritable());
                    this.securityHelper.grantPermission(token, newPermission);
                }
            }
            catch (AccessDeniedException accessDeniedException) {}
            NodeRevisionDescriptors revisionDescriptors = this.contentHelper.retrieve(token, object.getUri());
            if (revisionDescriptors.hasRevisions()) {
                NodeRevisionNumber currentRevisionNumber = revisionDescriptors.getInitialRevision();
                NodeRevisionDescriptor currentRevisionDescriptor = null;
                NodeRevisionContent currentRevisionContent = null;
                Stack<NodeRevisionNumber> revisionNumbers = new Stack<NodeRevisionNumber>();
                revisionNumbers.push(currentRevisionNumber);
                currentRevisionDescriptor = this.contentHelper.retrieve(token, revisionDescriptors, currentRevisionNumber);
                currentRevisionContent = currentRevisionDescriptor.getContentLength() > 0L ? this.contentHelper.retrieve(token, revisionDescriptors, currentRevisionDescriptor) : null;
                this.contentHelper.create(token, destinationUri, currentRevisionDescriptor, currentRevisionContent);
            }
            if (copyListener != null) {
                copyListener.afterCopy(sourceUri, destinationUri);
            }
            while (childrenList.hasMoreElements()) {
                String childUri = (String)childrenList.nextElement();
                String childDestinationUri = String.valueOf(destinationUri) + childUri.substring(object.getUri().length());
                this.copyObject(token, childUri, childDestinationUri, parameters, e, copyRedirector, copyListener);
            }
        }
        catch (SlideException ex) {
            e.addException(ex);
        }
    }

    public void delete(SlideToken token, String targetUri) throws DeleteMacroException {
        this.delete(token, targetUri, null, null);
    }

    public void delete(SlideToken token, String targetUri, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws DeleteMacroException {
        this.delete(token, targetUri, Macro.RECURSIVE_OVERWRITE_PARAMETERS, deleteRedirector, deleteListener);
    }

    public void delete(SlideToken token, String targetUri, MacroParameters parameters) throws DeleteMacroException {
        this.delete(token, targetUri, parameters, null, null);
    }

    public void delete(SlideToken token, String targetUri, MacroParameters parameters, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws DeleteMacroException {
        Domain.debug("Delete " + targetUri);
        DeleteMacroException e = new DeleteMacroException("Delete failed");
        this.deleteObject(token, targetUri, e, deleteRedirector, deleteListener);
        if (!e.isEmpty()) {
            throw e;
        }
    }

    private void deleteObject(SlideToken token, String targetUri, MacroException e, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) {
        Domain.debug("Delete object : " + targetUri);
        try {
            ObjectNode currentObject = this.structureHelper.retrieve(token, targetUri, false);
            if (currentObject.hasChildren()) {
                Enumeration children = currentObject.enumerateChildren();
                while (children.hasMoreElements()) {
                    this.deleteObject(token, (String)children.nextElement(), e, deleteRedirector, deleteListener);
                }
            }
            if (deleteRedirector != null) {
                targetUri = deleteRedirector.getRedirectedTargetUri(targetUri);
                currentObject = this.structureHelper.retrieve(token, targetUri, false);
            }
            if (deleteListener != null) {
                deleteListener.beforeDelete(targetUri);
            }
            NodeRevisionDescriptors revisionDescriptors = this.contentHelper.retrieve(token, currentObject.getUri());
            Enumeration locks = this.lockHelper.enumerateLocks(token, currentObject.getUri(), false);
            while (locks.hasMoreElements()) {
                this.lockHelper.unlock(token, (NodeLock)locks.nextElement());
            }
            Enumeration permissions = this.securityHelper.enumeratePermissions(token, currentObject);
            while (permissions.hasMoreElements()) {
                NodePermission permission = (NodePermission)permissions.nextElement();
                this.securityHelper.revokePermission(token, permission);
            }
            if (!revisionDescriptors.isRedirected()) {
                Enumeration revisionNumberEnum = revisionDescriptors.enumerateRevisionNumbers();
                if (revisionNumberEnum != null) {
                    while (revisionNumberEnum.hasMoreElements()) {
                        this.contentHelper.remove(token, currentObject.getUri(), (NodeRevisionNumber)revisionNumberEnum.nextElement());
                    }
                }
                this.removeHiddenRevisions(token, targetUri);
                this.contentHelper.remove(token, revisionDescriptors);
            }
            this.structureHelper.remove(token, currentObject);
            if (deleteListener != null) {
                deleteListener.afterDelete(targetUri);
            }
        }
        catch (ObjectHasChildrenException objectHasChildrenException) {
        }
        catch (SlideException ex) {
            e.addException(ex);
        }
    }

    public void move(SlideToken token, String sourceUri, String destinationUri) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, null, null, null, null);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, Macro.RECURSIVE_OVERWRITE_PARAMETERS, copyRedirector, copyListener, deleteRedirector, deleteListener);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters) throws CopyMacroException, DeleteMacroException {
        this.move(token, sourceUri, destinationUri, parameters, null, null, null, null);
    }

    public void move(SlideToken token, String sourceUri, String destinationUri, MacroParameters parameters, CopyRouteRedirector copyRedirector, CopyListener copyListener, DeleteTargetRedirector deleteRedirector, DeleteListener deleteListener) throws CopyMacroException, DeleteMacroException {
        this.copy(token, sourceUri, destinationUri, parameters, copyRedirector, copyListener, deleteRedirector, deleteListener);
        this.delete(token, sourceUri, parameters, deleteRedirector, deleteListener);
    }

    private void removeHiddenRevisions(SlideToken token, String targetUri) throws ServiceAccessException, ObjectNotFoundException, LinkedObjectNotFoundException, AccessDeniedException, ObjectLockedException {
        try {
            this.contentHelper.remove(token, targetUri, NodeRevisionNumber.HIDDEN_0_0);
        }
        catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {}
    }
}

