/*
 * Decompiled with CFR 0.152.
 */
package org.apache.slide.common;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.slide.common.NamespaceAccessToken;
import org.apache.slide.common.ServiceAccessException;
import org.apache.slide.common.SlideToken;
import org.apache.slide.common.UnknownObjectClassException;
import org.apache.slide.content.NodeProperty;
import org.apache.slide.content.NodeRevisionContent;
import org.apache.slide.content.NodeRevisionDescriptor;
import org.apache.slide.content.NodeRevisionDescriptors;
import org.apache.slide.content.RevisionAlreadyExistException;
import org.apache.slide.content.RevisionContentNotFoundException;
import org.apache.slide.content.RevisionDescriptorNotFoundException;
import org.apache.slide.content.RevisionNotFoundException;
import org.apache.slide.lock.ObjectLockedException;
import org.apache.slide.security.AccessDeniedException;
import org.apache.slide.security.NodePermission;
import org.apache.slide.structure.LinkNode;
import org.apache.slide.structure.LinkedObjectNotFoundException;
import org.apache.slide.structure.ObjectAlreadyExistsException;
import org.apache.slide.structure.ObjectNode;
import org.apache.slide.structure.ObjectNotFoundException;
import org.apache.slide.structure.SubjectNode;
import org.apache.slide.util.conf.Configuration;
import org.apache.slide.util.conf.ConfigurationElement;
import org.apache.slide.util.conf.ConfigurationException;
import org.apache.slide.util.conf.Populate;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLUnmarshaller {
    private static final String LOG_CHANNEL = (class$org$apache$slide$common$XMLUnmarshaller != null ? class$org$apache$slide$common$XMLUnmarshaller : (class$org$apache$slide$common$XMLUnmarshaller = XMLUnmarshaller.class$("org.apache.slide.common.XMLUnmarshaller"))).getName();
    static /* synthetic */ Class class$org$apache$slide$common$XMLUnmarshaller;

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    private static void loadDefaultObjectRevision(NamespaceAccessToken accessToken, SlideToken token, String uri) throws ServiceAccessException, ConfigurationException, AccessDeniedException, ObjectNotFoundException, LinkedObjectNotFoundException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(false);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            Populate pop = new Populate();
            ConfigurationElement slideConfiguration = new ConfigurationElement(pop.load(new InputSource(new StringReader("<revision/>")), parser.getXMLReader()));
            XMLUnmarshaller.loadObjectRevision(accessToken, token, uri, slideConfiguration);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    private static void loadObjectNode(NamespaceAccessToken accessToken, SlideToken token, Configuration objectDefinition) throws ServiceAccessException, ConfigurationException, UnknownObjectClassException {
        String className = objectDefinition.getAttribute("classname");
        String uri = objectDefinition.getAttribute("uri");
        accessToken.getLogger().log("Loading object " + uri, LOG_CHANNEL, 6);
        try {
            Class<?> objectClass = null;
            try {
                objectClass = Class.forName(className);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnknownObjectClassException(className);
            }
            ObjectNode object = null;
            try {
                object = (ObjectNode)objectClass.newInstance();
            }
            catch (InstantiationException instantiationException) {
                throw new UnknownObjectClassException(className);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new UnknownObjectClassException(className);
            }
            if (!uri.equals("/")) {
                try {
                    if (object instanceof LinkNode) {
                        String linkedUri = objectDefinition.getAttribute("linkedUri");
                        accessToken.getStructureHelper().createLink(token, (LinkNode)object, uri, new SubjectNode(linkedUri));
                    } else {
                        accessToken.getStructureHelper().create(token, object, uri);
                    }
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
                    accessToken.getLogger().log("Object already exists at " + uri, LOG_CHANNEL, 6);
                }
            }
            Enumeration permissionDefinitions = objectDefinition.getConfigurations("permission");
            while (permissionDefinitions.hasMoreElements()) {
                Configuration permissionDefinition = (Configuration)permissionDefinitions.nextElement();
                String subjectUri = permissionDefinition.getAttribute("subject");
                String actionUri = permissionDefinition.getAttribute("action");
                boolean inheritable = true;
                try {
                    if (permissionDefinition.getAttribute("inheritable").equals("false")) {
                        inheritable = false;
                    }
                }
                catch (ConfigurationException configurationException) {}
                boolean negative = false;
                try {
                    if (permissionDefinition.getAttribute("negative").equals("true")) {
                        negative = true;
                    }
                }
                catch (ConfigurationException configurationException) {}
                NodePermission permission = new NodePermission(uri, subjectUri, actionUri, inheritable, negative);
                accessToken.getSecurityHelper().grantPermission(token, permission);
            }
            Enumeration revisionDefinitions = objectDefinition.getConfigurations("revision");
            boolean revisionDefinitionsFound = false;
            while (revisionDefinitions.hasMoreElements()) {
                revisionDefinitionsFound = true;
                Configuration revisionDefinition = (Configuration)revisionDefinitions.nextElement();
                XMLUnmarshaller.loadObjectRevision(accessToken, token, uri, revisionDefinition);
            }
            if (!revisionDefinitionsFound) {
                XMLUnmarshaller.loadDefaultObjectRevision(accessToken, token, uri);
            }
        }
        catch (ObjectNotFoundException e) {
            accessToken.getLogger().log(e, LOG_CHANNEL, 4);
            accessToken.getLogger().log(e.toString(), LOG_CHANNEL, 4);
        }
        catch (LinkedObjectNotFoundException e) {
            accessToken.getLogger().log(e, LOG_CHANNEL, 4);
            accessToken.getLogger().log("Incorrect link found while creating " + uri, LOG_CHANNEL, 4);
        }
        catch (AccessDeniedException accessDeniedException) {
            accessToken.getLogger().log("Insufficient credentials to create object", LOG_CHANNEL, 6);
        }
        Enumeration childConfigurations = objectDefinition.getConfigurations("objectnode");
        while (childConfigurations.hasMoreElements()) {
            Configuration childConfiguration = (Configuration)childConfigurations.nextElement();
            XMLUnmarshaller.loadObjectNode(accessToken, token, childConfiguration);
        }
    }

    private static void loadObjectRevision(NamespaceAccessToken accessToken, SlideToken token, String uri, Configuration revisionDefinition) throws ServiceAccessException, ConfigurationException, AccessDeniedException, ObjectNotFoundException, LinkedObjectNotFoundException {
        Enumeration propertyDefinitions = revisionDefinition.getConfigurations("property");
        Object revisionNumber = null;
        NodeRevisionDescriptor revisionDescriptor = null;
        NodeRevisionDescriptors revisionDescriptors = null;
        try {
            revisionDescriptors = accessToken.getContentHelper().retrieve(token, uri);
        }
        catch (ObjectLockedException objectLockedException) {}
        if (revisionDescriptors != null && revisionDescriptors.hasRevisions()) {
            try {
                revisionDescriptor = accessToken.getContentHelper().retrieve(token, revisionDescriptors);
            }
            catch (RevisionDescriptorNotFoundException revisionDescriptorNotFoundException) {
            }
            catch (ObjectLockedException objectLockedException) {}
        }
        if (revisionDescriptor == null) {
            revisionDescriptor = new NodeRevisionDescriptor(0L);
        }
        while (propertyDefinitions.hasMoreElements()) {
            Configuration propertyDefinition = (Configuration)propertyDefinitions.nextElement();
            String propertyName = propertyDefinition.getAttribute("name");
            String propertyValue = propertyDefinition.getValue();
            String propertyNamespace = propertyDefinition.getAttribute("namespace", "DAV:");
            NodeProperty property = revisionDescriptor.getProperty(propertyName, propertyNamespace);
            if (property != null) continue;
            revisionDescriptor.setProperty(propertyName, propertyNamespace, propertyValue);
        }
        NodeRevisionContent revisionContent = null;
        if (revisionDescriptors != null && revisionDescriptors.hasRevisions()) {
            try {
                revisionContent = accessToken.getContentHelper().retrieve(token, uri, revisionDescriptor);
            }
            catch (RevisionContentNotFoundException revisionContentNotFoundException) {
            }
            catch (ObjectLockedException objectLockedException) {
            }
            catch (RevisionNotFoundException revisionNotFoundException) {}
            try {
                accessToken.getContentHelper().store(token, uri, revisionDescriptor, revisionContent);
            }
            catch (RevisionDescriptorNotFoundException e) {
                accessToken.getLogger().log(e, LOG_CHANNEL, 4);
                accessToken.getLogger().log(e.toString(), LOG_CHANNEL, 4);
            }
            catch (RevisionNotFoundException e) {
                accessToken.getLogger().log(e, LOG_CHANNEL, 4);
                accessToken.getLogger().log(e.toString(), LOG_CHANNEL, 4);
            }
            catch (ObjectLockedException objectLockedException) {}
        } else {
            try {
                accessToken.getContentHelper().create(token, uri, revisionDescriptor, revisionContent);
            }
            catch (ObjectLockedException e) {
                accessToken.getLogger().log(e, LOG_CHANNEL, 4);
                accessToken.getLogger().log(e.toString(), LOG_CHANNEL, 4);
            }
            catch (RevisionAlreadyExistException e) {
                accessToken.getLogger().log(e, LOG_CHANNEL, 4);
                accessToken.getLogger().log(e.toString(), LOG_CHANNEL, 4);
            }
        }
    }

    public static void unmarshal(NamespaceAccessToken accessToken, SlideToken token, Configuration dataConfiguration) throws ConfigurationException, UnknownObjectClassException, ServiceAccessException {
        XMLUnmarshaller.loadObjectNode(accessToken, token, dataConfiguration.getConfiguration("objectnode"));
    }
}

