/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.util;

import org.apache.turbine.util.RunData;

public class BrowserDetector {
    private String userAgentString = "";
    private String browserName = "";
    private float browserVersion = 1.0f;
    private String browserPlatform = "unknown";
    private boolean javascriptOK = false;
    private boolean cssOK = false;
    private boolean fileUploadOK = false;
    public static final String MSIE = "MSIE";
    public static final String OPERA = "Opera";
    public static final String MOZILLA = "Mozilla";
    public static final String WINDOWS = "Windows";
    public static final String UNIX = "Unix";
    public static final String MACINTOSH = "Macintosh";

    public BrowserDetector(String userAgentString) {
        this.userAgentString = userAgentString;
        this.parse();
    }

    public BrowserDetector(RunData data) {
        this.userAgentString = data.getRequest().getHeader("User-Agent");
        this.parse();
    }

    public boolean isCssOK() {
        return this.cssOK;
    }

    public boolean isFileUploadOK() {
        return this.fileUploadOK;
    }

    public boolean isJavascriptOK() {
        return this.javascriptOK;
    }

    public String getBrowserName() {
        return this.browserName;
    }

    public String getBrowserPlatform() {
        return this.browserPlatform;
    }

    public float getBrowserVersion() {
        return this.browserVersion;
    }

    public String getUserAgentString() {
        return this.userAgentString;
    }

    private void parse() {
        int versionStartIndex = this.userAgentString.indexOf("/");
        int versionEndIndex = this.userAgentString.indexOf(" ");
        this.browserName = this.userAgentString.substring(0, versionStartIndex);
        try {
            String agentSubstring = null;
            agentSubstring = versionEndIndex < 0 ? this.userAgentString.substring(versionStartIndex + 1) : this.userAgentString.substring(versionStartIndex + 1, versionEndIndex);
            this.browserVersion = this.toFloat(agentSubstring);
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        if (this.userAgentString.indexOf(MSIE) != -1) {
            versionStartIndex = this.userAgentString.indexOf(MSIE) + MSIE.length() + 1;
            versionEndIndex = this.userAgentString.indexOf(";", versionStartIndex);
            this.browserName = MSIE;
            try {
                this.browserVersion = this.toFloat(this.userAgentString.substring(versionStartIndex, versionEndIndex));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (this.userAgentString.indexOf(OPERA) != -1) {
            versionStartIndex = this.userAgentString.indexOf(OPERA) + OPERA.length() + 1;
            versionEndIndex = this.userAgentString.indexOf(" ", versionStartIndex);
            this.browserName = OPERA;
            try {
                this.browserVersion = this.toFloat(this.userAgentString.substring(versionStartIndex, versionEndIndex));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.userAgentString.indexOf(WINDOWS) != -1 || this.userAgentString.indexOf("WinNT") != -1 || this.userAgentString.indexOf("Win98") != -1 || this.userAgentString.indexOf("Win95") != -1) {
            this.browserPlatform = WINDOWS;
        }
        if (this.userAgentString.indexOf("Mac") != -1) {
            this.browserPlatform = MACINTOSH;
        }
        if (this.userAgentString.indexOf("X11") != -1) {
            this.browserPlatform = UNIX;
        }
        if (this.browserPlatform == WINDOWS) {
            if (this.browserName.equals(MOZILLA)) {
                if ((double)this.browserVersion >= 3.0) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if ((double)this.browserVersion >= 4.0) {
                    this.cssOK = true;
                }
            } else if (this.browserName == MSIE) {
                if ((double)this.browserVersion >= 4.0) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                    this.cssOK = true;
                }
            } else if (this.browserName == OPERA && (double)this.browserVersion >= 3.0) {
                this.javascriptOK = true;
                this.fileUploadOK = true;
                this.cssOK = true;
            }
        } else if (this.browserPlatform == MACINTOSH) {
            if (this.browserName.equals(MOZILLA)) {
                if ((double)this.browserVersion >= 3.0) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if ((double)this.browserVersion >= 4.0) {
                    this.cssOK = true;
                }
            } else if (this.browserName == MSIE) {
                if ((double)this.browserVersion >= 4.0) {
                    this.javascriptOK = true;
                    this.fileUploadOK = true;
                }
                if ((double)this.browserVersion > 4.0) {
                    this.cssOK = true;
                }
            }
        } else if (this.browserPlatform == UNIX && this.browserName.equals(MOZILLA)) {
            if ((double)this.browserVersion >= 3.0) {
                this.javascriptOK = true;
                this.fileUploadOK = true;
            }
            if ((double)this.browserVersion >= 4.0) {
                this.cssOK = true;
            }
        }
    }

    private float toFloat(String s) {
        return Float.valueOf(s).floatValue();
    }
}

