/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.logging;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import org.apache.turbine.services.logging.RunDataFilter;
import org.apache.turbine.util.RunData;

public class BaseRunDataFilter
implements RunDataFilter {
    protected static Map methodNamesMap = null;
    protected String format = null;
    protected List pattern = null;
    protected final String DELIM = " ";
    static /* synthetic */ Class class$org$apache$turbine$util$RunData;
    static /* synthetic */ Class class$java$lang$String;

    public void setFormat(String format) {
        if (format != null && !format.trim().equals("")) {
            this.pattern = new ArrayList();
            StringTokenizer st = new StringTokenizer(format);
            while (st.hasMoreTokens()) {
                this.pattern.add(st.nextToken());
            }
            this.format = format;
        }
    }

    public String getString(RunData data) {
        Method method = null;
        StringBuffer answer = new StringBuffer();
        if (this.format == null) {
            return "";
        }
        int i = 0;
        while (i < this.pattern.size()) {
            try {
                String methodName = (String)methodNamesMap.get(this.pattern.get(i));
                if (methodName != null) {
                    method = this.getClass().getDeclaredMethod(methodName, class$org$apache$turbine$util$RunData == null ? BaseRunDataFilter.class$("org.apache.turbine.util.RunData") : class$org$apache$turbine$util$RunData);
                    answer.append((String)method.invoke(null, data));
                    answer.append(" ");
                } else if (((String)this.pattern.get(i)).endsWith("i")) {
                    method = this.getClass().getDeclaredMethod("getHeader", class$org$apache$turbine$util$RunData == null ? BaseRunDataFilter.class$("org.apache.turbine.util.RunData") : class$org$apache$turbine$util$RunData, class$java$lang$String == null ? BaseRunDataFilter.class$("java.lang.String") : class$java$lang$String);
                    answer.append((String)method.invoke(null, data, (String)this.pattern.get(i)));
                    answer.append(" ");
                } else {
                    answer.append((String)this.pattern.get(i));
                    answer.append(" ");
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            ++i;
        }
        return answer.toString();
    }

    private static String getTime(RunData data) {
        long time = System.currentTimeMillis();
        Date d = new Date(time);
        return d.toString();
    }

    private static String getURLRequested(RunData data) {
        return HttpUtils.getRequestURL((HttpServletRequest)data.getRequest()).toString();
    }

    private static String getRemoteHost(RunData data) {
        return data.getRemoteHost();
    }

    private static String getRemoteAddr(RunData data) {
        return data.getRemoteAddr();
    }

    private static String getRemoteUser(RunData data) {
        return data.getRequest().getRemoteUser();
    }

    private static String getServerPort(RunData data) {
        return String.valueOf(data.getServerPort());
    }

    private static String getServerName(RunData data) {
        return data.getServerName();
    }

    private static String getMethod(RunData data) {
        return data.getRequest().getMethod();
    }

    private static String getHeader(RunData data, String symbol) {
        Enumeration names = data.getRequest().getHeaderNames();
        StringTokenizer st = new StringTokenizer(symbol, "%{}");
        return data.getRequest().getHeader(st.nextToken());
    }

    private static String getQueryString(RunData data) {
        return data.getRequest().getQueryString();
    }

    private static String getContextPath(RunData data) {
        return data.getRequest().getContextPath();
    }

    private static String getSessionId(RunData data) {
        return data.getRequest().getSession().getId();
    }

    private static String getAuthType(RunData data) {
        return data.getRequest().getAuthType();
    }

    private static String getContentType(RunData data) {
        return data.getRequest().getContentType();
    }

    private static String getCharacterEncoding(RunData data) {
        return data.getRequest().getCharacterEncoding();
    }

    private static String getProtocol(RunData data) {
        return data.getRequest().getProtocol();
    }

    private static String getScheme(RunData data) {
        return data.getRequest().getScheme();
    }

    private static String getContentLength(RunData data) {
        return String.valueOf(data.getRequest().getContentLength());
    }

    private static String getUserAgent(RunData data) {
        return data.getUserAgent();
    }

    private static String getBannerInfo(RunData data) {
        return (String)data.getUser().getTemp("bannerInfo", "");
    }

    private static String getUser(RunData data) {
        return data.getUser().getFirstName() + " " + data.getUser().getLastName();
    }

    private static String getCookies(RunData data) {
        Cookie[] cookies = data.getRequest().getCookies();
        StringBuffer answer = new StringBuffer();
        answer.append("Cookies: [ ");
        int i = 0;
        while (i < cookies.length) {
            answer.append(cookies[i].getName());
            answer.append(" = ");
            answer.append(cookies[i].getValue());
            answer.append(";\t");
            ++i;
        }
        answer.append("]");
        return answer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        if (methodNamesMap == null) {
            methodNamesMap = new HashMap();
            methodNamesMap.put("%t", "getTime");
            methodNamesMap.put("%U", "getURLRequested");
            methodNamesMap.put("%h", "getRemoteHost");
            methodNamesMap.put("%a", "getRemoteAddr");
            methodNamesMap.put("%l", "getRemoteUser");
            methodNamesMap.put("%p", "getServerPort");
            methodNamesMap.put("%v", "getServerName");
            methodNamesMap.put("%m", "getMethod");
            methodNamesMap.put("%q", "getQueryString");
            methodNamesMap.put("%cp", "getContextPath");
            methodNamesMap.put("%sid", "getSessionId");
            methodNamesMap.put("%au", "getAuthType");
            methodNamesMap.put("%ct", "getContentType");
            methodNamesMap.put("%enc", "getCharacterEncoding");
            methodNamesMap.put("%pro", "getProtocol");
            methodNamesMap.put("%sce", "getScheme");
            methodNamesMap.put("%cln", "getContentLength");
            methodNamesMap.put("%ua", "getUserAgent");
            methodNamesMap.put("%ban", "getBannerInfo");
            methodNamesMap.put("%usr", "getUser");
            methodNamesMap.put("%cook", "getCookies");
        }
    }
}

