/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.localization;

import java.util.Locale;
import java.util.StringTokenizer;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.RunData;

public class LocaleDetector {
    public static Locale getLocale(RunData data) {
        String header = data.getRequest().getHeader("Accept-Language");
        if (header == null || header.length() == 0) {
            return null;
        }
        return LocaleDetector.getLocale(header);
    }

    public static Locale getLocale(String languageHeader) {
        Object locale = null;
        if (languageHeader == null || languageHeader.trim().equals("")) {
            return new Locale(TurbineResources.getString("locale.default.language", "en"), TurbineResources.getString("locale.default.country", "US"));
        }
        StringTokenizer tokenizer = new StringTokenizer(languageHeader, ",");
        String language = tokenizer.nextToken();
        return LocaleDetector.getLocaleForLanguage(language.trim());
    }

    private static Locale getLocaleForLanguage(String language) {
        int dash;
        int semi = language.indexOf(59);
        if (semi != -1) {
            language = language.substring(0, semi);
        }
        Locale locale = (dash = (language = language.trim()).indexOf(45)) == -1 ? new Locale(language, "") : new Locale(language.substring(0, dash), language.substring(dash + 1));
        return locale;
    }
}

