/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.jsp.util;

import java.io.IOException;
import org.apache.turbine.modules.NavigationLoader;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.template.TemplateService;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;

public class JspNavigation {
    private RunData data;

    public JspNavigation(RunData data) {
        this.data = data;
    }

    public void setTemplate(String template) {
        this.data.getTemplateInfo().setNavigationTemplate(template);
        String module = null;
        try {
            module = ((TemplateService)TurbineServices.getInstance().getService("TemplateService")).getNavigationName(template);
            NavigationLoader.getInstance().exec(this.data, module);
        }
        catch (Exception e) {
            String message = "Error processing navigation template:" + template + " using module: " + module;
            Log.error(message, e);
            try {
                this.data.getOut().print("Error processing navigation template: " + template + " using module: " + module);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
    }
}

