/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import org.apache.torque.om.NumberKey;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.Group;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.ParameterParser;

public class NumberKeyField
extends Field {
    public NumberKeyField(XmlField field, Group group) throws Exception {
        super(field, group);
    }

    protected void setDefaultValue(String prop) {
        if (prop == null) {
            return;
        }
        try {
            this.defaultValue = new NumberKey(prop);
        }
        catch (RuntimeException e) {
            Log.error("Could not convert " + prop + " into a NumberKey. (" + this.name + ")");
        }
    }

    protected String getDefaultValidator() {
        return "org.apache.turbine.services.intake.validator.NumberKeyValidator";
    }

    protected void doSetValue(ParameterParser pp) {
        if (this.isMultiValued) {
            String[] ss = pp.getStrings(this.getKey());
            NumberKey[] ival = new NumberKey[ss.length];
            int i = 0;
            while (i < ss.length) {
                ival[i] = new NumberKey(ss[i]);
                ++i;
            }
            this.setTestValue(ival);
        } else {
            this.setTestValue(new NumberKey(pp.getString(this.getKey())));
        }
    }
}

