/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.intake.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.turbine.om.Retrievable;
import org.apache.turbine.services.intake.TurbineIntake;
import org.apache.turbine.services.intake.model.Field;
import org.apache.turbine.services.intake.model.FieldFactory;
import org.apache.turbine.services.intake.xmlmodel.XmlField;
import org.apache.turbine.services.intake.xmlmodel.XmlGroup;
import org.apache.turbine.util.ParameterParser;
import org.apache.turbine.util.RunData;
import org.apache.turbine.util.TurbineException;
import org.apache.turbine.util.pool.Recyclable;

public class Group
implements Recyclable {
    public static final String EMPTY = "";
    public static final String NEW = "_0";
    protected final String gid;
    protected final String name;
    private final int poolCapacity;
    protected Map fields;
    protected Map mapToObjectFields;
    protected Field[] fieldsArray;
    protected String oid;
    protected RunData data;
    protected boolean isDeclared;
    private boolean disposed;

    public Group(XmlGroup group) throws Exception {
        ArrayList<Field> tmpFields;
        this.gid = group.getKey();
        this.name = group.getName();
        this.poolCapacity = Integer.parseInt(group.getPoolCapacity());
        List inputFields = group.getFields();
        int size = inputFields.size();
        this.fields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.mapToObjectFields = new HashMap((int)(1.25 * (double)size + 1.0));
        this.fieldsArray = new Field[size];
        int i = size - 1;
        while (i >= 0) {
            Field field;
            XmlField f = (XmlField)inputFields.get(i);
            this.fieldsArray[i] = field = FieldFactory.getInstance(f, this);
            this.fields.put(f.getName(), field);
            tmpFields = (List)this.mapToObjectFields.get(f.getMapToObject());
            if (tmpFields == null) {
                tmpFields = new ArrayList<Field>(size);
                this.mapToObjectFields.put(f.getMapToObject(), tmpFields);
            }
            tmpFields.add(field);
            --i;
        }
        Iterator keys = this.mapToObjectFields.keySet().iterator();
        while (keys.hasNext()) {
            Object key = keys.next();
            tmpFields = (ArrayList<Field>)this.mapToObjectFields.get(key);
            this.mapToObjectFields.put(key, tmpFields.toArray(new Field[tmpFields.size()]));
        }
    }

    public Group init(RunData data) throws TurbineException {
        return this.init(NEW, data);
    }

    public Group init(String key, RunData data) throws TurbineException {
        this.oid = key;
        this.data = data;
        int i = this.fieldsArray.length - 1;
        while (i >= 0) {
            this.fieldsArray[i].init(data);
            --i;
        }
        return this;
    }

    public Group init(Retrievable obj) {
        this.oid = obj.getQueryKey();
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].init(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
        return this;
    }

    public String[] getFieldNames() {
        String[] nameList = new String[this.fieldsArray.length];
        int i = 0;
        while (i < nameList.length) {
            nameList[i] = this.fieldsArray[i].name;
            ++i;
        }
        return nameList;
    }

    public String getIntakeGroupName() {
        return this.name;
    }

    public int getPoolCapacity() {
        return this.poolCapacity;
    }

    public String getGID() {
        return this.gid;
    }

    public String getOID() {
        return this.oid;
    }

    public String getObjectKey() {
        return this.gid + this.oid;
    }

    public ArrayList getObjects(RunData data) throws TurbineException {
        ArrayList<Group> objs = null;
        String[] oids = data.getParameters().getStrings(this.gid);
        if (oids != null) {
            objs = new ArrayList<Group>(oids.length);
            int i = oids.length - 1;
            while (i >= 0) {
                objs.add(TurbineIntake.getGroup(this.name).init(oids[i], data));
                --i;
            }
        }
        return objs;
    }

    public Field get(String fieldName) throws TurbineException {
        if (this.fields.containsKey(fieldName)) {
            return (Field)this.fields.get(fieldName);
        }
        throw new TurbineException("Intake Field name: " + fieldName + " not found!");
    }

    public boolean isAllValid() {
        boolean valid = true;
        int i = this.fieldsArray.length - 1;
        while (i >= 0) {
            valid &= this.fieldsArray[i].isValid();
            --i;
        }
        return valid;
    }

    public void setProperties(Object obj) throws TurbineException {
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].setProperty(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    public void getProperties(Object obj) throws Exception {
        Class<?> cls = obj.getClass();
        while (cls != null) {
            Field[] flds = (Field[])this.mapToObjectFields.get(cls.getName());
            if (flds != null) {
                int i = flds.length - 1;
                while (i >= 0) {
                    flds[i].getProperty(obj);
                    --i;
                }
            }
            cls = cls.getSuperclass();
        }
    }

    public void removeFromRequest() {
        ParameterParser pp = this.data.getParameters();
        String[] groups = pp.getStrings(this.gid);
        if (groups != null) {
            pp.remove(this.gid);
            int i = 0;
            while (i < groups.length) {
                if (groups[i] != null && !groups[i].equals(this.oid)) {
                    pp.add(this.gid, groups[i]);
                }
                ++i;
            }
            int i2 = this.fieldsArray.length - 1;
            while (i2 >= 0) {
                this.fieldsArray[i2].removeFromRequest();
                --i2;
            }
        }
    }

    public void resetDeclared() {
        this.isDeclared = false;
    }

    public String getHtmlFormInput() {
        StringBuffer sb = new StringBuffer(64);
        this.appendHtmlFormInput(sb);
        return sb.toString();
    }

    public void appendHtmlFormInput(StringBuffer sb) {
        if (!this.isDeclared) {
            this.isDeclared = true;
            sb.append("<input type=\"hidden\" name=\"").append(this.gid).append("\" value=\"").append(this.oid).append("\"></input>");
        }
    }

    public void recycle() {
        this.disposed = false;
    }

    public void dispose() {
        this.oid = null;
        this.data = null;
        int i = this.fieldsArray.length - 1;
        while (i >= 0) {
            this.fieldsArray[i].dispose();
            --i;
        }
        this.isDeclared = false;
        this.disposed = true;
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

