/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services.component;

import java.util.Iterator;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.stratum.component.ComponentLoader;
import org.apache.stratum.lifecycle.Disposable;
import org.apache.turbine.Turbine;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.TurbineBaseService;
import org.apache.turbine.services.component.ComponentService;
import org.apache.turbine.util.Log;

public class TurbineComponentService
extends TurbineBaseService
implements ComponentService {
    private static String CONFIG = "config";
    private static String NAME = "name";
    private static String COMPONENT = "component";
    private Object[] components = null;

    public void init() throws InitializationException {
        ServletConfig conf = Turbine.getTurbineServletConfig();
        this.init(conf);
    }

    public void init(ServletConfig config) throws InitializationException {
        BaseConfiguration loaderConf = new BaseConfiguration();
        String[] names = this.getConfiguration().getStringArray(NAME);
        int i = 0;
        while (i < names.length) {
            String key = names[i];
            loaderConf.addProperty(COMPONENT + "." + NAME, (Object)key);
            String subProperty = COMPONENT + "." + key;
            Configuration subConf = this.getConfiguration().subset(key);
            Iterator it = subConf.getKeys();
            while (it.hasNext()) {
                String subKey = (String)it.next();
                Object subVal = subConf.getProperty(subKey);
                if (subKey.equals(CONFIG)) {
                    Log.debug("Fixing up " + subVal);
                    subVal = config.getServletContext().getRealPath((String)subVal);
                    Log.debug("Now: " + subVal);
                }
                loaderConf.addProperty(subProperty + "." + subKey, subVal);
            }
            Log.info("Added " + key + " as a component");
            ++i;
        }
        try {
            ComponentLoader cl = new ComponentLoader((Configuration)loaderConf);
            this.components = cl.load();
            this.setInit(true);
        }
        catch (Exception e) {
            Log.error("Component Service failed: ", e);
            throw new InitializationException("ComponentService failed: ", e);
        }
    }

    public void shutdown() {
        if (this.components != null) {
            int i = 0;
            while (i < this.components.length) {
                if (this.components[i] instanceof Disposable) {
                    Log.debug("Disposing a " + this.components[i].getClass().getName() + " object");
                    ((Disposable)this.components[i]).dispose();
                } else {
                    Log.debug("Not disposing " + this.components[i].getClass().getName() + ", not a Disposable Object");
                }
                ++i;
            }
        }
        this.setInit(false);
    }
}

