/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.services;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.ServletConfig;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.apache.turbine.services.BaseServiceBroker;
import org.apache.turbine.services.InitializationException;
import org.apache.turbine.services.InstantiationException;
import org.apache.turbine.services.ServiceBroker;
import org.apache.turbine.services.logging.LoggingService;
import org.apache.turbine.services.resources.ResourceService;
import org.apache.turbine.services.resources.TurbineResources;

public class TurbineServices
extends BaseServiceBroker {
    public static final String RESOURCES_CLASS_KEY = "resources";
    public static final String RESOURCES_CLASS_DEFAULT = "org.apache.turbine.services.resources.TurbineResourceService";
    public static final String LOGGING_CLASS_KEY = "logging";
    public static final String LOGGING_CLASS_DEFAULT = "org.apache.turbine.services.logging.TurbineLoggingService";
    public static final String COMPONENT_CLASS_KEY = "component";
    public static final String COMPONENT_CLASS_DEFAULT = "org.apache.turbine.services.component.TurbineComponentService";
    public static final String PROPERTIES_PATH_KEY = "properties";
    public static final String PROPERTIES_PATH_DEFAULT = "/WEB-INF/conf/TurbineResources.properties";
    public static final String SERVICE_PREFIX = "services.";
    public static final String CLASSNAME_SUFFIX = ".classname";
    protected static ServiceBroker instance = new TurbineServices();
    private boolean enabledLogging = false;
    private Vector logCache = new Vector(5);
    private LoggingService logger;

    protected TurbineServices() {
    }

    public static ServiceBroker getInstance() {
        return instance;
    }

    public void initPrimaryServices(ServletConfig config) throws InstantiationException, InitializationException {
        String resourcesClass = config.getInitParameter(RESOURCES_CLASS_KEY);
        try {
            if (resourcesClass == null) {
                resourcesClass = RESOURCES_CLASS_DEFAULT;
            }
            this.mapping.setProperty("ResourceService", (Object)resourcesClass);
            this.initService("ResourceService", config);
            String loggingClass = config.getInitParameter(LOGGING_CLASS_KEY);
            if (loggingClass == null) {
                loggingClass = LOGGING_CLASS_DEFAULT;
            }
            this.mapping.setProperty("LoggingService", (Object)loggingClass);
            try {
                this.initService("LoggingService", config);
                this.logger = this.getLogger();
            }
            catch (InitializationException e) {
                this.mapping.clearProperty("LoggingService");
                throw e;
            }
            catch (InstantiationException e) {
                this.mapping.clearProperty("LoggingService");
                throw e;
            }
            String componentClass = config.getInitParameter(COMPONENT_CLASS_KEY);
            if (componentClass == null) {
                componentClass = COMPONENT_CLASS_DEFAULT;
            }
            this.mapping.setProperty("ComponentService", (Object)componentClass);
            Object var7_7 = null;
            this.enableLogging();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.enableLogging();
            throw throwable;
        }
        this.initMapping();
    }

    public void initMapping(Configuration mapping) {
        this.mapping = mapping;
    }

    protected void initMapping() {
        Iterator keys = TurbineResources.getKeys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            String[] keyParts = StringUtils.split((String)key, (String)".");
            if (keyParts.length != 3 || !(keyParts[0] + ".").equals(SERVICE_PREFIX) || !("." + keyParts[2]).equals(CLASSNAME_SUFFIX)) continue;
            String serviceKey = keyParts[1];
            this.notice("Added Mapping for Service: " + serviceKey);
            if (this.mapping.containsKey(serviceKey)) continue;
            this.mapping.setProperty(serviceKey, (Object)TurbineResources.getString(key));
        }
    }

    public Properties getProperties(String name) {
        Properties properties = new Properties();
        String servicePrefix = SERVICE_PREFIX + name + '.';
        Iterator keys = TurbineResources.getKeys(servicePrefix);
        while (keys.hasNext()) {
            String value;
            String key = (String)keys.next();
            try {
                value = TurbineResources.getString(key);
            }
            catch (ClassCastException propIsArray) {
                String[] values = TurbineResources.getStringArray(key);
                value = values[values.length - 1];
            }
            properties.setProperty(key.substring(servicePrefix.length()), value);
        }
        return properties;
    }

    public Configuration getConfiguration(String name) {
        return TurbineResources.getConfiguration(SERVICE_PREFIX + name);
    }

    public ResourceService getResources(String name) {
        return TurbineResources.getResources(SERVICE_PREFIX + name);
    }

    public void notice(String msg) {
        if (this.enabledLogging) {
            if (this.logger == null) {
                System.out.println("(!) NOTICE: " + msg);
            } else {
                this.logger.info(msg);
            }
        } else {
            this.logCache.add(msg);
        }
    }

    public void error(Throwable t) {
        if (this.enabledLogging) {
            if (this.logger == null) {
                System.out.println("(!) ERROR: " + t.getMessage());
            } else {
                this.logger.error("", t);
            }
        } else {
            this.logCache.add("ERROR: " + t.getMessage());
            StringWriter sw = new StringWriter();
            t.printStackTrace(new PrintWriter(sw));
            this.logCache.add(sw.toString());
        }
    }

    private void enableLogging() {
        this.enabledLogging = true;
        int i = 0;
        while (i < this.logCache.size()) {
            String s = (String)this.logCache.elementAt(i);
            this.notice(s);
            ++i;
        }
        this.logCache = null;
        this.notice("ServiceBroker: LoggingService enabled.");
    }

    private final LoggingService getLogger() {
        return (LoggingService)this.getService("LoggingService");
    }
}

