/*
 * Decompiled with CFR 0.152.
 */
package org.apache.turbine.modules;

import java.util.Vector;
import org.apache.turbine.modules.GenericLoader;
import org.apache.turbine.modules.Page;
import org.apache.turbine.services.TurbineServices;
import org.apache.turbine.services.assemblerbroker.AssemblerBrokerService;
import org.apache.turbine.services.resources.TurbineResources;
import org.apache.turbine.util.ObjectUtils;
import org.apache.turbine.util.RunData;

public class PageLoader
extends GenericLoader {
    private static PageLoader instance = new PageLoader(TurbineResources.getInt("page.cache.size", 5));

    private PageLoader() {
    }

    private PageLoader(int i) {
        super(i);
    }

    private void addInstance(String name, Page page) {
        if (this.cache()) {
            this.put(name, page);
        }
    }

    public void exec(RunData data, String name) throws Exception {
        this.getInstance(name).build(data);
    }

    public Page getInstance(String name) throws Exception {
        Page page = null;
        if (this.cache() && this.containsKey(name)) {
            page = (Page)this.get(name);
        } else {
            AssemblerBrokerService ab = (AssemblerBrokerService)TurbineServices.getInstance().getService("AssemblerBrokerService");
            try {
                page = (Page)ab.getAssembler("page", name);
            }
            catch (ClassCastException cce) {
                page = null;
            }
            if (page == null) {
                Vector packages = TurbineResources.getVector("module.packages");
                ObjectUtils.addOnce(packages, GenericLoader.getBasePackage());
                throw new ClassNotFoundException("\n\n\tRequested Page not found: " + name + "\n" + "\tTurbine looked in the following modules.packages " + "path: \n\t" + packages.toString() + "\n");
            }
            if (this.cache()) {
                this.addInstance(name, page);
            }
        }
        return page;
    }

    public static PageLoader getInstance() {
        return instance;
    }
}

