/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.jdbc2pool;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.commons.dbcp.jdbc2pool.UserPassKey;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;

class KeyedCPDSConnectionFactory
implements KeyedPoolableObjectFactory,
ConnectionEventListener {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    protected ConnectionPoolDataSource _cpds = null;
    protected String _validationQuery = null;
    protected KeyedObjectPool _pool = null;
    private Map validatingMap = new HashMap();
    private WeakHashMap pcKeyMap = new WeakHashMap();

    public KeyedCPDSConnectionFactory(ConnectionPoolDataSource cpds, KeyedObjectPool pool, String validationQuery) {
        this._cpds = cpds;
        this._pool = pool;
        this._pool.setFactory((KeyedPoolableObjectFactory)this);
        this._validationQuery = validationQuery;
    }

    public void activateObject(Object key, Object obj) {
    }

    public void connectionClosed(ConnectionEvent event) {
        block3: {
            PooledConnection pc = (PooledConnection)event.getSource();
            if (this.validatingMap.containsKey(pc)) break block3;
            Object key = this.pcKeyMap.get(pc);
            if (key == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this._pool.returnObject(key, (Object)pc);
            }
            catch (Exception exception) {
                this.destroyObject(key, pc);
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
            }
        }
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        PooledConnection pc = (PooledConnection)event.getSource();
        try {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR");
            pc.removeConnectionEventListener(this);
        }
        catch (Exception exception) {}
        Object key = this.pcKeyMap.get(pc);
        if (key == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        this.destroyObject(key, pc);
    }

    public void destroyObject(Object key, Object obj) {
        if (obj instanceof PooledConnection) {
            try {
                ((PooledConnection)obj).close();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (SQLException sQLException) {
            }
        }
    }

    public KeyedObjectPool getPool() {
        return this._pool;
    }

    public synchronized Object makeObject(Object key) {
        UserPassKey upkey = (UserPassKey)key;
        upkey.setReusable(false);
        String username = upkey.getUsername();
        PooledConnection pc = null;
        try {
            pc = username == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(username, upkey.getPassword());
            pc.addConnectionEventListener(this);
            this.pcKeyMap.put(pc, key);
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
        return pc;
    }

    public void passivateObject(Object key, Object obj) {
    }

    public synchronized void setCPDS(ConnectionPoolDataSource cpds) {
        this._cpds = cpds;
    }

    public synchronized void setPool(KeyedObjectPool pool) throws SQLException {
        if (this._pool != null && pool != this._pool) {
            try {
                this._pool.close();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new SQLException(e.getMessage());
            }
        }
        this._pool = pool;
    }

    public synchronized void setValidationQuery(String validationQuery) {
        this._validationQuery = validationQuery;
    }

    public boolean validateObject(Object key, Object obj) {
        boolean valid;
        block18: {
            block16: {
                block17: {
                    valid = false;
                    if (!(obj instanceof PooledConnection)) break block16;
                    PooledConnection pconn = (PooledConnection)obj;
                    String query = this._validationQuery;
                    if (query == null) break block17;
                    Connection conn = null;
                    Statement stmt = null;
                    ResultSet rset = null;
                    this.validatingMap.put(pconn, null);
                    try {
                        try {
                            conn = pconn.getConnection();
                            stmt = conn.createStatement();
                            rset = stmt.executeQuery(query);
                            valid = rset.next();
                        }
                        catch (Exception exception) {
                            valid = false;
                        }
                        Object var10_9 = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_10 = null;
                        try {
                            rset.close();
                        }
                        catch (Throwable throwable2) {}
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable3) {}
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable4) {}
                        this.validatingMap.remove(pconn);
                        throw throwable;
                    }
                    try {
                        rset.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        stmt.close();
                    }
                    catch (Throwable throwable) {}
                    try {
                        conn.close();
                    }
                    catch (Throwable throwable) {}
                    this.validatingMap.remove(pconn);
                    break block18;
                }
                valid = true;
                break block18;
            }
            valid = false;
        }
        return valid;
    }
}

