/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.engine.memory.lru;

import java.io.Serializable;
import junit.extensions.ActiveTestSuite;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.apache.jcs.engine.CacheElement;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;
import org.apache.jcs.engine.memory.lru.LRUMemoryCache;

public class TestLRUMemoryCache
extends TestCase {
    private static int items = 200;
    static /* synthetic */ Class class$org$apache$jcs$engine$memory$lru$TestLRUMemoryCache;

    public TestLRUMemoryCache(String testName) {
        super(testName);
    }

    public static void main(String[] args) {
        String[] testCaseName = new String[]{(class$org$apache$jcs$engine$memory$lru$TestLRUMemoryCache == null ? (class$org$apache$jcs$engine$memory$lru$TestLRUMemoryCache = TestLRUMemoryCache.class$("org.apache.jcs.engine.memory.lru.TestLRUMemoryCache")) : class$org$apache$jcs$engine$memory$lru$TestLRUMemoryCache).getName()};
        TestRunner.main((String[])testCaseName);
    }

    public static Test suite() {
        ActiveTestSuite suite = new ActiveTestSuite();
        suite.addTest((Test)new TestLRUMemoryCache("testLRUMemoryCache"){

            public void runTest() throws Exception {
                this.runTestForRegion("indexedRegion1");
            }
        });
        return suite;
    }

    public void setUp() {
    }

    public void runTestForRegion(String region) throws Exception {
        CompositeCacheManager cacheMgr = CompositeCacheManager.getUnconfiguredInstance();
        cacheMgr.configure("/TestDiskCache.ccf");
        CompositeCache cache = cacheMgr.getCache(region);
        LRUMemoryCache lru = new LRUMemoryCache();
        lru.initialize(cache);
        int i = 0;
        while (i < items) {
            CacheElement ice = new CacheElement(cache.getCacheName(), (Serializable)((Object)(i + ":key")), (Serializable)((Object)(region + " data " + i)));
            ice.setElementAttributes(cache.getElementAttributes().copy());
            lru.update(ice);
            ++i;
        }
        int i2 = 0;
        while (i2 < 102) {
            Assert.assertNull((Object)lru.get((Serializable)((Object)(i2 + ":key"))));
            ++i2;
        }
        int i3 = 102;
        while (i3 < items) {
            String value = (String)((Object)lru.get((Serializable)((Object)(i3 + ":key"))).getVal());
            Assert.assertEquals((Object)(region + " data " + i3), (Object)value);
            ++i3;
        }
        int i4 = 0;
        while (i4 < items) {
            lru.remove((Serializable)((Object)(i4 + ":key")));
            ++i4;
        }
        int i5 = 0;
        while (i5 < items) {
            Assert.assertNull((String)("Removed key should be null: " + i5 + ":key"), (Object)lru.get((Serializable)((Object)(i5 + ":key"))));
            ++i5;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

