/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote.server;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.NotBoundException;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.server.Unreferenced;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheListener;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheServiceAdmin;
import org.apache.jcs.auxiliary.remote.server.RemoteCacheServerFactory;
import org.apache.jcs.auxiliary.remote.server.behavior.IRemoteCacheServerAttributes;
import org.apache.jcs.engine.CacheEventQueue;
import org.apache.jcs.engine.CacheListeners;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheListener;
import org.apache.jcs.engine.control.CompositeCache;
import org.apache.jcs.engine.control.CompositeCacheManager;

public class RemoteCacheServer
extends UnicastRemoteObject
implements IRemoteCacheService,
IRemoteCacheObserver,
IRemoteCacheServiceAdmin,
Unreferenced {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer == null ? (class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer = RemoteCacheServer.class$("org.apache.jcs.auxiliary.remote.server.RemoteCacheServer")) : class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer));
    protected static final boolean timing = true;
    public String className;
    private int puts = 0;
    private final Hashtable cacheListenersMap = new Hashtable();
    private final Hashtable clusterListenersMap = new Hashtable();
    private CompositeCacheManager cacheManager;
    private final Hashtable idTypeMap = new Hashtable();
    private int[] listenerId = new int[1];
    protected IRemoteCacheServerAttributes rcsa;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$server$RemoteCacheServer;
    static /* synthetic */ Class class$org$apache$jcs$engine$behavior$ICacheListener;

    protected RemoteCacheServer(IRemoteCacheServerAttributes rcsa) throws IOException, NotBoundException {
        super(rcsa.getServicePort());
        this.rcsa = rcsa;
        this.init(rcsa.getConfigFileName());
    }

    protected void init(String prop) throws IOException, NotBoundException {
        String s = this.getClass().getName();
        int idx = s.lastIndexOf(".");
        this.className = s.substring(idx + 1);
        this.cacheManager = this.createCacheManager(prop);
        String[] list = this.cacheManager.getCacheNames();
        int i = 0;
        while (i < list.length) {
            String name = list[i];
            this.cacheListenersMap.put(name, new CacheListeners(this.cacheManager.getCache(name)));
            ++i;
        }
    }

    protected CompositeCacheManager createCacheManager(String prop) {
        CompositeCacheManager hub = CompositeCacheManager.getUnconfiguredInstance();
        if (prop == null) {
            hub.configure("/remote.cache.properties");
        } else {
            hub.configure(prop);
        }
        return hub;
    }

    private CacheListeners getCacheListeners(String cacheName) throws IOException, NotBoundException {
        CacheListeners cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheListeners == null) {
            Hashtable hashtable = this.cacheListenersMap;
            synchronized (hashtable) {
                cacheListeners = (CacheListeners)this.cacheListenersMap.get(cacheName);
                if (cacheListeners == null) {
                    cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                    this.cacheListenersMap.put(cacheName, cacheListeners);
                }
            }
        }
        return cacheListeners;
    }

    private CacheListeners getClusterListeners(String cacheName) throws IOException, NotBoundException {
        CacheListeners cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
        if (cacheListeners == null) {
            Hashtable hashtable = this.clusterListenersMap;
            synchronized (hashtable) {
                cacheListeners = (CacheListeners)this.clusterListenersMap.get(cacheName);
                if (cacheListeners == null) {
                    cacheListeners = new CacheListeners(this.cacheManager.getCache(cacheName));
                    this.clusterListenersMap.put(cacheName, cacheListeners);
                }
            }
        }
        return cacheListeners;
    }

    public void put(ICacheElement item) throws IOException {
        this.update(item);
    }

    public void update(ICacheElement item) throws IOException {
        this.update(item, (byte)0);
    }

    public void update(ICacheElement item, byte requesterId) throws IOException {
        long start = 0L;
        start = System.currentTimeMillis();
        if (log.isDebugEnabled()) {
            ++this.puts;
            if (this.puts % 100 == 0) {
                RemoteCacheServer.p1("puts = " + this.puts);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("in update, put " + item.getKey() + " in " + item.getCacheName()));
        }
        try {
            CacheListeners cacheDesc = this.getCacheListeners(item.getCacheName());
            Serializable val = item.getVal();
            Integer remoteTypeL = (Integer)this.idTypeMap.get(new Byte(requesterId));
            boolean fromCluster = false;
            if (remoteTypeL == 1) {
                fromCluster = true;
            }
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                try {
                    CompositeCache c = (CompositeCache)cacheDesc.cache;
                    if (fromCluster) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"not updating clusters **************************************");
                        }
                        c.localUpdate(item);
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"updating clusters **************************************");
                        }
                        c.update(item);
                    }
                }
                catch (Exception oee) {
                    // empty catch block
                }
                if (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency()) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    int i = 0;
                    while (i < qlist.length) {
                        qlist[i].addPutEvent(item);
                        ++i;
                    }
                }
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace(System.out);
            throw new IllegalStateException(ex.getMessage());
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        long end = System.currentTimeMillis();
        RemoteCacheServer.p1("put took " + String.valueOf(end - start) + " ms.");
    }

    private ICacheEventQueue[] getEventQList(CacheListeners cacheListeners, byte requesterId) {
        ICacheEventQueue[] list = null;
        Map map = cacheListeners.eventQMap;
        synchronized (map) {
            list = cacheListeners.eventQMap.values().toArray(new ICacheEventQueue[0]);
        }
        int count = 0;
        int i = 0;
        while (i < list.length) {
            ICacheEventQueue q = list[i];
            if (q.isAlive() && q.getListenerId() != requesterId) {
                ++count;
            } else {
                list[i] = null;
            }
            ++i;
        }
        if (count == list.length) {
            return list;
        }
        ICacheEventQueue[] qq = new ICacheEventQueue[count];
        count = 0;
        int i2 = 0;
        while (i2 < list.length) {
            if (list[i2] != null) {
                qq[count++] = list[i2];
            }
            ++i2;
        }
        return qq;
    }

    public ICacheElement get(String cacheName, Serializable key) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("get " + key + " from cache " + cacheName));
        }
        boolean fromCluster = false;
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (cacheDesc == null) {
            return null;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.localGet(key);
    }

    public Set getGroupKeys(String cacheName, String group) {
        CacheListeners cacheDesc = null;
        try {
            cacheDesc = this.getCacheListeners(cacheName);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
        if (cacheDesc == null) {
            return Collections.EMPTY_SET;
        }
        CompositeCache c = (CompositeCache)cacheDesc.cache;
        return c.getGroupKeys(group);
    }

    public void remove(String cacheName, Serializable key) throws IOException {
        this.remove(cacheName, key, (byte)0);
    }

    public void remove(String cacheName, Serializable key, byte requesterId) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("remove " + key + " from cache " + cacheName));
        }
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        Integer remoteTypeL = (Integer)this.idTypeMap.get(new Byte(requesterId));
        boolean fromCluster = false;
        if (remoteTypeL == 1) {
            fromCluster = true;
        }
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                boolean removeSuccess = false;
                CompositeCache c = (CompositeCache)cacheDesc.cache;
                if (fromCluster) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"not updating clusters **************************************");
                    }
                    removeSuccess = c.localRemove(key);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"updating clusters **************************************");
                    }
                    removeSuccess = c.remove(key);
                }
                if (removeSuccess && (!fromCluster || fromCluster && this.rcsa.getLocalClusterConsistency())) {
                    ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                    int i = 0;
                    while (i < qlist.length) {
                        qlist[i].addRemoveEvent(key);
                        ++i;
                    }
                }
            }
        }
    }

    public void removeAll(String cacheName) throws IOException {
        this.removeAll(cacheName, (byte)0);
    }

    public void removeAll(String cacheName, byte requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                int i = 0;
                while (i < qlist.length) {
                    qlist[i].addRemoveAllEvent();
                    ++i;
                }
                cacheDesc.cache.removeAll();
            }
        }
    }

    public void dispose(String cacheName) throws IOException {
        this.dispose(cacheName, (byte)0);
    }

    public void dispose(String cacheName, byte requesterId) throws IOException {
        CacheListeners cacheDesc = (CacheListeners)this.cacheListenersMap.get(cacheName);
        if (cacheDesc != null) {
            CacheListeners cacheListeners = cacheDesc;
            synchronized (cacheListeners) {
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, requesterId);
                int i = 0;
                while (i < qlist.length) {
                    qlist[i].addDisposeEvent();
                    ++i;
                }
                this.cacheManager.freeCache(cacheName);
            }
        }
    }

    public void release() throws IOException {
        Hashtable hashtable = this.cacheListenersMap;
        synchronized (hashtable) {
            Enumeration en = this.cacheListenersMap.elements();
            while (en.hasMoreElements()) {
                CacheListeners cacheDesc = (CacheListeners)en.nextElement();
                ICacheEventQueue[] qlist = this.getEventQList(cacheDesc, (byte)0);
                int i = 0;
                while (i < qlist.length) {
                    qlist[i].addDisposeEvent();
                    ++i;
                }
            }
            this.cacheManager.release();
        }
    }

    private String getRequester() {
        try {
            return RemoteServer.getClientHost();
        }
        catch (ServerNotActiveException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    private static void cleanupEventQMap(Map eventQMap) {
        Map map = eventQMap;
        synchronized (map) {
            Iterator itr = eventQMap.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry e = itr.next();
                ICacheEventQueue q = (ICacheEventQueue)e.getValue();
                if (q.isAlive()) continue;
                itr.remove();
                RemoteCacheServer.p1("Cache event queue " + q + " dead and removed from cache server.");
            }
        }
    }

    public void addCacheListener(String cacheName, ICacheListener listener) throws IOException {
        if (cacheName == null || listener == null) {
            throw new IllegalArgumentException("cacheName and listener must not be null");
        }
        try {
            CacheListeners cacheDesc;
            IRemoteCacheListener ircl = (IRemoteCacheListener)listener;
            int remoteType = ircl.getRemoteType();
            if (remoteType == 1) {
                log.debug((Object)"adding cluster listener");
                cacheDesc = this.getClusterListeners(cacheName);
            } else {
                log.debug((Object)"adding normal listener");
                cacheDesc = this.getCacheListeners(cacheName);
            }
            Map eventQMap = cacheDesc.eventQMap;
            RemoteCacheServer.cleanupEventQMap(eventQMap);
            Class clazz = class$org$apache$jcs$engine$behavior$ICacheListener == null ? (class$org$apache$jcs$engine$behavior$ICacheListener = RemoteCacheServer.class$("org.apache.jcs.engine.behavior.ICacheListener")) : class$org$apache$jcs$engine$behavior$ICacheListener;
            synchronized (clazz) {
                byte id = 0;
                try {
                    id = listener.getListenerId();
                    if (id == 0) {
                        byte listenerIdB = this.nextListenerId();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("listener id=" + (listenerIdB & 0xFF) + " addded for cache " + cacheName));
                        }
                        listener.setListenerId(listenerIdB);
                        id = listenerIdB;
                        RemoteCacheServer.p1("added new vm listener " + listenerIdB);
                        this.idTypeMap.put(new Byte(listenerIdB), new Integer(remoteType));
                    } else {
                        RemoteCacheServer.p1("added existing vm listener " + id);
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                eventQMap.put(listener, new CacheEventQueue(listener, id, cacheName));
                if (log.isDebugEnabled()) {
                    log.debug((Object)("****** Cache " + cacheName + "'s listener size=" + cacheDesc.eventQMap.size()));
                }
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void addCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.addCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("adding listener for cache " + cacheName));
        }
    }

    public void removeCacheListener(String cacheName, ICacheListener listener) throws IOException {
        try {
            CacheListeners cacheDesc = this.getCacheListeners(cacheName);
            Map eventQMap = cacheDesc.eventQMap;
            RemoteCacheServer.cleanupEventQMap(eventQMap);
            ICacheEventQueue q = (ICacheEventQueue)eventQMap.remove(listener);
            if (q != null) {
                q.destroy();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("****** Cache " + cacheName + "'s listener size=" + cacheDesc.eventQMap.size()));
            }
        }
        catch (NotBoundException ex) {
            ex.printStackTrace();
            throw new IllegalStateException(ex.getMessage());
        }
    }

    public void removeCacheListener(ICacheListener listener) throws IOException {
        Enumeration en = this.cacheListenersMap.keys();
        while (en.hasMoreElements()) {
            String cacheName = (String)en.nextElement();
            this.removeCacheListener(cacheName, listener);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)("removing listener for cache " + cacheName));
        }
    }

    public void shutdown() throws IOException {
        RemoteCacheServerFactory.shutdownImpl("", 1099);
    }

    public void shutdown(String host, int port) throws IOException {
        log.debug((Object)"received shutdown request");
        RemoteCacheServerFactory.shutdownImpl(host, port);
    }

    public void unreferenced() {
        log.debug((Object)"*** Warning: Server now unreferenced and subject to GC. ***");
    }

    private byte nextListenerId() {
        int id = 0;
        if (this.listenerId[0] == 255) {
            int[] nArray = this.listenerId;
            synchronized (nArray) {
                id = this.listenerId[0];
                this.listenerId[0] = 0;
            }
        }
        int[] nArray = this.listenerId;
        synchronized (nArray) {
            id = this.listenerId[0] = this.listenerId[0] + 1;
        }
        return (byte)(id & 0xFF);
    }

    private static void p1(String s) {
        System.out.println("RemoteCacheServer:" + s + " >" + Thread.currentThread().getName());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

