/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.rmi.Naming;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.remote.RemoteCacheManager;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheObserver;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.behavior.ICacheRestore;

public class RemoteCacheRestore
implements ICacheRestore {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheRestore == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheRestore = RemoteCacheRestore.class$("org.apache.jcs.auxiliary.remote.RemoteCacheRestore")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheRestore));
    private final RemoteCacheManager rcm;
    private boolean canFix = true;
    private Object remoteObj;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheRestore;

    public RemoteCacheRestore(RemoteCacheManager rcm) {
        this.rcm = rcm;
    }

    public boolean canFix() {
        if (!this.canFix) {
            return this.canFix;
        }
        String registry = "//" + this.rcm.host + ":" + this.rcm.port + "/" + this.rcm.service;
        log.info((Object)("looking up server " + registry));
        try {
            this.remoteObj = Naming.lookup(registry);
            log.info((Object)("looking up server " + registry));
        }
        catch (Exception ex) {
            log.error((Object)("host=" + this.rcm.host + "; port" + this.rcm.port + "; service=" + this.rcm.service));
            this.canFix = false;
        }
        return this.canFix;
    }

    public void fix() {
        if (!this.canFix) {
            return;
        }
        this.rcm.fixCaches((IRemoteCacheService)this.remoteObj, (IRemoteCacheObserver)this.remoteObj);
        String msg = "Remote connection to //" + this.rcm.host + ":" + this.rcm.port + "/" + this.rcm.service + " resumed.";
        log.info((Object)msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

