/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jcs.auxiliary.remote;

import java.io.IOException;
import java.io.Serializable;
import java.rmi.UnmarshalException;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jcs.auxiliary.AuxiliaryCache;
import org.apache.jcs.auxiliary.remote.RemoteCache;
import org.apache.jcs.auxiliary.remote.RemoteCacheInfo;
import org.apache.jcs.auxiliary.remote.behavior.IRemoteCacheService;
import org.apache.jcs.engine.CacheAdaptor;
import org.apache.jcs.engine.CacheEventQueue;
import org.apache.jcs.engine.behavior.ICacheElement;
import org.apache.jcs.engine.behavior.ICacheEventQueue;

public class RemoteCacheNoWait
implements AuxiliaryCache {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait == null ? (class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait = RemoteCacheNoWait.class$("org.apache.jcs.auxiliary.remote.RemoteCacheNoWait")) : class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait));
    private final RemoteCache cache;
    private ICacheEventQueue q;
    static /* synthetic */ Class class$org$apache$jcs$auxiliary$remote$RemoteCacheNoWait;

    public RemoteCacheNoWait(RemoteCache cache) {
        this.cache = cache;
        this.q = new CacheEventQueue(new CacheAdaptor(cache), RemoteCacheInfo.listenerId, cache.getCacheName());
        if (cache.getStatus() == 3) {
            this.q.destroy();
        }
    }

    public void update(ICacheElement ce) throws IOException {
        try {
            this.q.addPutEvent(ce);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
    }

    public ICacheElement get(Serializable key) throws IOException {
        try {
            return this.cache.get(key);
        }
        catch (UnmarshalException ue) {
            log.debug((Object)"Retrying the get owing to UnmarshalException...");
            try {
                return this.cache.get(key);
            }
            catch (IOException ex) {
                log.debug((Object)"Failed in retrying the get for the second time.");
                this.q.destroy();
            }
        }
        catch (IOException ex) {
            this.q.destroy();
            throw ex;
        }
        return null;
    }

    public Set getGroupKeys(String groupName) {
        return this.cache.getGroupKeys(groupName);
    }

    public boolean remove(Serializable key) throws IOException {
        try {
            this.q.addRemoveEvent(key);
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
        return false;
    }

    public void removeAll() throws IOException {
        try {
            this.q.addRemoveAllEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
            throw ex;
        }
    }

    public void dispose() {
        try {
            this.q.addDisposeEvent();
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.q.destroy();
        }
    }

    public int getSize() {
        return this.cache.getSize();
    }

    public int getCacheType() {
        return 4;
    }

    public int getStatus() {
        return this.q.isAlive() ? this.cache.getStatus() : 3;
    }

    public String getCacheName() {
        return this.cache.getCacheName();
    }

    public void fixCache(IRemoteCacheService remote) {
        this.cache.fixCache(remote);
        this.resetEventQ();
    }

    public void resetEventQ() {
        if (this.q.isAlive()) {
            this.q.destroy();
        }
        this.q = new CacheEventQueue(new CacheAdaptor(this.cache), RemoteCacheInfo.listenerId, this.cache.getCacheName());
    }

    public String toString() {
        return "RemoteCacheNoWait: " + this.cache.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

