/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.VirtualProxy;
import test.ojb.broker.Article;
import test.ojb.broker.InterfaceArticle;
import test.ojb.broker.InterfaceProductGroup;
import test.ojb.broker.ProductGroupWithCollectionProxy;

public class ProxyExamples
extends TestCase {
    PersistenceBroker broker;
    private static Class CLASS = class$test$ojb$broker$ProxyExamples == null ? (class$test$ojb$broker$ProxyExamples = ProxyExamples.class$("test.ojb.broker.ProxyExamples")) : class$test$ojb$broker$ProxyExamples;
    private int testId = 88883;
    static /* synthetic */ Class class$test$ojb$broker$ProxyExamples;
    static /* synthetic */ Class class$test$ojb$broker$Article;
    static /* synthetic */ Class class$test$ojb$broker$ArticleProxy;
    static /* synthetic */ Class class$test$ojb$broker$ProductGroup;
    static /* synthetic */ Class class$test$ojb$broker$ProductGroupProxy;

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    public ProxyExamples(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    public void setUp() {
        this.broker = PersistenceBrokerFactory.createPersistenceBroker();
    }

    public void tearDown() {
        try {
            this.broker.clearCache();
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            // empty catch block
        }
    }

    public void testProgrammedProxies() {
        try {
            Vector<InterfaceArticle> myArticles = new Vector<InterfaceArticle>();
            int i = 1;
            while (i < 10) {
                Object[] pkvals = new Object[]{new Integer(i)};
                Identity id = new Identity(class$test$ojb$broker$Article == null ? ProxyExamples.class$("test.ojb.broker.Article") : class$test$ojb$broker$Article, pkvals);
                InterfaceArticle A2 = (InterfaceArticle)VirtualProxy.createProxy(class$test$ojb$broker$ArticleProxy == null ? ProxyExamples.class$("test.ojb.broker.ArticleProxy") : class$test$ojb$broker$ArticleProxy, id);
                myArticles.add(A2);
                ++i;
            }
            int i2 = 0;
            while (i2 < 9) {
                InterfaceArticle a = (InterfaceArticle)myArticles.get(i2);
                ++i2;
            }
            int i3 = 0;
            while (i3 < 9) {
                InterfaceArticle a = (InterfaceArticle)myArticles.get(i3);
                ++i3;
            }
            Object[] pkvals = new Object[]{new Integer(2)};
            Identity id = new Identity(class$test$ojb$broker$ProductGroup == null ? (class$test$ojb$broker$ProductGroup = ProxyExamples.class$("test.ojb.broker.ProductGroup")) : class$test$ojb$broker$ProductGroup, pkvals);
            InterfaceProductGroup group2 = null;
            try {
                group2 = (InterfaceProductGroup)VirtualProxy.createProxy(class$test$ojb$broker$ProductGroupProxy == null ? (class$test$ojb$broker$ProductGroupProxy = ProxyExamples.class$("test.ojb.broker.ProductGroupProxy")) : class$test$ojb$broker$ProductGroupProxy, id);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            int i4 = 0;
            while (i4 < group2.getAllArticles().size()) {
                InterfaceArticle a = (InterfaceArticle)group2.getAllArticles().get(i4);
                this.broker.store(a);
                ++i4;
            }
            this.broker.store(group2);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    private Class getDynamicProxyClass(Class clazz) {
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            Class<?> proxyClass = Proxy.getProxyClass(clazz.getClassLoader(), interfaces);
            return proxyClass;
        }
        catch (Throwable t) {
            System.out.println("OJB Warning: can not use dynamic proxy for class " + clazz.getName() + ": " + t.getMessage());
            return null;
        }
    }

    public void testDynamicProxies() {
        try {
            Vector<InterfaceArticle> myArticles = new Vector<InterfaceArticle>();
            int i = 1;
            while (i < 10) {
                Object[] pkvals = new Object[]{new Integer(i)};
                Identity id = new Identity(class$test$ojb$broker$Article == null ? ProxyExamples.class$("test.ojb.broker.Article") : class$test$ojb$broker$Article, pkvals);
                InterfaceArticle A2 = (InterfaceArticle)VirtualProxy.createProxy(this.getDynamicProxyClass(class$test$ojb$broker$Article == null ? ProxyExamples.class$("test.ojb.broker.Article") : class$test$ojb$broker$Article), id);
                myArticles.add(A2);
                ++i;
            }
            int i2 = 0;
            while (i2 < 9) {
                InterfaceArticle a = (InterfaceArticle)myArticles.get(i2);
                ++i2;
            }
            int i3 = 0;
            while (i3 < 9) {
                InterfaceArticle a = (InterfaceArticle)myArticles.get(i3);
                ++i3;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testCollectionProxies() {
        try {
            ProductGroupWithCollectionProxy pg = new ProductGroupWithCollectionProxy();
            pg.setId(7);
            Identity pgOID = new Identity(pg);
            pg = (ProductGroupWithCollectionProxy)this.broker.getObjectByIdentity(pgOID);
            Assert.assertEquals((int)7, (int)pg.getId());
            Collection col = pg.getAllArticles();
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                InterfaceArticle a = (InterfaceArticle)iter.next();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

