/*
 * Decompiled with CFR 0.152.
 */
package test.ojb.broker;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import ojb.broker.Identity;
import ojb.broker.PersistenceBroker;
import ojb.broker.PersistenceBrokerException;
import ojb.broker.PersistenceBrokerFactory;
import ojb.broker.metadata.ClassDescriptor;
import ojb.broker.query.Criteria;
import ojb.broker.query.Query;
import ojb.broker.query.QueryByExample;
import ojb.broker.query.QueryFactory;
import ojb.broker.util.LoggerFactory;
import ojb.broker.util.ObjectModificationDefaultImpl;
import test.ojb.broker.A;
import test.ojb.broker.AB;
import test.ojb.broker.Article;
import test.ojb.broker.ArticlePrimaryKey;
import test.ojb.broker.ArticleWithStockDetail;
import test.ojb.broker.B;
import test.ojb.broker.C;
import test.ojb.broker.D;
import test.ojb.broker.InterfaceArticle;
import test.ojb.broker.InterfaceProductGroup;
import test.ojb.broker.ProductGroup;
import test.ojb.broker.StockDetail;

public class PersistenceBrokerTest
extends TestCase {
    PersistenceBroker broker;
    int testId = 12345;
    private static Class CLASS = class$test$ojb$broker$PersistenceBrokerTest == null ? (class$test$ojb$broker$PersistenceBrokerTest = PersistenceBrokerTest.class$("test.ojb.broker.PersistenceBrokerTest")) : class$test$ojb$broker$PersistenceBrokerTest;
    static /* synthetic */ Class class$test$ojb$broker$PersistenceBrokerTest;
    static /* synthetic */ Class class$test$ojb$broker$AB;
    static /* synthetic */ Class class$test$ojb$broker$A;
    static /* synthetic */ Class class$test$ojb$broker$B;
    static /* synthetic */ Class class$test$ojb$broker$C;
    static /* synthetic */ Class class$test$ojb$broker$D;
    static /* synthetic */ Class class$test$ojb$broker$Article;
    static /* synthetic */ Class class$test$ojb$broker$ArticleWithStockDetail;
    static /* synthetic */ Class class$test$ojb$broker$InterfaceArticle;
    static /* synthetic */ Class class$test$ojb$broker$ArticlePrimaryKey;

    public PersistenceBrokerTest(String name) {
        super(name);
    }

    protected Article createArticle(int id) {
        Article a = new Article();
        a.setArticleId(id);
        a.setArticleName("New Funny Article " + id);
        a.setIsSelloutArticle(true);
        a.setMinimumStock(100);
        a.setOrderedUnits(17);
        a.setPrice(0.45);
        a.setProductGroupId(1);
        a.setStock(234);
        a.setSupplierId(4);
        a.setUnit("bottle");
        return a;
    }

    protected void deleteArticle(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        this.broker.delete(a);
    }

    protected void deleteArticle(Article articleToDelete) throws PersistenceBrokerException {
        this.broker.delete(articleToDelete);
    }

    public static void main(String[] args) {
        String[] arr = new String[]{CLASS.getName()};
        TestRunner.main((String[])arr);
    }

    protected Article readArticleByExample(int id) throws PersistenceBrokerException {
        Article example = new Article();
        example.setArticleId(id);
        return (Article)this.broker.getObjectByQuery(QueryFactory.newQuery(example));
    }

    protected Article readArticleByIdentity(int id) throws PersistenceBrokerException {
        Article a = new Article();
        a.setArticleId(id);
        Identity oid = new Identity(a);
        return (Article)this.broker.getObjectByIdentity(oid);
    }

    public void setUp() {
        try {
            this.broker = PersistenceBrokerFactory.createPersistenceBroker();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected void storeArticle(Article anArticle) throws PersistenceBrokerException {
        this.broker.store(anArticle);
    }

    public void tearDown() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            this.broker.clearCache();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void testDelete() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            this.deleteArticle(b);
            b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            b = this.readArticleByExample(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    public void testMappingToOneTableWithAbstractBaseclass() {
        try {
            Collection abs = null;
            Criteria c = null;
            Query q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, c);
            abs = this.broker.getCollectionByQuery(q);
            if (abs != null) {
                Iterator iter = abs.iterator();
                while (iter.hasNext()) {
                    this.broker.delete(iter.next());
                }
            }
            A a1 = new A();
            Identity iA1 = new Identity(a1);
            A a2 = new A();
            Identity iA2 = new Identity(a2);
            B b1 = new B();
            Identity iB2 = new Identity(b1);
            this.broker.store(a1);
            this.broker.store(a2);
            this.broker.store(b1);
            AB ab = null;
            Criteria crit = new Criteria();
            crit.addEqualTo("id", new Integer(a1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, crit);
            ab = (AB)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$A == null ? (class$test$ojb$broker$A = PersistenceBrokerTest.class$("test.ojb.broker.A")) : class$test$ojb$broker$A).getName(), (Object)ab.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$A == null ? (class$test$ojb$broker$A = PersistenceBrokerTest.class$("test.ojb.broker.A")) : class$test$ojb$broker$A), ab.getClass());
            crit = new Criteria();
            crit.addEqualTo("id", new Integer(b1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, crit);
            ab = (AB)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$B == null ? (class$test$ojb$broker$B = PersistenceBrokerTest.class$("test.ojb.broker.B")) : class$test$ojb$broker$B).getName(), (Object)ab.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$B == null ? (class$test$ojb$broker$B = PersistenceBrokerTest.class$("test.ojb.broker.B")) : class$test$ojb$broker$B), ab.getClass());
            abs = null;
            Criteria selectAll = null;
            q = QueryFactory.newQuery(class$test$ojb$broker$AB == null ? (class$test$ojb$broker$AB = PersistenceBrokerTest.class$("test.ojb.broker.AB")) : class$test$ojb$broker$AB, selectAll);
            abs = this.broker.getCollectionByQuery(q);
            Assert.assertEquals((int)3, (int)abs.size());
            q = QueryFactory.newQuery(class$test$ojb$broker$A == null ? (class$test$ojb$broker$A = PersistenceBrokerTest.class$("test.ojb.broker.A")) : class$test$ojb$broker$A, selectAll);
            abs = this.broker.getCollectionByQuery(q);
            Assert.assertEquals((int)2, (int)abs.size());
            q = QueryFactory.newQuery(class$test$ojb$broker$B == null ? (class$test$ojb$broker$B = PersistenceBrokerTest.class$("test.ojb.broker.B")) : class$test$ojb$broker$B, selectAll);
            abs = this.broker.getCollectionByQuery(q);
            Assert.assertEquals((int)1, (int)abs.size());
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    public void testMappingToOneTable() {
        try {
            Collection cs = null;
            Criteria crit = null;
            Query q = QueryFactory.newQuery(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C, crit);
            cs = this.broker.getCollectionByQuery(q);
            if (cs != null) {
                Iterator iter = cs.iterator();
                while (iter.hasNext()) {
                    this.broker.delete(iter.next());
                }
            }
            C c1 = new C();
            Identity iC1 = new Identity(c1);
            C c2 = new C();
            Identity iC2 = new Identity(c2);
            D d1 = new D();
            Identity iD1 = new Identity(d1);
            this.broker.store(c1);
            this.broker.store(c2);
            this.broker.store(d1);
            C candidate = null;
            crit = new Criteria();
            crit.addEqualTo("id", new Integer(c1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C, crit);
            candidate = (C)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C).getName(), (Object)candidate.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C), candidate.getClass());
            crit = new Criteria();
            crit.addEqualTo("id", new Integer(d1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C, crit);
            candidate = (C)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D).getName(), (Object)candidate.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D), candidate.getClass());
            crit = new Criteria();
            crit.addEqualTo("id", new Integer(d1.id));
            q = QueryFactory.newQuery(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D, crit);
            candidate = (D)this.broker.getObjectByQuery(q);
            Assert.assertEquals((Object)(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D).getName(), (Object)candidate.getConcreteClass());
            Assert.assertEquals((Object)(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D), candidate.getClass());
            cs = null;
            Criteria selectAll = null;
            q = QueryFactory.newQuery(class$test$ojb$broker$C == null ? (class$test$ojb$broker$C = PersistenceBrokerTest.class$("test.ojb.broker.C")) : class$test$ojb$broker$C, selectAll);
            cs = this.broker.getCollectionByQuery(q);
            Assert.assertEquals((int)3, (int)cs.size());
            q = QueryFactory.newQuery(class$test$ojb$broker$D == null ? (class$test$ojb$broker$D = PersistenceBrokerTest.class$("test.ojb.broker.D")) : class$test$ojb$broker$D, selectAll);
            cs = this.broker.getCollectionByQuery(q);
            Assert.assertEquals((int)1, (int)cs.size());
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetDescriptor() {
        try {
            ClassDescriptor cld = this.broker.getClassDescriptor(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article);
            Assert.assertNotNull((String)"classdescriptor should not be null", (Object)cld);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testRowReader() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Criteria crit = new Criteria();
            crit.addEqualTo("articleId", new Integer(this.testId));
            Query q = QueryFactory.newQuery(class$test$ojb$broker$ArticleWithStockDetail == null ? (class$test$ojb$broker$ArticleWithStockDetail = PersistenceBrokerTest.class$("test.ojb.broker.ArticleWithStockDetail")) : class$test$ojb$broker$ArticleWithStockDetail, crit);
            ArticleWithStockDetail b = (ArticleWithStockDetail)this.broker.getObjectByQuery(q);
            StockDetail detail = b.getDetail();
            Assert.assertNotNull((String)"detail should be loaded by RowReader !", (Object)detail);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testEscaping() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            a.setArticleName("Single quote 'article ");
            this.storeArticle(a);
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String name = a.getArticleName();
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$InterfaceArticle == null ? (class$test$ojb$broker$InterfaceArticle = PersistenceBrokerTest.class$("test.ojb.broker.InterfaceArticle")) : class$test$ojb$broker$InterfaceArticle, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("2 Single quotes 'article' ");
            this.storeArticle(a);
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("double quote \"article ");
            this.storeArticle(a);
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("2 double quotes \"article\" ");
            this.storeArticle(a);
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            a.setArticleName("a comma thing ,article, ");
            this.storeArticle(a);
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            name = a.getArticleName();
            criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            col = this.broker.getCollectionByQuery(query);
            iter = col.iterator();
            Assert.assertTrue((String)"should have one element", (boolean)iter.hasNext());
            Assert.assertEquals((String)"should be equal", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetByExampleAndGetByIdentity() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            Article c = this.readArticleByExample(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)c.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetCollectionByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be zero", (int)0, (int)col.size());
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be three", (int)3, (int)col.size());
            iter = col.iterator();
            while (iter.hasNext()) {
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testSorting() {
        try {
            String name = "SortingTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            criteria.orderBy("articleId", false);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Collection col = this.broker.getCollectionByQuery(query);
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be zero", (int)0, (int)col.size());
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            col = this.broker.getCollectionByQuery(query);
            Assert.assertEquals((String)"size of collection should be three", (int)3, (int)col.size());
            iter = col.iterator();
            Assert.assertEquals((String)"should be same value", (int)id3, (int)((InterfaceArticle)iter.next()).getArticleId());
            Assert.assertEquals((String)"should be same value", (int)id2, (int)((InterfaceArticle)iter.next()).getArticleId());
            Assert.assertEquals((String)"should be same value", (int)id1, (int)((InterfaceArticle)iter.next()).getArticleId());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testSortedCollectionAttribute() {
        try {
            ProductGroup samplePG = new ProductGroup();
            samplePG.setId(1);
            InterfaceProductGroup pg = (InterfaceProductGroup)this.broker.getObjectByQuery(new QueryByExample(samplePG));
            Iterator iter = pg.getAllArticles().iterator();
            InterfaceArticle a1 = null;
            InterfaceArticle a2 = null;
            a1 = (InterfaceArticle)iter.next();
            while (iter.hasNext()) {
                a2 = a1;
                a1 = (InterfaceArticle)iter.next();
                Assert.assertTrue((a1.getArticleId() < a2.getArticleId() ? 1 : 0) != 0);
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testAutoIncrement() {
        try {
            ProductGroup pg1 = new ProductGroup();
            Identity id1 = new Identity(pg1);
            ProductGroup pg2 = new ProductGroup();
            Identity id2 = new Identity(pg2);
            pg1.setName("AutoIncGroup1");
            pg2.setName("AutoIncGroup2");
            this.broker.store(pg1);
            this.broker.store(pg2);
            Assert.assertEquals((String)"should have assigned to Integers with diff 1", (int)1, (int)(pg2.getId() - pg1.getId()));
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetIteratorByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Iterator iter = this.broker.getIteratorByQuery(query);
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            iter = this.broker.getIteratorByQuery(query);
            Assert.assertTrue((String)"size of collection should be zero", (!iter.hasNext() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            iter = this.broker.getIteratorByQuery(query);
            int count = 0;
            while (iter.hasNext()) {
                ++count;
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)iter.next()).getArticleName());
            }
            Assert.assertEquals((String)"Iterator should produce 3 items", (int)3, (int)count);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetIteratorBySQL() {
        try {
            Criteria criteria = new Criteria();
            criteria.addEqualTo("productGroupId", new Integer(2));
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Iterator iter1 = this.broker.getIteratorByQuery(query);
            String sql = "SELECT A.Artikel_Nr FROM Artikel A, Kategorien PG WHERE A.Kategorie_Nr = PG.Kategorie_Nr AND PG.Kategorie_Nr = 2";
            Query q2 = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, sql);
            Iterator iter2 = this.broker.getIteratorByQuery(q2);
            while (iter1.hasNext()) {
                InterfaceArticle a1 = (InterfaceArticle)iter1.next();
                InterfaceArticle a2 = (InterfaceArticle)iter2.next();
                Assert.assertEquals((String)"iterators should return equal objects", (int)a1.getArticleId(), (int)a2.getArticleId());
            }
            Assert.assertTrue((String)"iter2 should not contain more items than iter1", (!iter2.hasNext() ? 1 : 0) != 0);
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetReportQueryIteratorBySQL() {
        try {
            String sql = "SELECT * FROM Artikel A, Kategorien PG WHERE A.Kategorie_Nr = PG.Kategorie_Nr AND PG.Kategorie_Nr = 2";
            Query q = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, sql);
            Iterator iter = this.broker.getReportQueryIteratorByQuery(q);
            while (iter.hasNext()) {
                Object[] arr = (Object[])iter.next();
                int i = 0;
                while (i < arr.length) {
                    ++i;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetMultipleIteratorsByQuery() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Iterator iter = this.broker.getIteratorByQuery(query);
            while (iter.hasNext()) {
                this.broker.delete(iter.next());
            }
            iter = this.broker.getIteratorByQuery(query);
            Assert.assertTrue((String)"size of collection should be zero", (!iter.hasNext() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            Iterator i1 = this.broker.getIteratorByQuery(query);
            Iterator i2 = this.broker.getIteratorByQuery(query);
            Iterator i3 = this.broker.getIteratorByQuery(query);
            int i = 0;
            while (i < 3) {
                Assert.assertTrue((String)"should have more elements", (boolean)i3.hasNext());
                Assert.assertTrue((String)"should have more elements", (boolean)i1.hasNext());
                Assert.assertTrue((String)"should have more elements", (boolean)i2.hasNext());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i2.next()).getArticleName());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i1.next()).getArticleName());
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)((InterfaceArticle)i3.next()).getArticleName());
                ++i;
            }
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetObjectByQuery() {
        try {
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Query query = QueryFactory.newQuery(a);
            Article b = (Article)this.broker.getObjectByQuery(query);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            Article c = this.readArticleByExample(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)c.getArticleName());
            Criteria crit = new Criteria();
            crit.addEqualTo("articleId", new Integer(a.getArticleId()));
            Query q = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, crit);
            InterfaceArticle d = (InterfaceArticle)this.broker.getObjectByQuery(q);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)d.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testGetPKEnumerationByConstraints() {
        try {
            String name = "CollectionTestArticle";
            Criteria criteria = new Criteria();
            criteria.addEqualTo("articleName", name);
            Query query = QueryFactory.newQuery(class$test$ojb$broker$Article == null ? (class$test$ojb$broker$Article = PersistenceBrokerTest.class$("test.ojb.broker.Article")) : class$test$ojb$broker$Article, criteria);
            Enumeration enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            while (enumeration.hasMoreElements()) {
                ArticlePrimaryKey pk = (ArticlePrimaryKey)enumeration.nextElement();
                this.deleteArticle(pk.id);
            }
            enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            Assert.assertTrue((String)"size of collection should be zero", (!enumeration.hasMoreElements() ? 1 : 0) != 0);
            int id1 = 4001;
            int id2 = 4002;
            int id3 = 4003;
            Article a1 = this.createArticle(id1);
            a1.setArticleName(name);
            this.broker.store(a1);
            Article a2 = this.createArticle(id2);
            a2.setArticleName(name);
            this.broker.store(a2);
            Article a3 = this.createArticle(id3);
            a3.setArticleName(name);
            this.broker.store(a3);
            enumeration = this.broker.getPKEnumerationByQuery(class$test$ojb$broker$ArticlePrimaryKey == null ? (class$test$ojb$broker$ArticlePrimaryKey = PersistenceBrokerTest.class$("test.ojb.broker.ArticlePrimaryKey")) : class$test$ojb$broker$ArticlePrimaryKey, query);
            int count = 0;
            while (enumeration.hasMoreElements()) {
                ++count;
                Article tmp = this.readArticleByIdentity(((ArticlePrimaryKey)enumeration.nextElement()).id);
                Assert.assertEquals((String)"should be same value", (Object)name, (Object)tmp.getArticleName());
            }
            Assert.assertEquals((String)"Iterator should produce 3 items", (int)3, (int)count);
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().error(t);
            Assert.fail((String)t.getMessage());
        }
    }

    public void testInsert() {
        try {
            Article a = this.createArticle(this.testId);
            this.deleteArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertNull((String)"should be null after deletion", (Object)b);
            this.storeArticle(a);
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            b = null;
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting and flushing the cache an object should still be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testUpdate() {
        try {
            this.deleteArticle(this.testId);
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String newname = "TESTUPDATE";
            b.setArticleName(newname);
            this.storeArticle(b);
            b = null;
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update", (Object)newname, (Object)b.getArticleName());
            b = null;
            this.broker.clearCache();
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update and db lookup", (Object)newname, (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    public void testUpdateWithModification() {
        try {
            ObjectModificationDefaultImpl modification = new ObjectModificationDefaultImpl();
            Assert.assertTrue((String)"should not be marked for update yet", (!modification.needsUpdate() ? 1 : 0) != 0);
            Assert.assertTrue((String)"should not be marked for insert", (!modification.needsInsert() ? 1 : 0) != 0);
            Article a = this.createArticle(this.testId);
            this.storeArticle(a);
            Article b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"after inserting an object it should be equal to its re-read pendant", (Object)a.getArticleName(), (Object)b.getArticleName());
            String newname = "TESTUPDATE";
            b.setArticleName(newname);
            modification.markModified();
            Assert.assertTrue((String)"should be marked for update", (boolean)modification.needsUpdate());
            Assert.assertTrue((String)"should not be marked for insert", (!modification.needsInsert() ? 1 : 0) != 0);
            this.broker.store(b, modification);
            b = null;
            b = this.readArticleByIdentity(this.testId);
            Assert.assertEquals((String)"should be equal after update", (Object)newname, (Object)b.getArticleName());
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

